/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.http.ErrorCodeParser;
import com.amazonaws.internal.http.JsonErrorMessageParser;
import com.amazonaws.protocol.json.JsonContent;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.rpcv2cbor.EnhancedRpcV2CborErrorUnmarshaller;
import com.amazonaws.transform.rpcv2cbor.RpcV2CborUnmarshallerContext;
import com.amazonaws.transform.rpcv2cbor.RpcV2CborUnmarshallerContextImpl;
import com.amazonaws.util.CollectionUtils;
import com.amazonaws.util.StringUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public class RpcV2CborErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log LOG = LogFactory.getLog(RpcV2CborErrorResponseHandler.class);
    private final List<JsonErrorUnmarshaller> unmarshallers;
    private final ErrorCodeParser errorCodeParser;
    private final JsonErrorMessageParser errorMessageParser;
    private final CBORFactory cborFactory;
    private static final String QUERY_ERROR_DELIMITER = ";";
    private final Map<Class<?>, Unmarshaller<?, RpcV2CborUnmarshallerContext>> simpleTypeUnmarshallers;
    private final Map<RpcV2CborUnmarshallerContext.UnmarshallerType, Unmarshaller<?, RpcV2CborUnmarshallerContext>> customTypeUnmarshallers;
    private boolean hasAwsQueryCompatible;

    public RpcV2CborErrorResponseHandler(List<JsonErrorUnmarshaller> errorUnmarshallers, ErrorCodeParser errorCodeParser, JsonErrorMessageParser errorMessageParser, CBORFactory cborFactory) {
        this(errorUnmarshallers, errorCodeParser, false, errorMessageParser, cborFactory);
    }

    public RpcV2CborErrorResponseHandler(List<JsonErrorUnmarshaller> errorUnmarshallers, ErrorCodeParser errorCodeParser, boolean hasAwsQueryCompatible, JsonErrorMessageParser errorMessageParser, CBORFactory cborFactory) {
        this.unmarshallers = errorUnmarshallers;
        this.simpleTypeUnmarshallers = null;
        this.customTypeUnmarshallers = null;
        this.errorCodeParser = errorCodeParser;
        this.hasAwsQueryCompatible = hasAwsQueryCompatible;
        this.errorMessageParser = errorMessageParser;
        this.cborFactory = cborFactory;
    }

    public RpcV2CborErrorResponseHandler(List<JsonErrorUnmarshaller> errorUnmarshallers, Map<Class<?>, Unmarshaller<?, RpcV2CborUnmarshallerContext>> simpleTypeUnmarshallers, Map<RpcV2CborUnmarshallerContext.UnmarshallerType, Unmarshaller<?, RpcV2CborUnmarshallerContext>> customTypeUnmarshallers, ErrorCodeParser errorCodeParser, JsonErrorMessageParser errorMessageParser, CBORFactory cborFactory) {
        this(errorUnmarshallers, simpleTypeUnmarshallers, customTypeUnmarshallers, errorCodeParser, false, errorMessageParser, cborFactory);
    }

    public RpcV2CborErrorResponseHandler(List<JsonErrorUnmarshaller> errorUnmarshallers, Map<Class<?>, Unmarshaller<?, RpcV2CborUnmarshallerContext>> simpleTypeUnmarshallers, Map<RpcV2CborUnmarshallerContext.UnmarshallerType, Unmarshaller<?, RpcV2CborUnmarshallerContext>> customTypeUnmarshallers, ErrorCodeParser errorCodeParser, boolean hasAwsQueryCompatible, JsonErrorMessageParser errorMessageParser, CBORFactory cborFactory) {
        this.unmarshallers = errorUnmarshallers;
        this.simpleTypeUnmarshallers = simpleTypeUnmarshallers;
        this.customTypeUnmarshallers = customTypeUnmarshallers;
        this.errorCodeParser = errorCodeParser;
        this.hasAwsQueryCompatible = hasAwsQueryCompatible;
        this.errorMessageParser = errorMessageParser;
        this.cborFactory = cborFactory;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    @Override
    public AmazonServiceException handle(HttpResponse response) throws Exception {
        JsonContent rpcv2cborContent = JsonContent.createJsonContent(response, this.cborFactory);
        byte[] rawContent = rpcv2cborContent.getRawContent();
        String errorCode = this.errorCodeParser.parseErrorCode(response, rpcv2cborContent);
        AmazonServiceException ase = this.createException(errorCode, response, rpcv2cborContent.getJsonNode(), rawContent);
        if (ase.getErrorMessage() == null) {
            ase.setErrorMessage(this.errorMessageParser.parseErrorMessage(response, rpcv2cborContent.getJsonNode()));
        }
        ase.setErrorCode(this.getEffectiveErrorCode(response, errorCode));
        ase.setServiceName(response.getRequest().getServiceName());
        ase.setStatusCode(response.getStatusCode());
        ase.setErrorType(this.getErrorTypeFromStatusCode(response.getStatusCode()));
        ase.setRawResponse(rawContent);
        String requestId = this.getRequestIdFromHeaders(response.getHeaders());
        if (requestId != null) {
            ase.setRequestId(requestId);
        }
        ase.setHttpHeaders(response.getHeaders());
        return ase;
    }

    private AmazonServiceException createException(String errorCode, HttpResponse response, JsonNode JsonNode2, byte[] rawContent) {
        AmazonServiceException ase = this.unmarshallException(errorCode, response, JsonNode2, rawContent);
        if (ase == null) {
            ase = new AmazonServiceException("Unable to unmarshall exception response with the unmarshallers provided");
        }
        return ase;
    }

    private AmazonServiceException unmarshallException(String errorCode, HttpResponse response, JsonNode JsonNode2, byte[] rawContent) {
        for (JsonErrorUnmarshaller unmarshaller : this.unmarshallers) {
            if (!unmarshaller.matchErrorCode(errorCode)) continue;
            try {
                if (unmarshaller instanceof EnhancedRpcV2CborErrorUnmarshaller) {
                    EnhancedRpcV2CborErrorUnmarshaller enhancedUnmarshaller = (EnhancedRpcV2CborErrorUnmarshaller)unmarshaller;
                    return this.doEnhancedUnmarshall(enhancedUnmarshaller, errorCode, response, rawContent);
                }
                return this.doLegacyUnmarshall(unmarshaller, JsonNode2);
            }
            catch (Exception e) {
                LOG.debug("Unable to unmarshall exception content", e);
                return null;
            }
        }
        return null;
    }

    private AmazonServiceException doEnhancedUnmarshall(EnhancedRpcV2CborErrorUnmarshaller unmarshaller, String errorCode, HttpResponse response, byte[] rawContent) throws Exception {
        byte[] contentBytes = rawContent != null ? rawContent : new byte[]{};
        CBORParser cborParser = this.cborFactory.createParser(contentBytes);
        RpcV2CborUnmarshallerContextImpl unmarshallerContext = new RpcV2CborUnmarshallerContextImpl(cborParser, this.simpleTypeUnmarshallers, this.customTypeUnmarshallers, response);
        try {
            return unmarshaller.unmarshallFromContext(unmarshallerContext);
        }
        catch (JsonParseException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Received response with error code '%s', but response body did not contain valid CBOR. Treating it as an empty object.", errorCode), e);
            }
            CBORParser emptyParser = this.cborFactory.createParser(new byte[0]);
            unmarshallerContext = new RpcV2CborUnmarshallerContextImpl(emptyParser, this.simpleTypeUnmarshallers, this.customTypeUnmarshallers, response);
            return unmarshaller.unmarshallFromContext(unmarshallerContext);
        }
    }

    private AmazonServiceException doLegacyUnmarshall(JsonErrorUnmarshaller unmarshaller, JsonNode JsonNode2) throws Exception {
        return unmarshaller.unmarshall(JsonNode2);
    }

    private AmazonServiceException.ErrorType getErrorTypeFromStatusCode(int statusCode) {
        return statusCode < 500 ? AmazonServiceException.ErrorType.Client : AmazonServiceException.ErrorType.Service;
    }

    private String getRequestIdFromHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            if (headerEntry.getKey().equalsIgnoreCase("x-amzn-RequestId")) {
                return headerEntry.getValue();
            }
            if (!headerEntry.getKey().equalsIgnoreCase("x-amz-request-id")) continue;
            return headerEntry.getValue();
        }
        return null;
    }

    private String getEffectiveErrorCode(HttpResponse response, String errorCode) {
        String compatibleErrorCode;
        if (this.hasAwsQueryCompatible && !StringUtils.isNullOrEmpty(compatibleErrorCode = this.queryCompatibleErrorCodeFromResponse(response))) {
            return compatibleErrorCode;
        }
        return errorCode;
    }

    private String queryCompatibleErrorCodeFromResponse(HttpResponse response) {
        String queryHeaderValue;
        List<String> headerValues = response.getHeaderValues("x-amzn-query-error");
        if (!CollectionUtils.isNullOrEmpty(headerValues) && !StringUtils.isNullOrEmpty(queryHeaderValue = headerValues.get(0))) {
            return this.parseQueryErrorCodeFromDelimiter(queryHeaderValue);
        }
        return null;
    }

    private String parseQueryErrorCodeFromDelimiter(String queryHeaderValue) {
        int delimiter = queryHeaderValue.indexOf(QUERY_ERROR_DELIMITER);
        if (delimiter > 0) {
            return queryHeaderValue.substring(0, delimiter);
        }
        return null;
    }
}

