/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.ByteRangeSpec;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.storage.v2.BidiReadObjectResponse;
import com.google.storage.v2.BidiWriteObjectRequest;
import com.google.storage.v2.BucketAccessControl;
import com.google.storage.v2.ChecksummedData;
import com.google.storage.v2.ObjectAccessControl;
import com.google.storage.v2.ObjectRangeData;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import com.google.storage.v2.WriteObjectRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;

final class StorageV2ProtoUtils {
    private static final String VALIDATION_TEMPLATE = "offset >= 0 && limit >= 0 (%s >= 0 && %s >= 0)";

    private StorageV2ProtoUtils() {
    }

    static @NonNull ReadObjectRequest seekReadObjectRequest(@NonNull ReadObjectRequest request, @NonNull ByteRangeSpec byteRangeSpec) {
        boolean setLimit;
        long offset = byteRangeSpec.beginOffset();
        long limit = byteRangeSpec.length();
        ReadObjectRequest req = request;
        boolean setOffset = offset > 0L && offset != req.getReadOffset();
        boolean bl = setLimit = limit < Long.MAX_VALUE && limit != req.getReadLimit();
        if (setOffset || setLimit) {
            req = byteRangeSpec.seekReadObjectRequest(req.toBuilder()).build();
        }
        return req;
    }

    public static @NonNull String fmtProto(@NonNull Object obj) {
        return StorageV2ProtoUtils.fmtProtoWithFmt(obj, TextFormat.printer()::shortDebugString);
    }

    public static @NonNull String fmtProtoWithFmt(@NonNull Object obj, MsgFmt fmt) {
        if (obj instanceof WriteObjectRequest) {
            return StorageV2ProtoUtils.fmtProtoWithFmt((WriteObjectRequest)obj, fmt);
        }
        if (obj instanceof BidiWriteObjectRequest) {
            return StorageV2ProtoUtils.fmtProtoWithFmt((BidiWriteObjectRequest)obj, fmt);
        }
        if (obj instanceof ReadObjectResponse) {
            return StorageV2ProtoUtils.fmtProtoWithFmt((ReadObjectResponse)obj, fmt);
        }
        if (obj instanceof BidiReadObjectResponse) {
            return StorageV2ProtoUtils.fmtProtoWithFmt((BidiReadObjectResponse)obj, fmt);
        }
        if (obj instanceof ChecksummedData) {
            return StorageV2ProtoUtils.fmtProtoWithFmt((ChecksummedData)obj, fmt);
        }
        if (obj instanceof MessageOrBuilder) {
            return (String)fmt.apply((MessageOrBuilder)obj);
        }
        return obj.toString();
    }

    private static @NonNull String fmtProtoWithFmt(ChecksummedData data, MsgFmt fmt) {
        ByteString content = data.getContent();
        if (content.size() > 20) {
            ChecksummedData.Builder b = data.toBuilder();
            ByteString trim = StorageV2ProtoUtils.snipBytes(content);
            b.setContent(trim);
            return (String)fmt.apply(b.build());
        }
        return (String)fmt.apply(data);
    }

    private static @NonNull String fmtProtoWithFmt(@NonNull WriteObjectRequest msg, MsgFmt fmt) {
        ByteString content;
        if (msg.hasChecksummedData() && (content = msg.getChecksummedData().getContent()).size() > 20) {
            WriteObjectRequest.Builder b = msg.toBuilder();
            ByteString trim = StorageV2ProtoUtils.snipBytes(content);
            b.getChecksummedDataBuilder().setContent(trim);
            return (String)fmt.apply(b.build());
        }
        return (String)fmt.apply(msg);
    }

    private static @NonNull String fmtProtoWithFmt(@NonNull BidiWriteObjectRequest msg, MsgFmt fmt) {
        ByteString content;
        if (msg.hasChecksummedData() && (content = msg.getChecksummedData().getContent()).size() > 20) {
            BidiWriteObjectRequest.Builder b = msg.toBuilder();
            ByteString trim = StorageV2ProtoUtils.snipBytes(content);
            b.getChecksummedDataBuilder().setContent(trim);
            return (String)fmt.apply(b.build());
        }
        return (String)fmt.apply(msg);
    }

    private static @NonNull String fmtProtoWithFmt(@NonNull ReadObjectResponse msg, MsgFmt fmt) {
        ByteString content;
        if (msg.hasChecksummedData() && (content = msg.getChecksummedData().getContent()).size() > 20) {
            ReadObjectResponse.Builder b = msg.toBuilder();
            ByteString trim = StorageV2ProtoUtils.snipBytes(content);
            b.getChecksummedDataBuilder().setContent(trim);
            return (String)fmt.apply(b.build());
        }
        return (String)fmt.apply(msg);
    }

    private static @NonNull String fmtProtoWithFmt(@NonNull BidiReadObjectResponse msg, MsgFmt fmt) {
        List<ObjectRangeData> rangeData = msg.getObjectDataRangesList();
        if (!rangeData.isEmpty()) {
            ArrayList<ObjectRangeData> snips = new ArrayList<ObjectRangeData>();
            for (ObjectRangeData rd : rangeData) {
                if (!rd.hasChecksummedData()) continue;
                ByteString content = rd.getChecksummedData().getContent();
                if (content.size() > 20) {
                    ObjectRangeData.Builder b = rd.toBuilder();
                    ByteString trim = StorageV2ProtoUtils.snipBytes(content);
                    b.getChecksummedDataBuilder().setContent(trim);
                    snips.add(b.build());
                    continue;
                }
                snips.add(rd);
            }
            BidiReadObjectResponse snipped = msg.toBuilder().clearObjectDataRanges().addAllObjectDataRanges(snips).build();
            return (String)fmt.apply(snipped);
        }
        return (String)fmt.apply(msg);
    }

    private static ByteString snipBytes(ByteString content) {
        ByteString snip = ByteString.copyFromUtf8(String.format(Locale.US, "<snip (%d)>", content.size()));
        return content.substring(0, 20).concat(snip);
    }

    static Predicate<ObjectAccessControl> objectAclEntityOrAltEq(String s2) {
        return oAcl -> oAcl.getEntity().equals(s2) || oAcl.getEntityAlt().equals(s2);
    }

    static Predicate<BucketAccessControl> bucketAclEntityOrAltEq(String s2) {
        return oAcl -> oAcl.getEntity().equals(s2) || oAcl.getEntityAlt().equals(s2);
    }

    @FunctionalInterface
    static interface MsgFmt
    extends Function<MessageOrBuilder, String> {
    }
}

