/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.storage.Buffers;
import com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;

final class MinFlushBufferedWritableByteChannel
implements BufferedWritableByteChannelSession.BufferedWritableByteChannel {
    private final BufferHandle handle;
    private final UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel channel;
    private final boolean blocking;

    MinFlushBufferedWritableByteChannel(BufferHandle handle, UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel channel) {
        this(handle, channel, true);
    }

    MinFlushBufferedWritableByteChannel(BufferHandle handle, UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel channel, boolean blocking) {
        this.handle = handle;
        this.channel = channel;
        this.blocking = blocking;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!this.channel.isOpen()) {
            throw new ClosedChannelException();
        }
        int bytesConsumed = 0;
        while (Buffers.hasRemaining(src)) {
            ByteBuffer[] srcs;
            int bufferRemaining;
            int srcRemaining = Buffers.remaining(src);
            if (srcRemaining < (bufferRemaining = this.handle.remaining())) {
                ((ByteBuffer)this.handle.get()).put(src);
                bytesConsumed += srcRemaining;
                break;
            }
            int capacity = this.handle.capacity();
            int position = this.handle.position();
            int bufferPending = capacity - bufferRemaining;
            int totalPending = Math.addExact(srcRemaining, bufferPending);
            boolean usingBuffer = false;
            if (this.enqueuedBytes()) {
                usingBuffer = true;
                ByteBuffer buffer = (ByteBuffer)this.handle.get();
                Buffers.flip(buffer);
                srcs = new ByteBuffer[]{buffer, src};
            } else {
                srcs = new ByteBuffer[]{src};
            }
            long written = this.channel.write(srcs);
            Preconditions.checkState(written >= 0L, "written >= 0 (%s > 0)", written);
            if (usingBuffer) {
                if (written >= (long)bufferPending) {
                    Buffers.clear((Buffer)this.handle.get());
                } else if (written > 0L) {
                    Buffers.compact((ByteBuffer)this.handle.get());
                } else {
                    Buffers.position((Buffer)this.handle.get(), position);
                    Buffers.limit((Buffer)this.handle.get(), capacity);
                }
            }
            int srcConsumed = Math.max(0, Math.toIntExact(written) - bufferPending);
            bytesConsumed += srcConsumed;
            if (this.blocking || written == (long)totalPending) continue;
            break;
        }
        return bytesConsumed;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.enqueuedBytes()) {
            ByteBuffer buffer = (ByteBuffer)this.handle.get();
            Buffers.flip(buffer);
            this.channel.writeAndClose(buffer);
            if (buffer.hasRemaining()) {
                buffer.compact();
            } else {
                Buffers.clear(buffer);
            }
        } else {
            this.channel.close();
        }
    }

    @Override
    public void flush() throws IOException {
        while (this.enqueuedBytes()) {
            ByteBuffer buffer = (ByteBuffer)this.handle.get();
            Buffers.flip(buffer);
            this.channel.write(buffer);
            if (buffer.hasRemaining()) {
                buffer.compact();
                continue;
            }
            Buffers.clear(buffer);
        }
    }

    private boolean enqueuedBytes() {
        return this.handle.position() > 0;
    }
}

