/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.BaseServiceException;
import com.google.cloud.storage.BidiUploadState;
import com.google.cloud.storage.ChunkSegmenter;
import com.google.cloud.storage.Crc32cValue;
import com.google.cloud.storage.GrpcUtils;
import com.google.cloud.storage.MaxRedirectsExceededException;
import com.google.cloud.storage.RetryContext;
import com.google.cloud.storage.StorageException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.storage.v2.BidiWriteObjectRedirectedError;
import com.google.storage.v2.BidiWriteObjectRequest;
import com.google.storage.v2.BidiWriteObjectResponse;
import com.google.storage.v2.ObjectChecksums;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

final class BidiUploadStreamingStream {
    private final BidiUploadState state;
    private final BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> write;
    private final ScheduledExecutorService executor;
    private final RetryContext retryContext;
    private final RetryContext.OnSuccess onSuccess;
    private final RetryContext.OnFailure<Throwable> onFailure;
    private final ReentrantLock lock;
    private final int maxRedirectsAllowed;
    private final AtomicInteger redirectCounter;
    private volatile @Nullable StreamTuple stream;
    private volatile @Nullable ApiFuture<Void> pendingReconciliation;

    BidiUploadStreamingStream(BidiUploadState state, ScheduledExecutorService executor, BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> write, int maxRedirectsAllowed, RetryContext retryContext) {
        this.state = state;
        this.executor = executor;
        this.write = write;
        this.lock = new ReentrantLock();
        this.retryContext = new StreamRetryContextDecorator(retryContext, this.lock, this::reset);
        this.onSuccess = this::restart;
        this.onFailure = t2 -> {
            SettableApiFuture<BidiWriteObjectResponse> resultFuture = state.getResultFuture();
            if (!resultFuture.isDone()) {
                this.state.terminalError();
                BaseServiceException coalesced = StorageException.coalesce(t2);
                resultFuture.setException(coalesced);
            }
        };
        this.maxRedirectsAllowed = maxRedirectsAllowed;
        this.redirectCounter = new AtomicInteger();
    }

    public ApiFuture<BidiWriteObjectResponse> getResultFuture() {
        return this.state.getResultFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean append(@NonNull ChunkSegmenter.ChunkSegment data) {
        this.lock.lock();
        try {
            boolean offered = this.state.offer(data);
            if (offered) {
                this.internalSend();
            }
            boolean bl = offered;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendAndFlush(@NonNull ChunkSegmenter.ChunkSegment data) {
        this.lock.lock();
        try {
            boolean offered = this.state.offer(data);
            if (offered) {
                this.flush();
            }
            boolean bl = offered;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendAndFinalize(@NonNull ChunkSegmenter.ChunkSegment data) {
        this.lock.lock();
        try {
            boolean offered = this.state.offer(data);
            if (offered) {
                this.finishWrite(this.state.getTotalSentBytes());
            }
            boolean bl = offered;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void flush() {
        this.lock.lock();
        try {
            BidiWriteObjectRequest flush = BidiWriteObjectRequest.newBuilder().setWriteOffset(this.state.getTotalSentBytes()).setFlush(true).setStateLookup(true).build();
            if (flush.equals(this.state.peekLast())) {
                this.internalSend();
                return;
            }
            boolean offered = this.state.offer(flush);
            if (offered) {
                this.internalSend();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishWrite(long length) {
        this.lock.lock();
        try {
            BidiWriteObjectRequest msg;
            boolean offer;
            if (this.state.isFinalizing() && this.state.getTotalSentBytes() == length) {
                boolean bl = true;
                return bl;
            }
            BidiWriteObjectRequest.Builder b = BidiWriteObjectRequest.newBuilder().setWriteOffset(length).setFinishWrite(true);
            Crc32cValue.Crc32cLengthKnown cumulativeCrc32c = this.state.getCumulativeCrc32c();
            if (cumulativeCrc32c != null) {
                b.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(cumulativeCrc32c.getValue()).build());
            }
            if (offer = this.state.offer(msg = b.build())) {
                this.internalSend();
            }
            boolean bl = offer;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeStream(long length) {
        this.lock.lock();
        try {
            boolean offer = this.state.finalFlush(length);
            if (offer) {
                this.internalSend();
            }
            boolean bl = offer;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void sendClose() {
        this.lock.lock();
        try {
            StreamTuple tmp = this.getStream();
            if (tmp != null) {
                tmp.closeSend();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void awaitTakeoverStateReconciliation() {
        this.state.awaitTakeoverStateReconciliation(this::restart);
    }

    void awaitAckOf(long writeOffset) throws InterruptedException {
        this.state.awaitAck(writeOffset);
    }

    long availableCapacity() {
        return this.state.availableCapacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void restart() {
        this.lock.lock();
        try {
            Preconditions.checkState(this.stream == null, "attempting to restart stream when stream is already active");
            this.state.retrying();
            ApiFuture<Void> reconciliation = this.state.beginReconciliation();
            ApiFuture<Void> tmpPendingReconciliation = this.pendingReconciliation;
            StreamTuple tmp = this.initStreamTuple();
            this.state.sendVia(tmp);
            if (reconciliation != tmpPendingReconciliation) {
                ApiFutures.addCallback(reconciliation, new ApiFutureCallback<Void>(){

                    @Override
                    public void onFailure(Throwable t2) {
                        BidiUploadStreamingStream.this.lock.lock();
                        try {
                            BidiUploadStreamingStream.this.pendingReconciliation = null;
                        }
                        finally {
                            BidiUploadStreamingStream.this.lock.unlock();
                        }
                        BidiUploadStreamingStream.this.retryContext.recordError(t2, BidiUploadStreamingStream.this.onSuccess, BidiUploadStreamingStream.this.onFailure);
                    }

                    @Override
                    public void onSuccess(Void result) {
                        BidiUploadStreamingStream.this.lock.lock();
                        try {
                            BidiUploadStreamingStream.this.pendingReconciliation = null;
                        }
                        finally {
                            BidiUploadStreamingStream.this.lock.unlock();
                        }
                        StreamTuple tmp = BidiUploadStreamingStream.this.getStream();
                        if (tmp != null) {
                            BidiUploadStreamingStream.this.state.sendVia(tmp);
                        }
                    }
                }, this.executor);
                this.pendingReconciliation = reconciliation;
            }
            this.stream = tmp;
        }
        catch (Throwable t2) {
            this.retryContext.recordError(t2, this.onSuccess, this.onFailure);
        }
        finally {
            this.lock.unlock();
        }
    }

    @VisibleForTesting
    void reset() {
        this.lock.lock();
        try {
            StreamTuple tmp = this.stream;
            if (tmp != null) {
                tmp.in.flagTombstoned();
                tmp.closeSend();
                this.stream = null;
                this.state.pendingRetry();
            }
        }
        catch (Throwable t2) {
            this.retryContext.recordError(t2, this.onSuccess, this.onFailure);
        }
        finally {
            this.lock.unlock();
        }
    }

    private @Nullable StreamTuple getStream() {
        if (this.stream == null && this.state.getState() == BidiUploadState.State.INITIALIZING) {
            this.stream = this.initStreamTuple();
        }
        return this.stream;
    }

    private StreamTuple initStreamTuple() {
        GrpcCallContext grpcCallContext = this.state.enqueueFirstMessageAndGetGrpcCallContext();
        StreamingResponseObserver streamResponseObserver = new StreamingResponseObserver(this.state, this.retryContext, this.onSuccess, this.onFailure);
        RedirectHandlingResponseObserver responseObserver = new RedirectHandlingResponseObserver(this.state, streamResponseObserver, this.redirectCounter, this.maxRedirectsAllowed, this::reset, () -> this.executor.execute(this::restart));
        ClientStream<BidiWriteObjectRequest> clientStream = this.write.splitCall(responseObserver, grpcCallContext);
        GracefulOutboundStream out = new GracefulOutboundStream(clientStream);
        return new StreamTuple(out, responseObserver);
    }

    private void internalSend() {
        StreamTuple tmp = this.getStream();
        if (tmp != null) {
            this.state.sendVia(tmp);
        }
    }

    private static final class StreamTuple
    implements Consumer<BidiWriteObjectRequest> {
        private final ClientStream<BidiWriteObjectRequest> out;
        private final RedirectHandlingResponseObserver in;

        StreamTuple(ClientStream<BidiWriteObjectRequest> out, RedirectHandlingResponseObserver in) {
            this.out = out;
            this.in = in;
        }

        @Override
        public void accept(BidiWriteObjectRequest bidiWriteObjectRequest) {
            this.out.send(bidiWriteObjectRequest);
        }

        public void closeSend() {
            this.in.flagTombstoned();
            this.out.closeSend();
        }
    }

    @VisibleForTesting
    static final class StreamRetryContextDecorator
    implements RetryContext {
        private final RetryContext retryContext;
        private final ReentrantLock lock;
        private final Runnable onRecordError;

        @VisibleForTesting
        StreamRetryContextDecorator(RetryContext retryContext, ReentrantLock lock, Runnable onRecordError) {
            this.retryContext = retryContext;
            this.lock = lock;
            this.onRecordError = onRecordError;
        }

        @Override
        public boolean inBackoff() {
            return this.retryContext.inBackoff();
        }

        @Override
        public void reset() {
            this.retryContext.reset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T extends Throwable> void recordError(T t2, RetryContext.OnSuccess onSuccess, RetryContext.OnFailure<T> onFailure) {
            this.lock.lock();
            try {
                try {
                    this.onRecordError.run();
                }
                catch (Throwable tt) {
                    t2.addSuppressed(tt);
                    onFailure.onFailure(t2);
                    this.lock.unlock();
                    return;
                }
                this.retryContext.recordError(t2, onSuccess, onFailure);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    static final class RedirectHandlingResponseObserver
    implements ResponseObserver<BidiWriteObjectResponse> {
        private final BidiUploadState state;
        private final ResponseObserver<BidiWriteObjectResponse> delegate;
        private final AtomicInteger redirectCounter;
        private final int maxRedirectsAllowed;
        private final Runnable beforeRedirect;
        private final Runnable onRedirect;
        private volatile boolean tombstoned;

        RedirectHandlingResponseObserver(BidiUploadState state, ResponseObserver<BidiWriteObjectResponse> delegate, AtomicInteger redirectCounter, int maxRedirectsAllowed, Runnable beforeRedirect, Runnable onRedirect) {
            this.state = state;
            this.delegate = delegate;
            this.redirectCounter = redirectCounter;
            this.maxRedirectsAllowed = maxRedirectsAllowed;
            this.beforeRedirect = beforeRedirect;
            this.onRedirect = onRedirect;
            this.tombstoned = false;
        }

        void flagTombstoned() {
            this.tombstoned = true;
        }

        @Override
        public void onStart(StreamController controller) {
            if (this.tombstoned) {
                return;
            }
            this.delegate.onStart(controller);
        }

        @Override
        public void onResponse(BidiWriteObjectResponse response) {
            if (this.tombstoned) {
                return;
            }
            this.redirectCounter.set(0);
            this.delegate.onResponse(response);
        }

        @Override
        public void onError(Throwable t2) {
            if (this.tombstoned) {
                return;
            }
            BidiWriteObjectRedirectedError error = GrpcUtils.getBidiWriteObjectRedirectedError(t2);
            if (error == null) {
                this.delegate.onError(t2);
                return;
            }
            int redirectCount = this.redirectCounter.incrementAndGet();
            if (redirectCount > this.maxRedirectsAllowed) {
                t2.addSuppressed(new MaxRedirectsExceededException(this.maxRedirectsAllowed, redirectCount));
                this.delegate.onError(t2);
                return;
            }
            this.beforeRedirect.run();
            this.state.updateFromRedirect(error);
            this.onRedirect.run();
        }

        @Override
        public void onComplete() {
            if (this.tombstoned) {
                return;
            }
            this.delegate.onComplete();
        }
    }

    static final class StreamingResponseObserver
    implements ResponseObserver<BidiWriteObjectResponse> {
        private final BidiUploadState state;
        private final RetryContext retryContext;
        private final RetryContext.OnSuccess onSuccess;
        private final RetryContext.OnFailure<Throwable> onFailure;
        private @MonotonicNonNull StreamController controller;

        StreamingResponseObserver(BidiUploadState state, RetryContext retryContext, RetryContext.OnSuccess onSuccess, RetryContext.OnFailure<Throwable> onFailure) {
            this.state = state;
            this.retryContext = retryContext;
            this.onSuccess = onSuccess;
            this.onFailure = onFailure;
        }

        @Override
        @EnsuresNonNull(value={"controller"})
        public void onStart(StreamController controller) {
            this.controller = controller;
            controller.disableAutoInboundFlowControl();
            controller.request(1);
        }

        @Override
        @RequiresNonNull(value={"controller"})
        public void onResponse(BidiWriteObjectResponse response) {
            try {
                this.controller.request(1);
                @Nullable StorageException se = this.state.onResponse(response);
                if (se != null) {
                    this.retryContext.recordError(se, this.onSuccess, this.onFailure);
                }
            }
            catch (Throwable t2) {
                this.retryContext.recordError(t2, this.onSuccess, this.onFailure);
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.retryContext.recordError(t2, this.onSuccess, this.onFailure);
        }

        @Override
        public void onComplete() {
        }
    }

    private static final class GracefulOutboundStream
    implements ClientStream<BidiWriteObjectRequest> {
        private final ClientStream<BidiWriteObjectRequest> delegate;
        private volatile boolean closing;

        private GracefulOutboundStream(ClientStream<BidiWriteObjectRequest> delegate) {
            this.delegate = delegate;
            this.closing = false;
        }

        @Override
        public boolean isSendReady() {
            return this.delegate.isSendReady();
        }

        @Override
        public void send(BidiWriteObjectRequest request) {
            this.delegate.send(request);
        }

        @Override
        public void closeSendWithError(Throwable t2) {
            if (this.closing) {
                return;
            }
            this.closing = true;
            this.delegate.closeSendWithError(t2);
        }

        @Override
        public void closeSend() {
            if (this.closing) {
                return;
            }
            this.closing = true;
            this.delegate.closeSend();
        }
    }
}

