/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.pipesiterator.gcs;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.HandlerConfig;
import org.apache.tika.pipes.emitter.EmitKey;
import org.apache.tika.pipes.fetcher.FetchKey;
import org.apache.tika.pipes.pipesiterator.PipesIterator;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCSPipesIterator
extends PipesIterator
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GCSPipesIterator.class);
    private String prefix = "";
    private String projectId = "";
    private String bucket;
    private Storage storage;

    @Field
    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @Field
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Field
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        this.storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(this.projectId)).build().getService();
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        super.checkInitialization(problemHandler);
        TikaConfig.mustNotBeEmpty((String)"bucket", (String)this.bucket);
        TikaConfig.mustNotBeEmpty((String)"projectId", (String)this.projectId);
    }

    protected void enqueue() throws InterruptedException, IOException, TimeoutException {
        String fetcherName = this.getFetcherName();
        String emitterName = this.getEmitterName();
        long start = System.currentTimeMillis();
        int count = 0;
        HandlerConfig handlerConfig = this.getHandlerConfig();
        Page<Blob> blobs = null;
        blobs = StringUtils.isBlank((String)this.prefix) ? this.storage.list(this.bucket, new Storage.BlobListOption[0]) : this.storage.list(this.bucket, Storage.BlobListOption.prefix(this.prefix));
        for (Blob blob : blobs.iterateAll()) {
            if (blob.getSize() == 0L) continue;
            long elapsed = System.currentTimeMillis() - start;
            LOGGER.debug("adding ({}) {} in {} ms", count, blob.getName(), elapsed);
            ParseContext parseContext = new ParseContext();
            parseContext.set(HandlerConfig.class, (Object)handlerConfig);
            this.tryToAdd(new FetchEmitTuple(blob.getName(), new FetchKey(fetcherName, blob.getName()), new EmitKey(emitterName, blob.getName()), new Metadata(), parseContext, this.getOnParseException()));
            ++count;
        }
        long elapsed = System.currentTimeMillis() - start;
        LOGGER.info("finished enqueuing {} files in {} ms", (Object)count, (Object)elapsed);
    }
}

