/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.errorprone.annotations.CheckReturnValue;
import io.grpc.rls.LruCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

abstract class LinkedHashLruCache<K, V>
implements LruCache<K, V> {
    private final LinkedHashMap<K, SizedValue> delegate;
    private final Ticker ticker;
    private final LruCache.EvictionListener<K, SizedValue> evictionListener;
    private long estimatedSizeBytes;
    private long estimatedMaxSizeBytes;

    LinkedHashLruCache(long estimatedMaxSizeBytes, @Nullable LruCache.EvictionListener<K, V> evictionListener, final Ticker ticker) {
        Preconditions.checkState(estimatedMaxSizeBytes > 0L, "max estimated cache size should be positive");
        this.estimatedMaxSizeBytes = estimatedMaxSizeBytes;
        this.evictionListener = new SizeHandlingEvictionListener(evictionListener);
        this.ticker = Preconditions.checkNotNull(ticker, "ticker");
        this.delegate = new LinkedHashMap<K, SizedValue>(Math.max((int)(estimatedMaxSizeBytes / 1000L), 16), 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, SizedValue> eldest) {
                boolean shouldRemove;
                if (LinkedHashLruCache.this.estimatedSizeBytes <= LinkedHashLruCache.this.estimatedMaxSizeBytes) {
                    return false;
                }
                boolean removed = LinkedHashLruCache.this.cleanupExpiredEntries(1, ticker.read());
                boolean bl = shouldRemove = !removed && LinkedHashLruCache.this.shouldInvalidateEldestEntry(eldest.getKey(), eldest.getValue().value, ticker.read());
                if (shouldRemove) {
                    LinkedHashLruCache.this.invalidate(eldest.getKey(), LruCache.EvictionType.SIZE);
                }
                return false;
            }
        };
    }

    protected boolean shouldInvalidateEldestEntry(K eldestKey, V eldestValue, long now) {
        return true;
    }

    protected abstract boolean isExpired(K var1, V var2, long var3);

    protected int estimateSizeOf(K key, V value) {
        return 1;
    }

    protected long estimatedMaxSizeBytes() {
        return this.estimatedMaxSizeBytes;
    }

    public void updateEntrySize(K key) {
        int newSize;
        SizedValue entry = this.readInternal(key);
        if (entry == null) {
            return;
        }
        int prevSize = entry.size;
        entry.size = newSize = this.estimateSizeOf(key, entry.value);
        this.estimatedSizeBytes += (long)(newSize - prevSize);
    }

    public long estimatedSizeBytes() {
        return this.estimatedSizeBytes;
    }

    @Override
    @Nullable
    public final V cache(K key, V value) {
        Preconditions.checkNotNull(key, "key");
        Preconditions.checkNotNull(value, "value");
        int size = this.estimateSizeOf(key, value);
        this.estimatedSizeBytes += (long)size;
        SizedValue existing = this.delegate.put(key, new SizedValue(size, value));
        if (existing != null) {
            this.evictionListener.onEviction(key, existing, LruCache.EvictionType.REPLACED);
        }
        return existing == null ? null : (V)existing.value;
    }

    @Override
    @Nullable
    @CheckReturnValue
    public final V read(K key) {
        SizedValue entry = this.readInternal(key);
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    @Nullable
    @CheckReturnValue
    private SizedValue readInternal(K key) {
        Preconditions.checkNotNull(key, "key");
        SizedValue existing = this.delegate.get(key);
        if (existing != null && this.isExpired(key, existing.value, this.ticker.read())) {
            return null;
        }
        return existing;
    }

    @Override
    @Nullable
    public final V invalidate(K key) {
        return this.invalidate(key, LruCache.EvictionType.EXPLICIT);
    }

    @Nullable
    private V invalidate(K key, LruCache.EvictionType cause) {
        Preconditions.checkNotNull(key, "key");
        Preconditions.checkNotNull(cause, "cause");
        SizedValue existing = (SizedValue)this.delegate.remove(key);
        if (existing != null) {
            this.evictionListener.onEviction(key, existing, cause);
        }
        return existing == null ? null : (V)existing.value;
    }

    @Override
    public final void invalidateAll() {
        Iterator<Map.Entry<K, SizedValue>> iterator = this.delegate.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, SizedValue> entry = iterator.next();
            if (entry.getValue() != null) {
                this.evictionListener.onEviction(entry.getKey(), entry.getValue(), LruCache.EvictionType.EXPLICIT);
            }
            iterator.remove();
        }
    }

    @Override
    @CheckReturnValue
    public final boolean hasCacheEntry(K key) {
        return this.readInternal(key) != null;
    }

    public final List<V> values() {
        ArrayList list = new ArrayList(this.delegate.size());
        for (SizedValue value : this.delegate.values()) {
            list.add(value.value);
        }
        return Collections.unmodifiableList(list);
    }

    protected final boolean fitToLimit() {
        Map.Entry<K, SizedValue> entry;
        boolean removedAnyUnexpired = false;
        if (this.estimatedSizeBytes <= this.estimatedMaxSizeBytes) {
            return false;
        }
        long now = this.ticker.read();
        this.cleanupExpiredEntries(now);
        Iterator<Map.Entry<K, SizedValue>> lruIter = this.delegate.entrySet().iterator();
        while (lruIter.hasNext() && this.estimatedMaxSizeBytes < this.estimatedSizeBytes && this.shouldInvalidateEldestEntry((entry = lruIter.next()).getKey(), entry.getValue().value, now)) {
            lruIter.remove();
            this.evictionListener.onEviction(entry.getKey(), entry.getValue(), LruCache.EvictionType.SIZE);
            removedAnyUnexpired = true;
        }
        return removedAnyUnexpired;
    }

    public final void resize(long newSizeBytes) {
        this.estimatedMaxSizeBytes = newSizeBytes;
        this.fitToLimit();
    }

    @Override
    @CheckReturnValue
    public final int estimatedSize() {
        return this.delegate.size();
    }

    public final boolean cleanupExpiredEntries() {
        return this.cleanupExpiredEntries(this.ticker.read());
    }

    private boolean cleanupExpiredEntries(long now) {
        return this.cleanupExpiredEntries(Integer.MAX_VALUE, now);
    }

    private boolean cleanupExpiredEntries(int maxExpiredEntries, long now) {
        Preconditions.checkArgument(maxExpiredEntries > 0, "maxExpiredEntries must be positive");
        boolean removedAny = false;
        Iterator<Map.Entry<K, SizedValue>> lruIter = this.delegate.entrySet().iterator();
        while (lruIter.hasNext() && maxExpiredEntries > 0) {
            Map.Entry<K, SizedValue> entry = lruIter.next();
            if (!this.isExpired(entry.getKey(), entry.getValue().value, now)) continue;
            lruIter.remove();
            this.evictionListener.onEviction(entry.getKey(), entry.getValue(), LruCache.EvictionType.EXPIRED);
            removedAny = true;
            --maxExpiredEntries;
        }
        return removedAny;
    }

    @Override
    public final void close() {
        this.invalidateAll();
    }

    private final class SizedValue {
        volatile int size;
        final V value;

        SizedValue(int size, V value) {
            this.size = size;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SizedValue that = (SizedValue)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("size", this.size).add("value", this.value).toString();
        }
    }

    private final class SizeHandlingEvictionListener
    implements LruCache.EvictionListener<K, SizedValue> {
        private final LruCache.EvictionListener<K, V> delegate;

        SizeHandlingEvictionListener(LruCache.EvictionListener<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onEviction(K key, SizedValue value, LruCache.EvictionType cause) {
            LinkedHashLruCache.this.estimatedSizeBytes -= value.size;
            if (this.delegate != null) {
                this.delegate.onEviction(key, value.value, cause);
            }
        }
    }
}

