/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceName
implements ResourceName {
    private static final PathTemplate PROJECT_SERVICE = PathTemplate.createWithoutUrlEncoding("projects/{project}/services/{service}");
    private static final PathTemplate ORGANIZATION_SERVICE = PathTemplate.createWithoutUrlEncoding("organizations/{organization}/services/{service}");
    private static final PathTemplate FOLDER_SERVICE = PathTemplate.createWithoutUrlEncoding("folders/{folder}/services/{service}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String service;
    private final String organization;
    private final String folder;

    @Deprecated
    protected ServiceName() {
        this.project = null;
        this.service = null;
        this.organization = null;
        this.folder = null;
    }

    private ServiceName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.service = Preconditions.checkNotNull(builder.getService());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_SERVICE;
    }

    private ServiceName(OrganizationServiceBuilder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
        this.service = Preconditions.checkNotNull(builder.getService());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_SERVICE;
    }

    private ServiceName(FolderServiceBuilder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
        this.service = Preconditions.checkNotNull(builder.getService());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_SERVICE;
    }

    public String getProject() {
        return this.project;
    }

    public String getService() {
        return this.service;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectServiceBuilder() {
        return new Builder();
    }

    public static OrganizationServiceBuilder newOrganizationServiceBuilder() {
        return new OrganizationServiceBuilder();
    }

    public static FolderServiceBuilder newFolderServiceBuilder() {
        return new FolderServiceBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServiceName of(String project, String service) {
        return ServiceName.newBuilder().setProject(project).setService(service).build();
    }

    public static ServiceName ofProjectServiceName(String project, String service) {
        return ServiceName.newBuilder().setProject(project).setService(service).build();
    }

    public static ServiceName ofOrganizationServiceName(String organization, String service) {
        return ServiceName.newOrganizationServiceBuilder().setOrganization(organization).setService(service).build();
    }

    public static ServiceName ofFolderServiceName(String folder, String service) {
        return ServiceName.newFolderServiceBuilder().setFolder(folder).setService(service).build();
    }

    public static String format(String project, String service) {
        return ServiceName.newBuilder().setProject(project).setService(service).build().toString();
    }

    public static String formatProjectServiceName(String project, String service) {
        return ServiceName.newBuilder().setProject(project).setService(service).build().toString();
    }

    public static String formatOrganizationServiceName(String organization, String service) {
        return ServiceName.newOrganizationServiceBuilder().setOrganization(organization).setService(service).build().toString();
    }

    public static String formatFolderServiceName(String folder, String service) {
        return ServiceName.newFolderServiceBuilder().setFolder(folder).setService(service).build().toString();
    }

    public static ServiceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_SERVICE.matches(formattedString)) {
            Map<String, String> matchMap = PROJECT_SERVICE.match(formattedString);
            return ServiceName.ofProjectServiceName(matchMap.get("project"), matchMap.get("service"));
        }
        if (ORGANIZATION_SERVICE.matches(formattedString)) {
            Map<String, String> matchMap = ORGANIZATION_SERVICE.match(formattedString);
            return ServiceName.ofOrganizationServiceName(matchMap.get("organization"), matchMap.get("service"));
        }
        if (FOLDER_SERVICE.matches(formattedString)) {
            Map<String, String> matchMap = FOLDER_SERVICE.match(formattedString);
            return ServiceName.ofFolderServiceName(matchMap.get("folder"), matchMap.get("service"));
        }
        throw new ValidationException("ServiceName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ServiceName> parseList(List<String> formattedStrings) {
        ArrayList<ServiceName> list = new ArrayList<ServiceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServiceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServiceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServiceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SERVICE.matches(formattedString) || ORGANIZATION_SERVICE.matches(formattedString) || FOLDER_SERVICE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServiceName serviceName = this;
            synchronized (serviceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.service != null) {
                        fieldMapBuilder.put("service", this.service);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ServiceName that = (ServiceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.service, that.service) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.fixedValue);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.service);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.organization);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.folder);
    }

    public static class FolderServiceBuilder {
        private String folder;
        private String service;

        protected FolderServiceBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getService() {
            return this.service;
        }

        public FolderServiceBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderServiceBuilder setService(String service) {
            this.service = service;
            return this;
        }

        public ServiceName build() {
            return new ServiceName(this);
        }
    }

    public static class OrganizationServiceBuilder {
        private String organization;
        private String service;

        protected OrganizationServiceBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getService() {
            return this.service;
        }

        public OrganizationServiceBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationServiceBuilder setService(String service) {
            this.service = service;
            return this;
        }

        public ServiceName build() {
            return new ServiceName(this);
        }
    }

    public static class Builder {
        private String project;
        private String service;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getService() {
            return this.service;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        private Builder(ServiceName serviceName) {
            Preconditions.checkArgument(Objects.equals(serviceName.pathTemplate, PROJECT_SERVICE), "toBuilder is only supported when ServiceName has the pattern of projects/{project}/services/{service}");
            this.project = serviceName.project;
            this.service = serviceName.service;
        }

        public ServiceName build() {
            return new ServiceName(this);
        }
    }
}

