/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NotificationChannelName
implements ResourceName {
    private static final PathTemplate PROJECT_NOTIFICATION_CHANNEL = PathTemplate.createWithoutUrlEncoding("projects/{project}/notificationChannels/{notification_channel}");
    private static final PathTemplate ORGANIZATION_NOTIFICATION_CHANNEL = PathTemplate.createWithoutUrlEncoding("organizations/{organization}/notificationChannels/{notification_channel}");
    private static final PathTemplate FOLDER_NOTIFICATION_CHANNEL = PathTemplate.createWithoutUrlEncoding("folders/{folder}/notificationChannels/{notification_channel}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String notificationChannel;
    private final String organization;
    private final String folder;

    @Deprecated
    protected NotificationChannelName() {
        this.project = null;
        this.notificationChannel = null;
        this.organization = null;
        this.folder = null;
    }

    private NotificationChannelName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.notificationChannel = Preconditions.checkNotNull(builder.getNotificationChannel());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_NOTIFICATION_CHANNEL;
    }

    private NotificationChannelName(OrganizationNotificationChannelBuilder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
        this.notificationChannel = Preconditions.checkNotNull(builder.getNotificationChannel());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_NOTIFICATION_CHANNEL;
    }

    private NotificationChannelName(FolderNotificationChannelBuilder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
        this.notificationChannel = Preconditions.checkNotNull(builder.getNotificationChannel());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_NOTIFICATION_CHANNEL;
    }

    public String getProject() {
        return this.project;
    }

    public String getNotificationChannel() {
        return this.notificationChannel;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectNotificationChannelBuilder() {
        return new Builder();
    }

    public static OrganizationNotificationChannelBuilder newOrganizationNotificationChannelBuilder() {
        return new OrganizationNotificationChannelBuilder();
    }

    public static FolderNotificationChannelBuilder newFolderNotificationChannelBuilder() {
        return new FolderNotificationChannelBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NotificationChannelName of(String project, String notificationChannel) {
        return NotificationChannelName.newBuilder().setProject(project).setNotificationChannel(notificationChannel).build();
    }

    public static NotificationChannelName ofProjectNotificationChannelName(String project, String notificationChannel) {
        return NotificationChannelName.newBuilder().setProject(project).setNotificationChannel(notificationChannel).build();
    }

    public static NotificationChannelName ofOrganizationNotificationChannelName(String organization, String notificationChannel) {
        return NotificationChannelName.newOrganizationNotificationChannelBuilder().setOrganization(organization).setNotificationChannel(notificationChannel).build();
    }

    public static NotificationChannelName ofFolderNotificationChannelName(String folder, String notificationChannel) {
        return NotificationChannelName.newFolderNotificationChannelBuilder().setFolder(folder).setNotificationChannel(notificationChannel).build();
    }

    public static String format(String project, String notificationChannel) {
        return NotificationChannelName.newBuilder().setProject(project).setNotificationChannel(notificationChannel).build().toString();
    }

    public static String formatProjectNotificationChannelName(String project, String notificationChannel) {
        return NotificationChannelName.newBuilder().setProject(project).setNotificationChannel(notificationChannel).build().toString();
    }

    public static String formatOrganizationNotificationChannelName(String organization, String notificationChannel) {
        return NotificationChannelName.newOrganizationNotificationChannelBuilder().setOrganization(organization).setNotificationChannel(notificationChannel).build().toString();
    }

    public static String formatFolderNotificationChannelName(String folder, String notificationChannel) {
        return NotificationChannelName.newFolderNotificationChannelBuilder().setFolder(folder).setNotificationChannel(notificationChannel).build().toString();
    }

    public static NotificationChannelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_NOTIFICATION_CHANNEL.matches(formattedString)) {
            Map<String, String> matchMap = PROJECT_NOTIFICATION_CHANNEL.match(formattedString);
            return NotificationChannelName.ofProjectNotificationChannelName(matchMap.get("project"), matchMap.get("notification_channel"));
        }
        if (ORGANIZATION_NOTIFICATION_CHANNEL.matches(formattedString)) {
            Map<String, String> matchMap = ORGANIZATION_NOTIFICATION_CHANNEL.match(formattedString);
            return NotificationChannelName.ofOrganizationNotificationChannelName(matchMap.get("organization"), matchMap.get("notification_channel"));
        }
        if (FOLDER_NOTIFICATION_CHANNEL.matches(formattedString)) {
            Map<String, String> matchMap = FOLDER_NOTIFICATION_CHANNEL.match(formattedString);
            return NotificationChannelName.ofFolderNotificationChannelName(matchMap.get("folder"), matchMap.get("notification_channel"));
        }
        throw new ValidationException("NotificationChannelName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<NotificationChannelName> parseList(List<String> formattedStrings) {
        ArrayList<NotificationChannelName> list = new ArrayList<NotificationChannelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NotificationChannelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NotificationChannelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NotificationChannelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_NOTIFICATION_CHANNEL.matches(formattedString) || ORGANIZATION_NOTIFICATION_CHANNEL.matches(formattedString) || FOLDER_NOTIFICATION_CHANNEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NotificationChannelName notificationChannelName = this;
            synchronized (notificationChannelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.notificationChannel != null) {
                        fieldMapBuilder.put("notification_channel", this.notificationChannel);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            NotificationChannelName that = (NotificationChannelName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.notificationChannel, that.notificationChannel) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.fixedValue);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.notificationChannel);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.organization);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.folder);
    }

    public static class FolderNotificationChannelBuilder {
        private String folder;
        private String notificationChannel;

        protected FolderNotificationChannelBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getNotificationChannel() {
            return this.notificationChannel;
        }

        public FolderNotificationChannelBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderNotificationChannelBuilder setNotificationChannel(String notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public NotificationChannelName build() {
            return new NotificationChannelName(this);
        }
    }

    public static class OrganizationNotificationChannelBuilder {
        private String organization;
        private String notificationChannel;

        protected OrganizationNotificationChannelBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getNotificationChannel() {
            return this.notificationChannel;
        }

        public OrganizationNotificationChannelBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationNotificationChannelBuilder setNotificationChannel(String notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public NotificationChannelName build() {
            return new NotificationChannelName(this);
        }
    }

    public static class Builder {
        private String project;
        private String notificationChannel;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getNotificationChannel() {
            return this.notificationChannel;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setNotificationChannel(String notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        private Builder(NotificationChannelName notificationChannelName) {
            Preconditions.checkArgument(Objects.equals(notificationChannelName.pathTemplate, PROJECT_NOTIFICATION_CHANNEL), "toBuilder is only supported when NotificationChannelName has the pattern of projects/{project}/notificationChannels/{notification_channel}");
            this.project = notificationChannelName.project;
            this.notificationChannel = notificationChannelName.notificationChannel;
        }

        public NotificationChannelName build() {
            return new NotificationChannelName(this);
        }
    }
}

