/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiClock;
import com.google.api.core.NanoClock;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.retrying.BasicResultRetryAlgorithm;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.storage.Backoff;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.RetryContext;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.spi.v1.HttpRpcContext;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.nullness.qual.NonNull;

final class Retrying {
    Retrying() {
    }

    static @NonNull GrpcCallContext newCallContext() {
        return GrpcCallContext.createDefault().withExtraHeaders(ImmutableMap.of("x-goog-gcs-idempotency-token", ImmutableList.of(UUID.randomUUID().toString())));
    }

    static ResultRetryAlgorithm<?> neverRetry() {
        return new BasicResultRetryAlgorithm<Object>(){

            @Override
            public boolean shouldRetry(Throwable previousThrowable, Object previousResponse) {
                return false;
            }
        };
    }

    static ResultRetryAlgorithm<?> alwaysRetry() {
        return new BasicResultRetryAlgorithm<Object>(){

            @Override
            public boolean shouldRetry(Throwable previousThrowable, Object previousResponse) {
                return true;
            }
        };
    }

    private static final class SimpleRetryingDependencies
    implements RetryingDependencies {
        private final ApiClock clock;
        private final RetrySettings retrySettings;

        private SimpleRetryingDependencies(ApiClock clock, RetrySettings retrySettings) {
            this.retrySettings = retrySettings;
            this.clock = clock;
        }

        @Override
        public ApiClock getClock() {
            return this.clock;
        }

        @Override
        public RetrySettings getRetrySettings() {
            return this.retrySettings;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("clock", this.clock).add("retrySettings", this.retrySettings).toString();
        }
    }

    static interface RetryingDependencies {
        public RetrySettings getRetrySettings();

        public ApiClock getClock();

        public static RetryingDependencies attemptOnce() {
            return RetryingDependencies.simple(NanoClock.getDefaultClock(), RetrySettings.newBuilder().setMaxAttempts(1).build());
        }

        public static RetryingDependencies simple(ApiClock clock, RetrySettings retrySettings) {
            return new SimpleRetryingDependencies(clock, retrySettings);
        }
    }

    static final class HttpRetrier
    implements Retrier {
        private final Retrier delegate;

        HttpRetrier(Retrier delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <Response, Model> Model run(ResultRetryAlgorithm<?> alg, Callable<Response> c, Conversions.Decoder<Response, Model> d) {
            HttpRpcContext httpRpcContext = HttpRpcContext.getInstance();
            try {
                httpRpcContext.newInvocationId();
                Model Model = this.delegate.run(alg, c, d);
                return Model;
            }
            finally {
                httpRpcContext.clearInvocationId();
            }
        }
    }

    static final class DefaultRetrier
    implements Retrier {
        private final UnaryOperator<RetryContext> decorator;
        private final RetryingDependencies deps;

        DefaultRetrier(UnaryOperator<RetryContext> decorator, RetryingDependencies deps) {
            this.decorator = decorator;
            this.deps = deps;
        }

        @Override
        public <Response, Model> Model run(ResultRetryAlgorithm<?> alg, Callable<Response> c, Conversions.Decoder<Response, Model> d) {
            RetryContext ctx = (RetryContext)this.decorator.apply(RetryContext.of(RetryContext.directScheduledExecutorService(), this.deps, alg, Backoff.Jitterer.threadLocalRandom()));
            AtomicReference failure = new AtomicReference();
            AtomicBoolean attemptAgain = new AtomicBoolean(false);
            do {
                attemptAgain.set(false);
                try {
                    Response result = c.call();
                    return result == null ? null : (Model)d.decode(result);
                }
                catch (StorageException se) {
                    ctx.recordError(se, () -> attemptAgain.set(true), failure::set);
                }
                catch (IllegalArgumentException iae) {
                    ctx.recordError(iae, () -> attemptAgain.set(true), failure::set);
                }
                catch (Exception e) {
                    ctx.recordError(StorageException.coalesce(e), () -> attemptAgain.set(true), failure::set);
                }
            } while (attemptAgain.get());
            Exception throwable = (Exception)failure.get();
            if (throwable instanceof StorageException) {
                throw (StorageException)throwable;
            }
            throw StorageException.coalesce(throwable);
        }
    }

    static final class RetrierWithAlgImpl
    implements RetrierWithAlg {
        private final Retrier retrier;
        private final ResultRetryAlgorithm<?> alg;

        private RetrierWithAlgImpl(Retrier retrier, ResultRetryAlgorithm<?> alg) {
            this.retrier = retrier;
            this.alg = alg;
        }

        @Override
        public <Response, Model> Model run(ResultRetryAlgorithm<?> alg, Callable<Response> c, Conversions.Decoder<Response, Model> d) {
            return this.retrier.run(alg, c, d);
        }

        @Override
        public <Response, Model> Model run(Callable<Response> c, Conversions.Decoder<Response, Model> d) {
            return this.retrier.run(this.alg, c, d);
        }
    }

    static final class AttemptOnceRetrier
    implements Retrier {
        private static final AttemptOnceRetrier INSTANCE = new AttemptOnceRetrier();
        private static final RetrierWithAlg INSTANCE_WITH_ALG = INSTANCE.withAlg(Retrying.neverRetry());

        AttemptOnceRetrier() {
        }

        @Override
        public <Response, Model> Model run(ResultRetryAlgorithm<?> alg, Callable<Response> c, Conversions.Decoder<Response, Model> d) {
            try {
                Response call = c.call();
                return call == null ? null : (Model)d.decode(call);
            }
            catch (Exception iae) {
                throw StorageException.coalesce(iae);
            }
        }
    }

    static interface RetrierWithAlg
    extends Retrier {
        public <Response, Model> Model run(Callable<Response> var1, Conversions.Decoder<Response, Model> var2);

        public static RetrierWithAlg attemptOnce() {
            return AttemptOnceRetrier.INSTANCE_WITH_ALG;
        }
    }

    static interface Retrier {
        public <Response, Model> Model run(ResultRetryAlgorithm<?> var1, Callable<Response> var2, Conversions.Decoder<Response, Model> var3);

        default public RetrierWithAlg withAlg(ResultRetryAlgorithm<?> alg) {
            return new RetrierWithAlgImpl(this, alg);
        }

        public static Retrier attemptOnce() {
            return AttemptOnceRetrier.INSTANCE;
        }
    }
}

