/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.BetaApi;
import com.google.cloud.storage.RangeSpec;
import com.google.cloud.storage.RangeSpecFunction;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.checkerframework.checker.nullness.qual.Nullable;

@BetaApi
@Immutable
public final class MaxLengthRangeSpecFunction
extends RangeSpecFunction {
    static final MaxLengthRangeSpecFunction INSTANCE = new MaxLengthRangeSpecFunction(0L);
    private final long maxLength;

    MaxLengthRangeSpecFunction(long maxLength) {
        this.maxLength = maxLength;
    }

    public long getMaxLength() {
        return this.maxLength;
    }

    public MaxLengthRangeSpecFunction withMaxLength(long maxLength) {
        Preconditions.checkArgument(maxLength >= 0L, "maxLength >= 0 (%s >= 0)", maxLength);
        return new MaxLengthRangeSpecFunction(maxLength);
    }

    @Override
    RangeSpec apply(long offset, @Nullable RangeSpec prev) {
        if (prev == null || !prev.maxLength().isPresent()) {
            return RangeSpec.of(offset, this.maxLength);
        }
        long limit = prev.maxLength().getAsLong();
        return RangeSpec.of(offset, Math.min(limit, this.maxLength));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaxLengthRangeSpecFunction)) {
            return false;
        }
        MaxLengthRangeSpecFunction that = (MaxLengthRangeSpecFunction)o;
        return this.maxLength == that.maxLength;
    }

    public int hashCode() {
        return Objects.hashCode(this.maxLength);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("maxLength", this.maxLength).toString();
    }
}

