/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.ReadChannel;
import com.google.cloud.RestorableState;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobReadChannelV2;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.HttpStorageOptions;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;

@Deprecated
class BlobReadChannel
implements ReadChannel {
    private BlobReadChannel() {
    }

    @Override
    public RestorableState<ReadChannel> capture() {
        throw new IllegalStateException("Illegal method access");
    }

    @Override
    public boolean isOpen() {
        throw new IllegalStateException("Illegal method access");
    }

    @Override
    public void close() {
        throw new IllegalStateException("Illegal method access");
    }

    @Override
    public void seek(long position) throws IOException {
        throw new IllegalStateException("Illegal method access");
    }

    @Override
    public void setChunkSize(int chunkSize) {
        throw new IllegalStateException("Illegal method access");
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        throw new IllegalStateException("Illegal method access");
    }

    @Override
    public ReadChannel limit(long limit) {
        throw new IllegalStateException("Illegal method access");
    }

    @Override
    public long limit() {
        throw new IllegalStateException("Illegal method access");
    }

    @Deprecated
    @VisibleForTesting
    static class StateImpl
    implements RestorableState<ReadChannel>,
    Serializable {
        private static final long serialVersionUID = 7784852608213694645L;
        private HttpStorageOptions serviceOptions;
        private BlobId blob;
        private Map<StorageRpc.Option, ?> requestOptions;
        private String lastEtag;
        private long position;
        private boolean isOpen;
        private boolean endOfStream;
        private int chunkSize;
        private long limit;

        private StateImpl() {
        }

        @Override
        public ReadChannel restore() {
            StorageObject encode = (StorageObject)Conversions.json().blobId().encode(this.blob);
            BlobReadChannelV2 channel = new BlobReadChannelV2(encode, this.requestOptions, BlobReadChannelV2.BlobReadChannelContext.from(this.serviceOptions));
            try {
                channel.seek(this.position);
                channel.limit(this.limit);
                channel.setChunkSize(this.chunkSize);
                if (!this.isOpen) {
                    channel.close();
                }
            }
            catch (IOException e) {
                throw StorageException.coalesce(e);
            }
            return channel;
        }

        public int hashCode() {
            return Objects.hash(this.serviceOptions, this.blob, this.requestOptions, this.lastEtag, this.position, this.isOpen, this.endOfStream, this.chunkSize, this.limit);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StateImpl)) {
                return false;
            }
            StateImpl other = (StateImpl)obj;
            return Objects.equals(this.serviceOptions, other.serviceOptions) && Objects.equals(this.blob, other.blob) && Objects.equals(this.requestOptions, other.requestOptions) && Objects.equals(this.lastEtag, other.lastEtag) && this.position == other.position && this.isOpen == other.isOpen && this.endOfStream == other.endOfStream && this.chunkSize == other.chunkSize && this.limit == other.limit;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("blob", this.blob).add("position", this.position).add("isOpen", this.isOpen).add("endOfStream", this.endOfStream).add("limit", this.limit).toString();
        }
    }
}

