/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.BidiWriteCtx;
import com.google.cloud.storage.StorageV2ProtoUtils;
import com.google.storage.v2.BidiWriteObjectRequest;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

final class BidiAppendableWrite
implements BidiWriteCtx.BidiWriteObjectRequestBuilderFactory {
    private final BidiWriteObjectRequest req;

    public BidiAppendableWrite(BidiWriteObjectRequest req) {
        this(req, false);
    }

    public BidiAppendableWrite(BidiWriteObjectRequest req, boolean takeOver) {
        this.req = takeOver ? req : (req = req.toBuilder().setWriteObjectSpec(req.getWriteObjectSpec().toBuilder().setAppendable(true).build()).build());
    }

    public BidiWriteObjectRequest getReq() {
        return this.req;
    }

    @Override
    public BidiWriteObjectRequest.Builder newBuilder() {
        return this.req.toBuilder();
    }

    @Override
    public @Nullable String bucketName() {
        if (this.req.hasWriteObjectSpec() && this.req.getWriteObjectSpec().hasResource()) {
            return this.req.getWriteObjectSpec().getResource().getBucket();
        }
        if (this.req.hasAppendObjectSpec()) {
            return this.req.getAppendObjectSpec().getBucket();
        }
        return null;
    }

    public String toString() {
        return "BidiAppendableWrite{req=" + StorageV2ProtoUtils.fmtProto(this.req) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BidiAppendableWrite)) {
            return false;
        }
        BidiAppendableWrite BidiAppendableWrite2 = (BidiAppendableWrite)o;
        return Objects.equals(this.req, BidiAppendableWrite2.getReq());
    }

    public int hashCode() {
        return Objects.hash(this.req);
    }

    static BidiAppendableWrite identity(BidiAppendableWrite w) {
        return w;
    }
}

