/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security.certprovider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.xds.internal.security.Closeable;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class CertificateProvider
implements Closeable {
    private final DistributorWatcher watcher;
    private final boolean notifyCertUpdates;

    protected CertificateProvider(DistributorWatcher watcher, boolean notifyCertUpdates) {
        this.watcher = watcher;
        this.notifyCertUpdates = notifyCertUpdates;
    }

    @Override
    public abstract void close();

    public abstract void start();

    public DistributorWatcher getWatcher() {
        return this.watcher;
    }

    public boolean isNotifyCertUpdates() {
        return this.notifyCertUpdates;
    }

    @VisibleForTesting
    public static final class DistributorWatcher
    implements Watcher {
        private PrivateKey privateKey;
        private List<X509Certificate> certChain;
        private List<X509Certificate> trustedRoots;
        private Map<String, List<X509Certificate>> spiffeTrustMap;
        @VisibleForTesting
        final Set<Watcher> downstreamWatchers = new HashSet<Watcher>();

        synchronized void addWatcher(Watcher watcher) {
            this.downstreamWatchers.add(watcher);
            if (this.privateKey != null && this.certChain != null) {
                this.sendLastCertificateUpdate(watcher);
            }
            if (this.trustedRoots != null) {
                this.sendLastTrustedRootsUpdate(watcher);
            }
            if (this.spiffeTrustMap != null) {
                this.sendLastSpiffeTrustMapUpdate(watcher);
            }
        }

        synchronized void removeWatcher(Watcher watcher) {
            this.downstreamWatchers.remove(watcher);
        }

        @VisibleForTesting
        public Set<Watcher> getDownstreamWatchers() {
            return Collections.unmodifiableSet(this.downstreamWatchers);
        }

        private void sendLastCertificateUpdate(Watcher watcher) {
            watcher.updateCertificate(this.privateKey, this.certChain);
        }

        private void sendLastTrustedRootsUpdate(Watcher watcher) {
            watcher.updateTrustedRoots(this.trustedRoots);
        }

        private void sendLastSpiffeTrustMapUpdate(Watcher watcher) {
            watcher.updateSpiffeTrustMap(this.spiffeTrustMap);
        }

        @Override
        public synchronized void updateCertificate(PrivateKey key, List<X509Certificate> certChain) {
            Preconditions.checkNotNull(key, "key");
            Preconditions.checkNotNull(certChain, "certChain");
            this.privateKey = key;
            this.certChain = certChain;
            for (Watcher watcher : this.downstreamWatchers) {
                this.sendLastCertificateUpdate(watcher);
            }
        }

        @Override
        public synchronized void updateTrustedRoots(List<X509Certificate> trustedRoots) {
            Preconditions.checkNotNull(trustedRoots, "trustedRoots");
            this.trustedRoots = trustedRoots;
            for (Watcher watcher : this.downstreamWatchers) {
                this.sendLastTrustedRootsUpdate(watcher);
            }
        }

        @Override
        public void updateSpiffeTrustMap(Map<String, List<X509Certificate>> spiffeTrustMap) {
            this.spiffeTrustMap = spiffeTrustMap;
            for (Watcher watcher : this.downstreamWatchers) {
                this.sendLastSpiffeTrustMapUpdate(watcher);
            }
        }

        @Override
        public synchronized void onError(Status errorStatus) {
            for (Watcher watcher : this.downstreamWatchers) {
                watcher.onError(errorStatus);
            }
        }

        X509Certificate getLastIdentityCert() {
            if (this.certChain != null && !this.certChain.isEmpty()) {
                return this.certChain.get(0);
            }
            return null;
        }

        void close() {
            this.downstreamWatchers.clear();
            this.clearValues();
        }

        void clearValues() {
            this.privateKey = null;
            this.certChain = null;
            this.trustedRoots = null;
        }
    }

    public static interface Watcher {
        public void updateCertificate(PrivateKey var1, List<X509Certificate> var2);

        public void updateTrustedRoots(List<X509Certificate> var1);

        public void updateSpiffeTrustMap(Map<String, List<X509Certificate>> var1);

        public void onError(Status var1);
    }
}

