/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.cloud.storage.BidiResumableWrite;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.ByteStringStrategy;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.DefaultBlobWriteSessionConfig;
import com.google.cloud.storage.GrpcStorageImpl;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.LazyWriteChannel;
import com.google.cloud.storage.ResumableMedia;
import com.google.cloud.storage.StorageInternal;
import com.google.cloud.storage.TransportCompatibility;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.WritableByteChannelSession;
import com.google.common.base.Preconditions;
import com.google.storage.v2.BidiWriteObjectRequest;
import com.google.storage.v2.BidiWriteObjectResponse;
import java.io.IOException;
import java.time.Clock;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@BetaApi
@TransportCompatibility(value={TransportCompatibility.Transport.GRPC})
@Immutable
public final class BidiBlobWriteSessionConfig
extends BlobWriteSessionConfig
implements BlobWriteSessionConfig.GrpcCompatible {
    private static final long serialVersionUID = -903533790705476197L;
    private final int bufferSize;

    @InternalApi
    BidiBlobWriteSessionConfig(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BidiBlobWriteSessionConfig)) {
            return false;
        }
        BidiBlobWriteSessionConfig that = (BidiBlobWriteSessionConfig)o;
        return this.bufferSize == that.bufferSize;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.bufferSize);
    }

    @Override
    BlobWriteSessionConfig.WriterFactory createFactory(Clock clock) throws IOException {
        return new Factory(this.bufferSize);
    }

    @BetaApi
    public BidiBlobWriteSessionConfig withBufferSize(int bufferSize) {
        Preconditions.checkArgument(bufferSize >= 262144, "bufferSize must be >= %d", 262144);
        return new BidiBlobWriteSessionConfig(bufferSize);
    }

    @InternalApi
    static final class Factory
    implements BlobWriteSessionConfig.WriterFactory {
        static final Conversions.Decoder<BidiWriteObjectResponse, BlobInfo> WRITE_OBJECT_RESPONSE_BLOB_INFO_DECODER = Conversions.grpc().blobInfo().compose(BidiWriteObjectResponse::getResource);
        private final int bufferSize;

        private Factory(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        @Override
        @InternalApi
        public WritableByteChannelSession<?, BlobInfo> writeSession(StorageInternal s2, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
            if (s2 instanceof GrpcStorageImpl) {
                return new DefaultBlobWriteSessionConfig.DecoratedWritableByteChannelSession(new DefaultBlobWriteSessionConfig.LazySession(new LazyWriteChannel(() -> {
                    GrpcStorageImpl grpc = (GrpcStorageImpl)s2;
                    GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
                    BidiWriteObjectRequest req = grpc.getBidiWriteObjectRequest(info, opts);
                    ApiFuture<BidiResumableWrite> startResumableWrite = grpc.startResumableWrite(grpcCallContext, req, opts);
                    return ResumableMedia.gapic().write().bidiByteChannel(grpc.storageClient.bidiWriteObjectCallable()).setHasher(Hasher.noop()).setByteStringStrategy(ByteStringStrategy.copy()).resumable().withRetryConfig(grpc.retrier.withAlg(grpc.retryAlgorithmManager.idempotent())).buffered(BufferHandle.allocate(this.bufferSize)).setStartAsync(startResumableWrite).build();
                })), WRITE_OBJECT_RESPONSE_BLOB_INFO_DECODER);
            }
            throw new IllegalStateException("Unknown Storage implementation: " + s2.getClass().getName());
        }
    }
}

