/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.legacy;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Emptiable;
import org.apache.sis.util.internal.AbstractIterator;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.xml.bind.Context;

public abstract class LegacyPropertyAdapter<L, N>
extends AbstractCollection<L> {
    protected final Collection<N> elements;
    private transient boolean warningOccurred;

    protected LegacyPropertyAdapter(Collection<N> elements) {
        this.elements = elements;
    }

    protected abstract N wrap(L var1);

    protected abstract L unwrap(N var1);

    protected abstract boolean update(N var1, L var2);

    public final LegacyPropertyAdapter<L, N> validOrNull() {
        return this.elements != null ? this : null;
    }

    public final void setValues(Collection<? extends L> newValues) {
        Object next;
        if (newValues == null) {
            newValues = Collections.emptySet();
        }
        Iterator<L> it = newValues.iterator();
        Iterator<N> toUpdate = this.elements.iterator();
        boolean hasNext = it.hasNext();
        Object v0 = next = hasNext ? it.next() : null;
        while (toUpdate.hasNext()) {
            N container = toUpdate.next();
            if (!this.update(container, next)) continue;
            hasNext = it.hasNext();
            Object v1 = next = hasNext ? it.next() : null;
            if (!LegacyPropertyAdapter.isEmpty(container)) continue;
            toUpdate.remove();
        }
        if (hasNext) {
            this.elements.add(this.wrap(next));
            while (it.hasNext()) {
                this.elements.add(this.wrap(it.next()));
            }
        }
    }

    public static <L> L getSingleton(Collection<? extends L> values, Class<L> valueClass, LegacyPropertyAdapter<L, ?> caller, Class<?> callerClass, String callerMethod) {
        if (values != null) {
            Iterator<L> it = values.iterator();
            while (it.hasNext()) {
                L value = it.next();
                if (value == null) continue;
                while (it.hasNext()) {
                    L next = it.next();
                    if (next == null || value.equals(next)) continue;
                    if (caller != null) {
                        if (caller.warningOccurred) {
                            return value;
                        }
                        caller.warningOccurred = true;
                    }
                    LegacyPropertyAdapter.warnIgnoredExtraneous(valueClass, callerClass, callerMethod);
                    break;
                }
                return value;
            }
        }
        return null;
    }

    public static void warnIgnoredExtraneous(Class<?> valueClass, Class<?> callerClass, String callerMethod) {
        Context.warningOccured(Context.current(), callerClass, callerMethod, Messages.class, (short)20, valueClass);
    }

    private static boolean isEmpty(Object container) {
        return container instanceof Emptiable && ((Emptiable)container).isEmpty();
    }

    @Override
    public final boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public final int size() {
        int count = 0;
        Iterator<L> it = this.iterator();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public boolean add(L value) {
        ArgumentChecks.ensureNonNull("value", value);
        return this.elements.add(this.wrap(value));
    }

    @Override
    public final Iterator<L> iterator() {
        final Iterator<N> it = this.elements.iterator();
        return new AbstractIterator<L>(){
            private N container;

            @Override
            public final boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (it.hasNext()) {
                    this.container = it.next();
                    this.next = LegacyPropertyAdapter.this.unwrap(this.container);
                    if (this.next == null) continue;
                    return true;
                }
                this.container = null;
                return false;
            }

            @Override
            public final void remove() {
                if (this.container == null) {
                    throw new IllegalStateException();
                }
                if (!LegacyPropertyAdapter.this.update(this.container, null)) {
                    throw new UnsupportedOperationException();
                }
                if (LegacyPropertyAdapter.isEmpty(this.container)) {
                    it.remove();
                }
            }
        };
    }

    @Override
    public final boolean equals(Object other) {
        if (!(other instanceof LegacyPropertyAdapter)) {
            return false;
        }
        Iterator<L> ot = ((LegacyPropertyAdapter)other).iterator();
        Iterator<L> it = this.iterator();
        while (it.hasNext()) {
            if (ot.hasNext() && Objects.equals(it.next(), ot.next())) continue;
            return false;
        }
        return !ot.hasNext();
    }

    @Override
    public final int hashCode() {
        int code = 0;
        for (L element : this) {
            code = code * 31 + Objects.hashCode(element);
        }
        return code;
    }
}

