/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Vocabulary;

public final class PerformanceLevel
extends Level {
    private static final long serialVersionUID = -6547125008284983701L;
    public static final PerformanceLevel SLOWNESS = new PerformanceLevel("SLOWNESS", 267, 620, 1000000000L);
    public static final PerformanceLevel SLOWER = new PerformanceLevel("SLOWER", 268, 630, 10000000000L);
    @Deprecated
    public static final PerformanceLevel SLOW = SLOWNESS;
    private volatile long minDuration;
    private final short localization;

    private PerformanceLevel(String string, short s, int n, long l) {
        super(string, n);
        this.localization = s;
        this.minDuration = l;
    }

    public static Level forDuration(long l, TimeUnit timeUnit) {
        if ((l = timeUnit.toNanos(l)) < PerformanceLevel.SLOWNESS.minDuration) {
            return Level.FINE;
        }
        return l >= PerformanceLevel.SLOWER.minDuration ? SLOWER : SLOWNESS;
    }

    public long getMinDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.minDuration, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinDuration(long l, TimeUnit timeUnit) throws IllegalArgumentException {
        ArgumentChecks.ensureStrictlyPositive("duration", l);
        l = timeUnit.toNanos(l);
        int n = this.intValue();
        Class<PerformanceLevel> clazz = PerformanceLevel.class;
        synchronized (PerformanceLevel.class) {
            if (n >= SLOWER.intValue() && l < PerformanceLevel.SLOWNESS.minDuration) {
                PerformanceLevel.SLOWNESS.minDuration = l;
            }
            this.minDuration = l;
            if (n <= SLOWNESS.intValue() && l > PerformanceLevel.SLOWER.minDuration) {
                PerformanceLevel.SLOWER.minDuration = l;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getLocalizedName() {
        return Vocabulary.format(this.localization);
    }
}

