/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.internal.system.ReferenceQueueConsumer;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.resources.Messages;

abstract class WeakEntry<E>
extends WeakReference<E>
implements Disposable {
    static final int MIN_CAPACITY = 7;
    static final int HASH_MASK = Integer.MAX_VALUE;
    static final long REHASH_DELAY = 4000000000L;
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.util");
    WeakEntry<E> next;
    final int hash;

    WeakEntry(E e, WeakEntry<E> weakEntry, int n) {
        super(e, ReferenceQueueConsumer.QUEUE);
        this.next = weakEntry;
        this.hash = n;
    }

    static <E> int count(WeakEntry<E>[] weakEntryArray) {
        int n = 0;
        for (WeakEntry<E> weakEntry : weakEntryArray) {
            while (weakEntry != null) {
                ++n;
                weakEntry = weakEntry.next;
            }
        }
        return n;
    }

    final boolean removeFrom(WeakEntry<E>[] weakEntryArray, int n) {
        WeakEntry<E> weakEntry = null;
        WeakEntry<E> weakEntry2 = weakEntryArray[n];
        while (weakEntry2 != null) {
            if (weakEntry2 == this) {
                if (weakEntry != null) {
                    weakEntry.next = weakEntry2.next;
                } else {
                    weakEntryArray[n] = weakEntry2.next;
                }
                return true;
            }
            weakEntry = weakEntry2;
            weakEntry2 = weakEntry2.next;
        }
        return false;
    }

    static <E> WeakEntry<E>[] rehash(WeakEntry<E>[] weakEntryArray, int n, String string) {
        int n2 = Math.max(n * 2, 7);
        if (n2 < 65521) {
            n2 = MathFunctions.nextPrimeNumber(n2);
        }
        if (n2 == weakEntryArray.length) {
            return weakEntryArray;
        }
        Class<?> clazz = weakEntryArray.getClass().getComponentType();
        WeakEntry[] weakEntryArray2 = (WeakEntry[])Array.newInstance(clazz, n2);
        for (WeakEntry<E> weakEntry : weakEntryArray) {
            while (weakEntry != null) {
                WeakEntry<E> weakEntry2 = weakEntry;
                weakEntry = weakEntry.next;
                int n3 = weakEntry2.hash % weakEntryArray2.length;
                weakEntry2.next = weakEntryArray2[n3];
                weakEntryArray2[n3] = weakEntry2;
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LogRecord logRecord = Messages.getResources(null).getLogRecord(Level.FINEST, (short)4, weakEntryArray.length, weakEntryArray2.length);
            logRecord.setSourceMethodName(string);
            logRecord.setSourceClassName(clazz.getEnclosingClass().getName());
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
        return weakEntryArray2;
    }

    static int lowerCapacityThreshold(int n) {
        return n >>> 2;
    }

    static int upperCapacityThreshold(int n) {
        return n - (n >>> 2);
    }
}

