/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.storage.aggregate.Group;
import org.apache.sis.storage.aggregate.GroupAggregate;
import org.apache.sis.storage.aggregate.GroupByCRS;
import org.apache.sis.storage.aggregate.GroupByTransform;

final class GroupBySample
extends Group<GroupByCRS<GroupByTransform>> {
    private final List<SampleDimension> ranges;

    private GroupBySample(List<SampleDimension> list) {
        this.ranges = list;
    }

    @Override
    final String createName(Locale locale) {
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (SampleDimension sampleDimension : this.ranges) {
            stringJoiner.add(sampleDimension.getName().toInternationalString().toString(locale));
        }
        return stringJoiner.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GroupBySample getOrAdd(List<GroupBySample> list, List<SampleDimension> list2) {
        List<GroupBySample> list3 = list;
        synchronized (list3) {
            for (GroupBySample groupBySample : list) {
                if (!list2.equals(groupBySample.ranges)) continue;
                return groupBySample;
            }
            GroupBySample groupBySample = new GroupBySample(list2);
            list.add(groupBySample);
            return groupBySample;
        }
    }

    final void createComponents(GroupAggregate groupAggregate2) {
        groupAggregate2.sampleDimensions = this.ranges;
        groupAggregate2.fillWithChildAggregates(this, (groupByCRS, groupAggregate) -> {
            groupAggregate.fillWithCoverageComponents(groupByCRS.members, this.ranges);
            groupAggregate.sampleDimensions = this.ranges;
        });
    }
}

