/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.awt.Shape;
import java.awt.geom.Point2D;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class PassThroughTransform2D
extends PassThroughTransform
implements MathTransform2D {
    private static final long serialVersionUID = -5637760772953973708L;

    PassThroughTransform2D(int n, MathTransform mathTransform, int n2) {
        super(n, mathTransform, n2);
    }

    @Override
    public Point2D transform(Point2D point2D, Point2D point2D2) throws TransformException {
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        this.transform(dArray, 0, dArray, 0, 1);
        if (point2D2 != null) {
            point2D2.setLocation(dArray[0], dArray[1]);
            return point2D2;
        }
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    @Override
    public Shape createTransformedShape(Shape shape) throws TransformException {
        return AbstractMathTransform2D.createTransformedShape(this, shape, null, null, false);
    }

    @Override
    public Matrix derivative(Point2D point2D) throws TransformException {
        return super.derivative(point2D instanceof DirectPosition ? (DirectPosition)((Object)point2D) : new DirectPosition2D(point2D));
    }

    @Override
    public synchronized MathTransform2D inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            this.inverse = new PassThroughTransform2D(this.firstAffectedCoordinate, this.subTransform.inverse(), this.numTrailingCoordinates);
            this.inverse.inverse = this;
        }
        return (MathTransform2D)((Object)this.inverse);
    }
}

