/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.referencing.VerticalDatumTypes;
import org.apache.sis.internal.xml.LegacyNamespaces;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;

@XmlType(name="VerticalDatumType")
@XmlRootElement(name="VerticalDatum")
public class DefaultVerticalDatum
extends AbstractDatum
implements VerticalDatum {
    private static final long serialVersionUID = 380347456670516572L;
    private VerticalDatumType type;

    public DefaultVerticalDatum(Map<String, ?> map, VerticalDatumType verticalDatumType) {
        super(map);
        this.type = verticalDatumType;
        ArgumentChecks.ensureNonNull("type", verticalDatumType);
    }

    protected DefaultVerticalDatum(VerticalDatum verticalDatum) {
        super(verticalDatum);
        this.type = verticalDatum.getVerticalDatumType();
    }

    public static DefaultVerticalDatum castOrCopy(VerticalDatum verticalDatum) {
        return verticalDatum == null || verticalDatum instanceof DefaultVerticalDatum ? (DefaultVerticalDatum)verticalDatum : new DefaultVerticalDatum(verticalDatum);
    }

    public Class<? extends VerticalDatum> getInterface() {
        return VerticalDatum.class;
    }

    private VerticalDatumType type() {
        VerticalDatumType verticalDatumType = this.type;
        if (verticalDatumType == null) {
            ReferenceIdentifier referenceIdentifier = super.getName();
            this.type = verticalDatumType = VerticalDatumTypes.guess(referenceIdentifier != null ? referenceIdentifier.getCode() : null, super.getAlias(), null);
        }
        return verticalDatumType;
    }

    @Override
    public VerticalDatumType getVerticalDatumType() {
        return this.type();
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                return this.type().equals(((DefaultVerticalDatum)object).type());
            }
            case BY_CONTRACT: {
                return Objects.equals(this.getVerticalDatumType(), ((VerticalDatum)object).getVerticalDatumType());
            }
        }
        return true;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)this.type().hashCode();
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.append(VerticalDatumTypes.toLegacy(this.type()));
            return "Vert_Datum";
        }
        return formatter.shortOrLong("VDatum", "VerticalDatum");
    }

    private DefaultVerticalDatum() {
    }

    @XmlElement(name="verticalDatumType")
    private VerticalDatumType getTypeElement() {
        return Context.isGMLVersion(Context.current(), LegacyNamespaces.VERSION_3_2) ? null : this.getVerticalDatumType();
    }

    private void setTypeElement(VerticalDatumType verticalDatumType) {
        if (this.type == null) {
            this.type = verticalDatumType;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultVerticalDatum.class, "setTypeElement", "verticalDatumType");
        }
    }
}

