/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.measure.Unit;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.builder.AttributeRole;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.internal.feature.MovingFeatures;
import org.apache.sis.internal.netcdf.AxisType;
import org.apache.sis.internal.netcdf.CRSBuilder;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.DiscreteSampling;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.VariableRole;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.Vector;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.Characters;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.metadata.acquisition.GeometryType;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.util.FactoryException;

final class FeatureSet
extends DiscreteSampling {
    static final String TRAJECTORY = "trajectory";
    private static final int PAGE_SIZE = 512;
    private final Vector counts;
    private final Variable[] properties;
    private final Variable[] dynamicProperties;
    private final int referencingDimension;
    private final boolean isTrajectory;
    private final boolean hasTime;
    private final DefaultTemporalCRS timeCRS;
    private final DefaultFeatureType type;

    private FeatureSet(Decoder decoder, String string, Vector vector, Variable[] variableArray, Variable[] variableArray2, Map<AxisType, Variable> map, boolean bl, boolean bl2, DataStore dataStore) throws DataStoreException, IOException {
        super(decoder.geomlib, decoder.listeners, dataStore);
        Object object;
        Object object2;
        this.counts = vector;
        this.properties = variableArray;
        this.dynamicProperties = variableArray2;
        this.referencingDimension = map.size();
        this.isTrajectory = bl | this.referencingDimension == 0;
        this.hasTime = bl2;
        FeatureTypeBuilder featureTypeBuilder = new FeatureTypeBuilder(decoder.nameFactory, decoder.geomlib, decoder.listeners.getLocale());
        for (int i = this.getReferencingDimension(false); i < variableArray.length; ++i) {
            object2 = variableArray[i];
            object = ((Variable)object2).getEnumeration() != null ? String.class : ((Variable)object2).getDataType().getClass(((Variable)object2).getNumDimensions() > 1);
            FeatureSet.describe((Variable)object2, featureTypeBuilder.addAttribute(object));
        }
        DefaultTemporalCRS defaultTemporalCRS = null;
        if (this.referencingDimension != 0) {
            object2 = featureTypeBuilder.addAttribute(bl ? GeometryType.LINEAR : GeometryType.POINT);
            ((AttributeTypeBuilder)((AttributeTypeBuilder)object2).setName((CharSequence)TRAJECTORY)).addRole(AttributeRole.DEFAULT_GEOMETRY);
            try {
                object = new SingleCRS[1];
                ((AttributeTypeBuilder)object2).setCRS(CRSBuilder.assemble(decoder, map.values(), object));
                if (object[0] instanceof TemporalCRS) {
                    defaultTemporalCRS = DefaultTemporalCRS.castOrCopy((TemporalCRS)object[0]);
                }
            }
            catch (FactoryException factoryException) {
                decoder.listeners.warning(decoder.resources().getString((short)11, decoder.getFilename(), string, factoryException.getLocalizedMessage()), factoryException);
            }
            if (bl2) {
                ((AttributeTypeBuilder)object2).addCharacteristic(MovingFeatures.characteristic(defaultTemporalCRS != null));
            }
        }
        this.timeCRS = defaultTemporalCRS;
        for (int i = this.getReferencingDimension(true); i < variableArray2.length; ++i) {
            object = variableArray2[i];
            Class<String> clazz = object.getEnumeration() != null || object.isString() ? String.class : Number.class;
            FeatureSet.describe((Variable)object, featureTypeBuilder.addAttribute(clazz).setMaximumOccurs(Integer.MAX_VALUE));
        }
        string = Strings.toUpperCase(string, Characters.Filter.UNICODE_IDENTIFIER, false);
        this.type = featureTypeBuilder.setName((CharSequence)string).build();
    }

    private static void describe(Variable variable, AttributeTypeBuilder<?> attributeTypeBuilder) {
        Unit<?> unit;
        String string = variable.getName();
        attributeTypeBuilder.setName((CharSequence)string);
        String string2 = variable.getDescription();
        if (string2 != null && !string2.equals(string)) {
            attributeTypeBuilder.setDefinition(string2);
        }
        if ((unit = variable.getUnit()) != null) {
            attributeTypeBuilder.setUnit(unit);
        }
        if ("trajectory_id".equalsIgnoreCase(variable.getAttributeAsString("cf_role"))) {
            attributeTypeBuilder.addRole(AttributeRole.IDENTIFIER_COMPONENT);
        }
    }

    static FeatureSet[] create(Decoder decoder, DataStore dataStore) throws IOException, DataStoreException {
        assert (Thread.holdsLock(dataStore));
        ArrayList<FeatureSet> arrayList = new ArrayList<FeatureSet>(3);
        HashMap<Dimension, Boolean> hashMap = new HashMap<Dimension, Boolean>();
        for (Variable variable : decoder.getVariables()) {
            String string;
            if (variable.getRole() != VariableRole.FEATURE_PROPERTY) continue;
            if (variable.getNumDimensions() == 1 && variable.getDataType().isInteger && (string = variable.getAttributeAsString("sample_dimension")) != null) {
                Dimension dimension = variable.getGridDimensions().get(0);
                Dimension dimension2 = decoder.findDimension(string);
                if (dimension2 != null) {
                    FeatureSet.addFeatureSet(arrayList, decoder, variable, dimension, dimension2, dataStore);
                    hashMap.put(dimension2, Boolean.TRUE);
                } else {
                    decoder.listeners.warning(decoder.resources().getString((short)1, decoder.getFilename(), variable.getName(), string));
                }
                hashMap.put(dimension, Boolean.TRUE);
                continue;
            }
            hashMap.putIfAbsent(variable.getGridDimensions().get(0), Boolean.FALSE);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            Dimension dimension = (Dimension)entry.getKey();
            FeatureSet.addFeatureSet(arrayList, decoder, null, dimension, dimension, dataStore);
        }
        return arrayList.toArray(new FeatureSet[arrayList.size()]);
    }

    private static void addFeatureSet(List<FeatureSet> list, Decoder decoder, Variable variable, Dimension dimension, Dimension dimension2, DataStore dataStore) throws IOException, DataStoreException {
        String string = dimension.getName();
        if (string == null) {
            return;
        }
        boolean bl = !dimension2.equals(dimension);
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        ArrayList<Variable> arrayList2 = bl ? new ArrayList<Variable>() : Collections.emptyList();
        EnumMap<AxisType, Variable> enumMap = new EnumMap<AxisType, Variable>(AxisType.class);
        EnumMap<AxisType, Variable> enumMap2 = new EnumMap<AxisType, Variable>(AxisType.class);
        for (Variable variable2 : decoder.getVariables()) {
            Variable variable3;
            boolean bl2;
            if (variable2.equals(variable)) continue;
            if (string.equalsIgnoreCase(variable2.getName())) {
                if (!FeatureSet.isScalarOrString(variable2, dimension, decoder)) continue;
                arrayList.add(variable2);
                continue;
            }
            if (FeatureSet.isScalarOrString(variable2, dimension, null)) {
                arrayList.add(variable2);
                bl2 = false;
            } else {
                if (!bl || !FeatureSet.isScalarOrString(variable2, dimension2, null)) continue;
                arrayList2.add(variable2);
                bl2 = true;
            }
            AxisType axisType = AxisType.valueOf(variable2);
            if (axisType == null || (variable3 = (bl2 ? enumMap2 : enumMap).putIfAbsent(axisType, variable2)) == null) continue;
            decoder.listeners.warning(decoder.resources().getString((short)3, decoder.getFilename(), (Object)axisType, variable3.getName(), variable2.getName()));
        }
        Reorder reorder = new Reorder();
        list.add(new FeatureSet(decoder, string, variable != null ? variable.read() : null, reorder.toArray(arrayList, enumMap, false), reorder.toArray(arrayList2, enumMap2, true), reorder.selectedAxes, reorder.isTrajectory, reorder.hasTime, dataStore));
    }

    private static boolean isScalarOrString(Variable variable, Dimension dimension, Decoder decoder) {
        int n;
        List<Dimension> list = null;
        switch (variable.getNumDimensions()) {
            default: {
                n = 2;
                break;
            }
            case 2: {
                if (variable.getDataType() != DataType.CHAR) {
                    n = 1;
                    break;
                }
            }
            case 1: {
                list = variable.getGridDimensions();
                if (dimension.equals(list.get(0))) {
                    return true;
                }
                n = 0;
                break;
            }
            case 0: {
                return false;
            }
        }
        if (decoder != null) {
            if (list == null) {
                list = variable.getGridDimensions();
            }
            decoder.listeners.warning(decoder.resources().getString((short)2, decoder.getFilename(), variable.getName(), dimension.getName(), list.get(n).getName()));
        }
        return false;
    }

    final int getReferencingDimension(boolean bl) {
        return this.isTrajectory ^ bl ? 0 : this.referencingDimension;
    }

    @Override
    public DefaultFeatureType getType() {
        return this.type;
    }

    @Override
    public OptionalLong getFeatureCount() {
        long l;
        if (this.counts != null) {
            return OptionalLong.of(this.counts.size());
        }
        if (this.properties.length != 0 && (l = this.properties[0].getGridDimensions().get(0).length()) >= 0L) {
            return OptionalLong.of(l);
        }
        return OptionalLong.empty();
    }

    static boolean isEmpty(Object object) {
        return object == null || "".equals(object) || object instanceof Float && ((Float)object).isNaN() || object instanceof Double && ((Double)object).isNaN();
    }

    static GridExtent extent(List<Dimension> list, int n, long l, int n2) {
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        lArray[--n] = l;
        lArray2[n] = Math.addExact(l, (long)n2);
        for (int i = 0; i < n; ++i) {
            lArray2[i] = list.get(n - i).length();
        }
        return new GridExtent(null, lArray, lArray2, false);
    }

    @Override
    public Stream<AbstractFeature> features(boolean bl) throws DataStoreException {
        try {
            return StreamSupport.stream(new Iter(), false);
        }
        catch (IOException iOException) {
            throw new DataStoreException(this.canNotReadFile(), iOException);
        }
    }

    private static final class Reorder {
        Map<AxisType, Variable> selectedAxes = Collections.emptyMap();
        boolean isTrajectory;
        boolean hasTime;

        Reorder() {
        }

        Variable[] toArray(List<Variable> list, EnumMap<AxisType, Variable> enumMap, boolean bl) {
            Variable[] variableArray = new Variable[list.size()];
            if (this.selectedAxes.isEmpty() && enumMap.containsKey((Object)AxisType.X) && enumMap.containsKey((Object)AxisType.Y)) {
                int n;
                this.isTrajectory = bl;
                this.selectedAxes = enumMap;
                this.hasTime = enumMap.containsKey((Object)AxisType.T);
                variableArray = enumMap.values().toArray(variableArray);
                int n2 = n = enumMap.size();
                block0: for (Variable variable : list) {
                    int n3 = n;
                    while (--n3 >= 0) {
                        if (variableArray[n3] != variable) continue;
                        continue block0;
                    }
                    variableArray[n2++] = variable;
                }
                assert (n2 == variableArray.length);
            } else {
                variableArray = list.toArray(variableArray);
            }
            return variableArray;
        }
    }

    private final class Iter
    implements Spliterator<AbstractFeature> {
        private final int size;
        private int featureIndex;
        private int currentLowerIndex;
        private int currentUpperIndex;
        private final int propertyIndexOffset;
        private final List<?>[] propertyValues;
        private final String[] propertyNames;
        private long dynamicPropertyPosition;
        private final int geometryDimension;

        Iter() throws IOException, DataStoreException {
            this.size = (int)Math.min(FeatureSet.this.getFeatureCount().orElse(0L), Integer.MAX_VALUE);
            this.geometryDimension = FeatureSet.this.referencingDimension - (FeatureSet.this.hasTime ? 1 : 0);
            this.propertyIndexOffset = FeatureSet.this.getReferencingDimension(false);
            int n = FeatureSet.this.properties.length;
            this.propertyValues = new List[n];
            this.propertyNames = new String[n -= this.propertyIndexOffset];
            for (int i = 0; i < n; ++i) {
                this.propertyNames[i] = FeatureSet.this.properties[i + this.propertyIndexOffset].getName();
            }
            this.readNextPage();
        }

        private void readNextPage() throws IOException, DataStoreException {
            int n = Math.min(this.size - this.currentLowerIndex, 512);
            this.read(FeatureSet.this.properties, this.propertyIndexOffset, this.currentLowerIndex, n, this.propertyValues);
            this.currentUpperIndex = this.currentLowerIndex + n;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean tryAdvance(Consumer<? super AbstractFeature> consumer) {
            Vector[] vectorArray;
            int n;
            AbstractFeature abstractFeature;
            block20: {
                void var8_16;
                block22: {
                    int n2;
                    block23: {
                        boolean bl;
                        block21: {
                            Vector vector;
                            abstractFeature = FeatureSet.this.type.newInstance();
                            try {
                                Object object;
                                Object object4 = this.propertyValues;
                                do {
                                    if (this.featureIndex >= this.currentUpperIndex) {
                                        if (this.featureIndex >= this.size) {
                                            return false;
                                        }
                                        this.currentLowerIndex = this.featureIndex;
                                        this.readNextPage();
                                    }
                                    n2 = this.featureIndex - this.currentLowerIndex;
                                    n = FeatureSet.this.counts != null ? FeatureSet.this.counts.intValue(this.featureIndex) : 1;
                                    bl = n == 0;
                                    for (int n3 = 0; n3 < this.propertyNames.length; ++n3) {
                                        object = object4[n3 + this.propertyIndexOffset].get(n2);
                                        if (FeatureSet.isEmpty(object)) continue;
                                        bl = false;
                                        abstractFeature.setPropertyValue(this.propertyNames[n3], object);
                                    }
                                    ++this.featureIndex;
                                } while (bl);
                                int object2 = FeatureSet.this.dynamicProperties.length;
                                if (object2 != 0) {
                                    int n3;
                                    object = new List[object2];
                                    this.read(FeatureSet.this.dynamicProperties, n3, this.dynamicPropertyPosition, n, (List<?>[])object);
                                    for (n3 = FeatureSet.this.getReferencingDimension(true); n3 < object2; ++n3) {
                                        abstractFeature.setPropertyValue(FeatureSet.this.dynamicProperties[n3].getName(), object[n3]);
                                    }
                                    if (FeatureSet.this.isTrajectory) {
                                        object4 = object;
                                    }
                                }
                                vectorArray = new Vector[FeatureSet.this.referencingDimension];
                                System.arraycopy(object4, 0, vectorArray, 0, vectorArray.length);
                            }
                            catch (IOException iOException) {
                                throw new UncheckedIOException(FeatureSet.this.canNotReadFile(), iOException);
                            }
                            catch (DataStoreException dataStoreException) {
                                throw new BackingStoreException(FeatureSet.this.canNotReadFile(), dataStoreException);
                            }
                            boolean bl2 = FeatureSet.this.isTrajectory;
                            bl = FeatureSet.this.factory.supportSinglePrecision();
                            for (Vector vector2 : vectorArray) {
                                if (bl2) {
                                    bl2 = vector2.isEmptyOrNaN();
                                }
                                if (!bl) continue;
                                bl = vector2.isSinglePrecision();
                            }
                            if (bl2) break block20;
                            if (!FeatureSet.this.isTrajectory) break block21;
                            int n4 = Math.multiplyExact(n, this.geometryDimension);
                            if (bl) {
                                float[] fArray = new float[n4];
                                for (int i = 0; i < n4; ++i) {
                                    fArray[i] = vectorArray[i % this.geometryDimension].floatValue(i / this.geometryDimension);
                                }
                                vector = Vector.create(fArray, false);
                            } else {
                                double[] dArray = new double[n4];
                                for (int i = 0; i < n4; ++i) {
                                    dArray[i] = vectorArray[i % this.geometryDimension].doubleValue(i / this.geometryDimension);
                                }
                                vector = Vector.create(dArray);
                            }
                            Object g = FeatureSet.this.factory.createPolyline(false, this.geometryDimension, vector);
                            break block22;
                        }
                        if (!bl) break block23;
                        float f = vectorArray[0].floatValue(n2);
                        float f2 = vectorArray[0].floatValue(n2);
                        if (Float.isNaN(f) && Float.isNaN(f2)) break block20;
                        Object object = FeatureSet.this.factory.createPoint(f, f2);
                        break block22;
                    }
                    double d = vectorArray[0].doubleValue(n2);
                    double d2 = vectorArray[1].doubleValue(n2);
                    if (Double.isNaN(d) && Double.isNaN(d2)) break block20;
                    Object object = FeatureSet.this.factory.createPoint(d, d2);
                }
                abstractFeature.setPropertyValue(FeatureSet.TRAJECTORY, var8_16);
            }
            if (FeatureSet.this.hasTime) {
                MovingFeatures.setTimes((AbstractAttribute)abstractFeature.getProperty(FeatureSet.TRAJECTORY), vectorArray[this.geometryDimension], FeatureSet.this.timeCRS);
            }
            consumer.accept(abstractFeature);
            this.dynamicPropertyPosition += (long)n;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void read(Variable[] variableArray, int n, long l, int n2, List<?>[] listArray) throws IOException, DataStoreException {
            GridExtent gridExtent = FeatureSet.extent(null, 1, l, n2);
            Object object = null;
            GridExtent gridExtent2 = null;
            Object object2 = FeatureSet.this.getSynchronizationLock();
            synchronized (object2) {
                for (int i = 0; i < variableArray.length; ++i) {
                    List<Number> list;
                    Object object3;
                    Variable variable = variableArray[i];
                    if (variable.getNumDimensions() > 1) {
                        object3 = variable.getGridDimensions();
                        if (gridExtent2 == null || !object3.equals(object)) {
                            gridExtent2 = FeatureSet.extent(object3, object3.size(), l, n2);
                            object = object3;
                        }
                        list = variable.readAnyType(gridExtent2, null);
                    } else {
                        list = i >= n ? variable.readAnyType(gridExtent, null) : variable.read(gridExtent, null);
                    }
                    object3 = variable.getEnumeration();
                    if (object3 != null && list instanceof Vector) {
                        List<Number> list2 = list;
                        String[] stringArray = new String[((Vector)list2).size()];
                        for (int j = 0; j < stringArray.length; ++j) {
                            String string = (String)object3.get(((Vector)list2).intValue(j));
                            stringArray[j] = string != null ? string : "";
                        }
                        list = Arrays.asList(stringArray);
                    }
                    listArray[i] = list;
                }
            }
        }

        @Override
        public Spliterator<AbstractFeature> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return this.size - this.featureIndex;
        }

        @Override
        public int characteristics() {
            return 1360;
        }
    }
}

