/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk9;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.UnmodifiableArrayList;

public final class JDK9 {
    private JDK9() {
    }

    public static <T> void ifPresentOrElse(Optional<T> optional, Consumer<? super T> consumer, Runnable runnable) {
        if (optional.isPresent()) {
            consumer.accept(optional.get());
        } else {
            runnable.run();
        }
    }

    @SafeVarargs
    public static <E> List<E> listOf(E ... EArray) {
        switch (EArray.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(EArray[0]);
            }
        }
        return UnmodifiableArrayList.wrap(EArray);
    }

    @SafeVarargs
    public static <E> Set<E> setOf(E ... EArray) {
        switch (EArray.length) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(EArray[0]);
            }
        }
        LinkedHashSet<E> linkedHashSet = new LinkedHashSet<E>(Arrays.asList(EArray));
        if (linkedHashSet.size() != EArray.length) {
            throw new IllegalArgumentException("Duplicated elements.");
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public static <K, V> Map<K, V> mapOf(Object ... objectArray) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        int n = 0;
        while (n < objectArray.length) {
            if (hashMap.put(objectArray[n++], objectArray[n++]) == null) continue;
            throw new IllegalArgumentException("Duplicated elements.");
        }
        return hashMap;
    }

    public static <V> Set<V> copyOf(Set<V> set) {
        switch (set.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(set.iterator().next());
            }
        }
        return new HashSet<V>(set);
    }

    public static <K, V> Map<K, V> copyOf(Map<K, V> map) {
        return map.size() < 2 ? CollectionsExt.compact(map) : new HashMap<K, V>(map);
    }

    public static Buffer slice(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return ((ByteBuffer)buffer).slice();
        }
        if (buffer instanceof ShortBuffer) {
            return ((ShortBuffer)buffer).slice();
        }
        if (buffer instanceof IntBuffer) {
            return ((IntBuffer)buffer).slice();
        }
        if (buffer instanceof LongBuffer) {
            return ((LongBuffer)buffer).slice();
        }
        if (buffer instanceof FloatBuffer) {
            return ((FloatBuffer)buffer).slice();
        }
        if (buffer instanceof DoubleBuffer) {
            return ((DoubleBuffer)buffer).slice();
        }
        throw new IllegalArgumentException();
    }

    public static Buffer duplicate(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return ((ByteBuffer)buffer).duplicate();
        }
        if (buffer instanceof ShortBuffer) {
            return ((ShortBuffer)buffer).duplicate();
        }
        if (buffer instanceof IntBuffer) {
            return ((IntBuffer)buffer).duplicate();
        }
        if (buffer instanceof LongBuffer) {
            return ((LongBuffer)buffer).duplicate();
        }
        if (buffer instanceof FloatBuffer) {
            return ((FloatBuffer)buffer).duplicate();
        }
        if (buffer instanceof DoubleBuffer) {
            return ((DoubleBuffer)buffer).duplicate();
        }
        throw new IllegalArgumentException();
    }

    public static void get(ByteBuffer byteBuffer, int n, byte[] byArray) {
        JDK9.get(byteBuffer, n, byArray, 0, byArray.length);
    }

    public static void get(ByteBuffer byteBuffer, int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            byArray[n2 + i] = byteBuffer.get(n + i);
        }
    }

    public static String getPackageName(Class<?> clazz) {
        Class<?> clazz2;
        while ((clazz2 = clazz.getEnclosingClass()) != null) {
            clazz = clazz2;
        }
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        string = n >= 1 ? string.substring(0, n) : "";
        return string;
    }

    public static long multiplyFull(int n, int n2) {
        return (long)n * (long)n2;
    }

    public static boolean equals(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4) {
        if (n2 - n != n4 - n3) {
            return false;
        }
        while (n < n2) {
            if (cArray[n++] == cArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 - n != n4 - n3) {
            return false;
        }
        while (n < n2) {
            if (byArray[n++] == byArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] sArray, int n, int n2, short[] sArray2, int n3, int n4) {
        if (n2 - n != n4 - n3) {
            return false;
        }
        while (n < n2) {
            if (sArray[n++] == sArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4) {
        if (n2 - n != n4 - n3) {
            return false;
        }
        while (n < n2) {
            if (nArray[n++] == nArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4) {
        if (n2 - n != n4 - n3) {
            return false;
        }
        while (n < n2) {
            if (lArray[n++] == lArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] fArray, int n, int n2, float[] fArray2, int n3, int n4) {
        if (n2 - n != n4 - n3) {
            return false;
        }
        while (n < n2) {
            if (Float.floatToIntBits(fArray[n++]) == Float.floatToIntBits(fArray2[n3++])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] dArray, int n, int n2, double[] dArray2, int n3, int n4) {
        if (n2 - n != n4 - n3) {
            return false;
        }
        while (n < n2) {
            if (Double.doubleToLongBits(dArray[n++]) == Double.doubleToLongBits(dArray2[n3++])) continue;
            return false;
        }
        return true;
    }

    public static <T> List<T> toList(Stream<T> stream) {
        return UnmodifiableArrayList.wrap(stream.toArray());
    }

    public static String readString(Path path) throws IOException {
        StringJoiner stringJoiner = new StringJoiner("\n");
        Files.readAllLines(path).forEach(stringJoiner::add);
        return stringJoiner.toString();
    }
}

