/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.jts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.OptionalInt;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.IntFunction;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryType;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.jts.Factory;
import org.apache.sis.internal.feature.jts.FilteringContext;
import org.apache.sis.internal.feature.jts.JTS;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.internal.geoapi.filter.DistanceOperatorName;
import org.apache.sis.internal.geoapi.filter.SpatialOperatorName;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.resources.Errors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class Wrapper
extends GeometryWrapper<Geometry> {
    private final Geometry geometry;
    private static final BiPredicate<Geometry, Geometry>[] PREDICATES = new BiPredicate[SpatialOperatorName.OVERLAPS.ordinal() + 1];
    private static final Class<?>[] TYPES;
    private static final String[] SQLMM_NAMES;

    Wrapper(Geometry geometry) {
        this.geometry = geometry;
    }

    private Wrapper rewrap(Geometry geometry) {
        return geometry != this.geometry ? new Wrapper(geometry) : this;
    }

    @Override
    public Geometries<Geometry> factory() {
        return Factory.INSTANCE;
    }

    @Override
    public Object implementation() {
        return this.geometry;
    }

    @Override
    public OptionalInt getSRID() {
        int n = this.geometry.getSRID();
        return n != 0 ? OptionalInt.of(n) : OptionalInt.empty();
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        try {
            return JTS.getCoordinateReferenceSystem(this.geometry);
        }
        catch (FactoryException factoryException) {
            throw new BackingStoreException(factoryException);
        }
    }

    @Override
    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
        ArgumentChecks.ensureDimensionMatches("crs", Wrapper.getCoordinatesDimension(this.geometry), coordinateReferenceSystem);
        JTS.setCoordinateReferenceSystem(this.geometry, coordinateReferenceSystem);
    }

    private static int getCoordinatesDimension(Geometry geometry) {
        CoordinateSequence coordinateSequence;
        if (geometry instanceof Point) {
            coordinateSequence = ((Point)geometry).getCoordinateSequence();
        } else if (geometry instanceof LineString) {
            coordinateSequence = ((LineString)geometry).getCoordinateSequence();
        } else {
            if (geometry instanceof Polygon) {
                return Wrapper.getCoordinatesDimension((Geometry)((Polygon)geometry).getExteriorRing());
            }
            if (geometry instanceof GeometryCollection) {
                GeometryCollection geometryCollection = (GeometryCollection)geometry;
                int n = geometryCollection.getNumGeometries();
                if (n == 0) {
                    return 3;
                }
                for (int i = 0; i < n; ++i) {
                    int n2 = Wrapper.getCoordinatesDimension(geometryCollection.getGeometryN(i));
                    if (n2 <= 2) continue;
                    return n2;
                }
                return 2;
            }
            throw new IllegalArgumentException(Errors.format((short)149, geometry.getGeometryType()));
        }
        return coordinateSequence.getDimension();
    }

    @Override
    public GeneralEnvelope getEnvelope() {
        GeneralEnvelope generalEnvelope;
        Envelope envelope = this.geometry.getEnvelopeInternal();
        CoordinateReferenceSystem coordinateReferenceSystem = this.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem != null) {
            generalEnvelope = new GeneralEnvelope(coordinateReferenceSystem);
            generalEnvelope.setToNaN();
        } else {
            generalEnvelope = new GeneralEnvelope(2);
        }
        generalEnvelope.setRange(0, envelope.getMinX(), envelope.getMaxX());
        generalEnvelope.setRange(1, envelope.getMinY(), envelope.getMaxY());
        return generalEnvelope;
    }

    @Override
    public DirectPosition getCentroid() {
        Coordinate coordinate = this.geometry.getCentroid().getCoordinate();
        CoordinateReferenceSystem coordinateReferenceSystem = this.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem == null) {
            double d = coordinate.getZ();
            if (!Double.isNaN(d)) {
                return new GeneralDirectPosition(coordinate.x, coordinate.y, d);
            }
        } else if (ReferencingUtilities.getDimension(coordinateReferenceSystem) != 2) {
            GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(coordinateReferenceSystem);
            generalDirectPosition.setOrdinate(0, coordinate.x);
            generalDirectPosition.setOrdinate(1, coordinate.y);
            generalDirectPosition.setOrdinate(2, coordinate.getZ());
            return generalDirectPosition;
        }
        return new DirectPosition2D(coordinateReferenceSystem, coordinate.x, coordinate.y);
    }

    @Override
    public double[] getPointCoordinates() {
        double[] dArray;
        if (!(this.geometry instanceof Point)) {
            return null;
        }
        Coordinate coordinate = ((Point)this.geometry).getCoordinate();
        double d = coordinate.getZ();
        if (Double.isNaN(d)) {
            dArray = new double[2];
        } else {
            dArray = new double[3];
            dArray[2] = d;
        }
        dArray[1] = coordinate.y;
        dArray[0] = coordinate.x;
        return dArray;
    }

    @Override
    public double[] getAllCoordinates() {
        Coordinate[] coordinateArray = this.geometry.getCoordinates();
        double[] dArray = new double[coordinateArray.length * 2];
        int n = 0;
        for (Coordinate coordinate : coordinateArray) {
            dArray[n++] = coordinate.x;
            dArray[n++] = coordinate.y;
        }
        return dArray;
    }

    @Override
    protected Geometry mergePolylines(Iterator<?> iterator) {
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        ArrayList<Geometry> arrayList2 = new ArrayList<Geometry>();
        boolean bl = true;
        Geometry geometry = this.geometry;
        block0: while (true) {
            if (geometry instanceof Point) {
                Coordinate coordinate = ((Point)geometry).getCoordinate();
                if (!Double.isNaN(coordinate.x) && !Double.isNaN(coordinate.y)) {
                    bl = Factory.isFloat(bl, (Point)geometry);
                    arrayList.add(coordinate);
                } else {
                    Factory.INSTANCE.toLineString(arrayList, arrayList2, false, bl);
                    arrayList.clear();
                    bl = true;
                }
            } else {
                int n = geometry.getNumGeometries();
                for (int i = 0; i < n; ++i) {
                    LineString lineString = (LineString)geometry.getGeometryN(i);
                    if (arrayList.isEmpty()) {
                        arrayList2.add((Geometry)lineString);
                        continue;
                    }
                    if (bl) {
                        bl = Factory.isFloat(lineString.getCoordinateSequence());
                    }
                    arrayList.addAll(Arrays.asList(lineString.getCoordinates()));
                    Factory.INSTANCE.toLineString(arrayList, arrayList2, false, bl);
                    arrayList.clear();
                    bl = true;
                }
            }
            while (iterator.hasNext()) {
                geometry = (Geometry)iterator.next();
                if (geometry == null) continue;
                continue block0;
            }
            break;
        }
        Factory.INSTANCE.toLineString(arrayList, arrayList2, false, bl);
        return Factory.INSTANCE.toGeometry(arrayList2, false, bl);
    }

    @Override
    protected boolean predicateSameCRS(SpatialOperatorName spatialOperatorName, GeometryWrapper<Geometry> geometryWrapper) {
        BiPredicate<Geometry, Geometry> biPredicate;
        int n = spatialOperatorName.ordinal();
        if (n >= 0 && n < PREDICATES.length && (biPredicate = PREDICATES[n]) != null) {
            return biPredicate.test(this.geometry, ((Wrapper)geometryWrapper).geometry);
        }
        return super.predicateSameCRS(spatialOperatorName, geometryWrapper);
    }

    @Override
    protected boolean predicateSameCRS(DistanceOperatorName distanceOperatorName, GeometryWrapper<Geometry> geometryWrapper, double d) {
        boolean bl;
        boolean bl2 = bl = distanceOperatorName != DistanceOperatorName.WITHIN;
        if (bl && distanceOperatorName != DistanceOperatorName.BEYOND) {
            return super.predicateSameCRS(distanceOperatorName, geometryWrapper, d);
        }
        return this.geometry.isWithinDistance(((Wrapper)geometryWrapper).geometry, d) ^ bl;
    }

    @Override
    protected Object operationSameCRS(SQLMM sQLMM, GeometryWrapper<Geometry> geometryWrapper, Object object) {
        Geometry geometry;
        switch (sQLMM) {
            case ST_IsMeasured: {
                return Boolean.FALSE;
            }
            case ST_Dimension: {
                return this.geometry.getDimension();
            }
            case ST_SRID: {
                return this.geometry.getSRID();
            }
            case ST_IsEmpty: {
                return this.geometry.isEmpty();
            }
            case ST_IsSimple: {
                return this.geometry.isSimple();
            }
            case ST_IsValid: {
                return this.geometry.isValid();
            }
            case ST_Envelope: {
                return this.getEnvelope();
            }
            case ST_Boundary: {
                geometry = this.geometry.getBoundary();
                break;
            }
            case ST_ConvexHull: {
                geometry = this.geometry.convexHull();
                break;
            }
            case ST_Buffer: {
                geometry = this.geometry.buffer(((Number)object).doubleValue());
                break;
            }
            case ST_Intersection: {
                geometry = this.geometry.intersection(((Wrapper)geometryWrapper).geometry);
                break;
            }
            case ST_Union: {
                geometry = this.geometry.union(((Wrapper)geometryWrapper).geometry);
                break;
            }
            case ST_Difference: {
                geometry = this.geometry.difference(((Wrapper)geometryWrapper).geometry);
                break;
            }
            case ST_SymDifference: {
                geometry = this.geometry.symDifference(((Wrapper)geometryWrapper).geometry);
                break;
            }
            case ST_Distance: {
                return this.geometry.distance(((Wrapper)geometryWrapper).geometry);
            }
            case ST_Equals: {
                return this.geometry.equalsTopo(((Wrapper)geometryWrapper).geometry);
            }
            case ST_Relate: {
                return this.geometry.relate(((Wrapper)geometryWrapper).geometry, object.toString());
            }
            case ST_Disjoint: {
                return this.geometry.disjoint(((Wrapper)geometryWrapper).geometry);
            }
            case ST_Intersects: {
                return this.geometry.intersects(((Wrapper)geometryWrapper).geometry);
            }
            case ST_Touches: {
                return this.geometry.touches(((Wrapper)geometryWrapper).geometry);
            }
            case ST_Crosses: {
                return this.geometry.crosses(((Wrapper)geometryWrapper).geometry);
            }
            case ST_Within: {
                return this.geometry.within(((Wrapper)geometryWrapper).geometry);
            }
            case ST_Contains: {
                return this.geometry.contains(((Wrapper)geometryWrapper).geometry);
            }
            case ST_Overlaps: {
                return this.geometry.overlaps(((Wrapper)geometryWrapper).geometry);
            }
            case ST_AsText: {
                return new WKTWriter().write(this.geometry);
            }
            case ST_AsBinary: {
                return FilteringContext.writeWKB(this.geometry);
            }
            case ST_X: {
                return ((Point)this.geometry).getX();
            }
            case ST_Y: {
                return ((Point)this.geometry).getY();
            }
            case ST_Z: {
                return ((Point)this.geometry).getCoordinate().getZ();
            }
            case ST_ToLineString: {
                return this.geometry;
            }
            case ST_NumGeometries: {
                return this.geometry.getNumGeometries();
            }
            case ST_NumPoints: {
                return this.geometry.getNumPoints();
            }
            case ST_PointN: {
                geometry = ((LineString)this.geometry).getPointN(Wrapper.toIndex(object));
                break;
            }
            case ST_StartPoint: {
                geometry = ((LineString)this.geometry).getStartPoint();
                break;
            }
            case ST_EndPoint: {
                geometry = ((LineString)this.geometry).getEndPoint();
                break;
            }
            case ST_IsClosed: {
                return ((LineString)this.geometry).isClosed();
            }
            case ST_IsRing: {
                return ((LineString)this.geometry).isRing();
            }
            case ST_Perimeter: 
            case ST_Length: {
                return this.geometry.getLength();
            }
            case ST_Area: {
                return this.geometry.getArea();
            }
            case ST_Centroid: {
                geometry = this.geometry.getCentroid();
                break;
            }
            case ST_PointOnSurface: {
                geometry = this.geometry.getInteriorPoint();
                break;
            }
            case ST_ExteriorRing: {
                geometry = ((Polygon)this.geometry).getExteriorRing();
                break;
            }
            case ST_InteriorRingN: {
                geometry = ((Polygon)this.geometry).getInteriorRingN(Wrapper.toIndex(object));
                break;
            }
            case ST_NumInteriorRings: {
                return ((Polygon)this.geometry).getNumInteriorRing();
            }
            case ST_GeometryN: {
                geometry = this.geometry.getGeometryN(Wrapper.toIndex(object));
                break;
            }
            case ST_ToPoint: 
            case ST_ToPolygon: 
            case ST_ToMultiPoint: 
            case ST_ToMultiLine: 
            case ST_ToMultiPolygon: 
            case ST_ToGeomColl: {
                GeometryType geometryType = sQLMM.getGeometryType().get();
                Class<?> clazz = this.factory().getGeometryClass(geometryType);
                if (clazz.isInstance(this.geometry)) {
                    return this.geometry;
                }
                geometry = this.convert(geometryType);
                break;
            }
            case ST_Is3D: {
                Coordinate coordinate = this.geometry.getCoordinate();
                return coordinate != null ? Boolean.valueOf(!Double.isNaN(coordinate.z)) : null;
            }
            case ST_CoordDim: {
                Coordinate coordinate = this.geometry.getCoordinate();
                return coordinate != null ? Integer.valueOf(Double.isNaN(coordinate.z) ? 2 : 3) : null;
            }
            case ST_GeometryType: {
                for (int i = 0; i < TYPES.length; ++i) {
                    if (!TYPES[i].isInstance(this.geometry)) continue;
                    return SQLMM_NAMES[i];
                }
                return null;
            }
            case ST_ExplicitPoint: {
                double[] dArray;
                Coordinate coordinate = ((Point)this.geometry).getCoordinate();
                if (coordinate == null) {
                    return ArraysExt.EMPTY_DOUBLE;
                }
                double d = coordinate.getX();
                double d2 = coordinate.getY();
                double d3 = coordinate.getZ();
                if (Double.isNaN(d3)) {
                    double[] dArray2 = new double[2];
                    dArray2[0] = d;
                    dArray = dArray2;
                    dArray2[1] = d2;
                } else {
                    double[] dArray3 = new double[3];
                    dArray3[0] = d;
                    dArray3[1] = d2;
                    dArray = dArray3;
                    dArray3[2] = d3;
                }
                return dArray;
            }
            case ST_Simplify: {
                double d = ((Number)object).doubleValue();
                geometry = DouglasPeuckerSimplifier.simplify((Geometry)this.geometry, (double)d);
                break;
            }
            case ST_SimplifyPreserveTopology: {
                double d = ((Number)object).doubleValue();
                geometry = TopologyPreservingSimplifier.simplify((Geometry)this.geometry, (double)d);
                break;
            }
            default: {
                return super.operationSameCRS(sQLMM, geometryWrapper, object);
            }
        }
        JTS.copyMetadata(this.geometry, geometry);
        return geometry;
    }

    private static int toIndex(Object object) {
        int n = object instanceof CharSequence ? Integer.parseInt(object.toString()) : ((Number)object).intValue();
        ArgumentChecks.ensureStrictlyPositive("index", n);
        return n - 1;
    }

    @Override
    public GeometryWrapper<Geometry> toGeometryType(GeometryType geometryType) {
        Geometry geometry;
        if (!this.factory().getGeometryClass(geometryType).isInstance(this.geometry) && (geometry = this.convert(geometryType)) != this.geometry) {
            JTS.copyMetadata(this.geometry, geometry);
            return new Wrapper(geometry);
        }
        return this;
    }

    private Geometry convert(GeometryType geometryType) {
        GeometryFactory geometryFactory = this.geometry.getFactory();
        switch (geometryType) {
            case POINT: {
                return this.geometry.getCentroid();
            }
            case LINESTRING: {
                if (Wrapper.isCollection(this.geometry)) break;
                return geometryFactory.createLineString(this.geometry.getCoordinates());
            }
            case POLYGON: {
                if (!this.geometry.isEmpty() && this.geometry instanceof MultiLineString) {
                    MultiLineString multiLineString = (MultiLineString)this.geometry;
                    LinearRing linearRing = geometryFactory.createLinearRing(multiLineString.getGeometryN(0).getCoordinates());
                    LinearRing[] linearRingArray = new LinearRing[multiLineString.getNumGeometries() - 1];
                    int n = 0;
                    while (n < linearRingArray.length) {
                        linearRingArray[n++] = geometryFactory.createLinearRing(multiLineString.getGeometryN(n).getCoordinates());
                    }
                    return geometryFactory.createPolygon(linearRing, linearRingArray);
                }
                if (Wrapper.isCollection(this.geometry)) break;
                return geometryFactory.createPolygon(this.geometry.getCoordinates());
            }
            case MULTI_POINT: {
                return this.geometry instanceof Point ? geometryFactory.createMultiPoint(new Point[]{(Point)this.geometry}) : geometryFactory.createMultiPointFromCoords(this.geometry.getCoordinates());
            }
            case MULTI_LINESTRING: {
                return this.toCollection(geometryFactory, LineString.class, LineString[]::new, GeometryFactory::createLineString, GeometryFactory::createMultiLineString);
            }
            case MULTI_POLYGON: {
                return this.toCollection(geometryFactory, Polygon.class, Polygon[]::new, GeometryFactory::createPolygon, GeometryFactory::createMultiPolygon);
            }
            case GEOMETRY_COLLECTION: {
                if (this.geometry instanceof Point) {
                    return geometryFactory.createMultiPoint(new Point[]{(Point)this.geometry});
                }
                if (this.geometry instanceof LineString) {
                    return geometryFactory.createMultiLineString(new LineString[]{(LineString)this.geometry});
                }
                if (!(this.geometry instanceof Polygon)) break;
                return geometryFactory.createMultiPolygon(new Polygon[]{(Polygon)this.geometry});
            }
        }
        throw new UnconvertibleObjectException(Errors.format((short)7, this.geometry.getClass(), this.factory().getGeometryClass(geometryType)));
    }

    private <T extends Geometry> GeometryCollection toCollection(GeometryFactory geometryFactory, Class<T> clazz, IntFunction<T[]> intFunction, BiFunction<GeometryFactory, Coordinate[], T> biFunction, BiFunction<GeometryFactory, T[], GeometryCollection> biFunction2) {
        Geometry[] geometryArray = (Geometry[])intFunction.apply(this.geometry.getNumGeometries());
        for (int i = 0; i < geometryArray.length; ++i) {
            Geometry geometry = this.geometry.getGeometryN(i);
            if (clazz.isInstance(geometry)) {
                geometryArray[i] = (Geometry)clazz.cast(geometry);
                continue;
            }
            if (Wrapper.isCollection(geometry)) {
                throw new IllegalArgumentException(Errors.format((short)94, GeometryCollection.class));
            }
            geometryArray[i] = (Geometry)biFunction.apply(geometryFactory, geometry.getCoordinates());
        }
        return biFunction2.apply(geometryFactory, geometryArray);
    }

    private static boolean isCollection(Geometry geometry) {
        return geometry.getNumGeometries() >= 2 && !(geometry instanceof MultiPoint);
    }

    @Override
    public GeometryWrapper<Geometry> transform(CoordinateOperation coordinateOperation, boolean bl) throws FactoryException, TransformException {
        return this.rewrap(JTS.transform(this.geometry, coordinateOperation, bl));
    }

    @Override
    public GeometryWrapper<Geometry> transform(CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        try {
            return this.rewrap(JTS.transform(this.geometry, coordinateReferenceSystem));
        }
        catch (FactoryException factoryException) {
            throw new TransformException(factoryException.getMessage(), factoryException);
        }
    }

    @Override
    public boolean isSameCRS(GeometryWrapper<Geometry> geometryWrapper) {
        return JTS.isSameCRS(this.geometry, ((Wrapper)geometryWrapper).geometry);
    }

    @Override
    public String formatWKT(double d) {
        return this.geometry.toText();
    }

    static {
        Wrapper.PREDICATES[SpatialOperatorName.BBOX.ordinal()] = (geometry, geometry2) -> !geometry.disjoint(geometry2);
        Wrapper.PREDICATES[SpatialOperatorName.EQUALS.ordinal()] = Geometry::equalsTopo;
        Wrapper.PREDICATES[SpatialOperatorName.DISJOINT.ordinal()] = Geometry::disjoint;
        Wrapper.PREDICATES[SpatialOperatorName.INTERSECTS.ordinal()] = Geometry::intersects;
        Wrapper.PREDICATES[SpatialOperatorName.TOUCHES.ordinal()] = Geometry::touches;
        Wrapper.PREDICATES[SpatialOperatorName.CROSSES.ordinal()] = Geometry::crosses;
        Wrapper.PREDICATES[SpatialOperatorName.WITHIN.ordinal()] = Geometry::within;
        Wrapper.PREDICATES[SpatialOperatorName.CONTAINS.ordinal()] = Geometry::contains;
        Wrapper.PREDICATES[SpatialOperatorName.OVERLAPS.ordinal()] = Geometry::overlaps;
        TYPES = new Class[]{Point.class, LineString.class, Polygon.class, MultiPoint.class, MultiLineString.class, MultiPolygon.class, GeometryCollection.class, Geometry.class};
        SQLMM_NAMES = new String[]{"ST_Point", "ST_LineString", "ST_Polygon", "ST_MultiPoint", "ST_MultiLineString", "ST_MultiPolygon", "ST_GeomCollection", "ST_Geometry"};
    }
}

