/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.noaa;

import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayScalar;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.util.TableParser;

public class StructureDataAscii
extends StructureData {
    protected String line;

    public StructureDataAscii(StructureMembers members, String line) {
        super(members);
        this.line = line;
    }

    @Override
    public Array getArray(StructureMembers.Member m4) {
        TableParser.Field f = (TableParser.Field)m4.getDataObject();
        if (m4.getDataType() == DataType.STRING) {
            String result = (String)f.parse(this.line);
            return new ArrayObject(String.class, new int[0], new Object[]{result.trim()});
        }
        if (m4.getDataType() == DataType.SEQUENCE) {
            return this.getArraySequence(m4);
        }
        if (!m4.isScalar()) {
            if (m4.getDataType() == DataType.FLOAT) {
                float[] ja = this.getJavaArrayFloat(m4);
                return Array.factory(DataType.FLOAT, m4.getShape(), (Object)ja);
            }
            if (m4.getDataType() == DataType.CHAR) {
                char[] ja = this.getJavaArrayChar(m4);
                return Array.factory(DataType.CHAR, m4.getShape(), (Object)ja);
            }
            if (m4.getDataType() == DataType.BYTE) {
                byte[] ja = this.getJavaArrayByte(m4);
                return Array.factory(DataType.BYTE, m4.getShape(), (Object)ja);
            }
        }
        Object result = f.parse(this.line);
        if (m4.getDataType() == DataType.CHAR) {
            return new ArrayChar((String)result);
        }
        return new ArrayScalar(result);
    }

    @Override
    public float convertScalarFloat(StructureMembers.Member m4) {
        TableParser.Field f = (TableParser.Field)m4.getDataObject();
        return ((Number)f.parse(this.line)).floatValue();
    }

    @Override
    public double convertScalarDouble(StructureMembers.Member m4) {
        TableParser.Field f = (TableParser.Field)m4.getDataObject();
        return ((Number)f.parse(this.line)).doubleValue();
    }

    @Override
    public int convertScalarInt(StructureMembers.Member m4) {
        TableParser.Field f = (TableParser.Field)m4.getDataObject();
        return ((Number)f.parse(this.line)).intValue();
    }

    @Override
    public long convertScalarLong(StructureMembers.Member m4) {
        TableParser.Field f = (TableParser.Field)m4.getDataObject();
        return ((Number)f.parse(this.line)).longValue();
    }

    @Override
    public double getScalarDouble(StructureMembers.Member m4) {
        TableParser.Field f = (TableParser.Field)m4.getDataObject();
        return (Double)f.parse(this.line);
    }

    @Override
    public double[] getJavaArrayDouble(StructureMembers.Member m4) {
        return new double[0];
    }

    @Override
    public float getScalarFloat(StructureMembers.Member m4) {
        TableParser.Field f = (TableParser.Field)m4.getDataObject();
        Object result = f.parse(this.line);
        return result instanceof Float ? ((Float)f.parse(this.line)).floatValue() : ((Double)f.parse(this.line)).floatValue();
    }

    @Override
    public float[] getJavaArrayFloat(StructureMembers.Member m4) {
        int n = m4.getSize();
        float[] result = new float[n];
        TableParser.Field f = (TableParser.Field)m4.getDataObject();
        for (int i = 0; i < n; ++i) {
            Float val = (Float)f.parse(this.line, i * 8);
            result[i] = val == null ? Float.NaN : val.floatValue();
        }
        return result;
    }

    @Override
    public byte getScalarByte(StructureMembers.Member m4) {
        TableParser.Field f = (TableParser.Field)m4.getDataObject();
        return (Byte)f.parse(this.line);
    }

    @Override
    public byte[] getJavaArrayByte(StructureMembers.Member m4) {
        int n = m4.getSize();
        byte[] result = new byte[n];
        TableParser.Field f = (TableParser.Field)m4.getDataObject();
        for (int i = 0; i < n; ++i) {
            String s2 = (String)f.parse(this.line, i * 8);
            result[i] = s2 == null ? (byte)0 : (byte)s2.charAt(0);
        }
        return result;
    }

    @Override
    public int getScalarInt(StructureMembers.Member m4) {
        TableParser.Field f = (TableParser.Field)m4.getDataObject();
        return (Integer)f.parse(this.line);
    }

    @Override
    public int[] getJavaArrayInt(StructureMembers.Member m4) {
        return new int[0];
    }

    @Override
    public short getScalarShort(StructureMembers.Member m4) {
        TableParser.Field f = (TableParser.Field)m4.getDataObject();
        return (Short)f.parse(this.line);
    }

    @Override
    public short[] getJavaArrayShort(StructureMembers.Member m4) {
        return new short[0];
    }

    @Override
    public long getScalarLong(StructureMembers.Member m4) {
        TableParser.Field f = (TableParser.Field)m4.getDataObject();
        return (Long)f.parse(this.line);
    }

    @Override
    public long[] getJavaArrayLong(StructureMembers.Member m4) {
        return new long[0];
    }

    @Override
    public char getScalarChar(StructureMembers.Member m4) {
        TableParser.Field f = (TableParser.Field)m4.getDataObject();
        String result = (String)f.parse(this.line);
        return result.charAt(0);
    }

    @Override
    public char[] getJavaArrayChar(StructureMembers.Member m4) {
        int n = m4.getSize();
        char[] result = new char[n];
        TableParser.Field f = (TableParser.Field)m4.getDataObject();
        for (int i = 0; i < n; ++i) {
            String s2 = (String)f.parse(this.line, i * 8);
            result[i] = s2 == null ? (char)'\u0000' : s2.charAt(0);
        }
        return result;
    }

    @Override
    public String getScalarString(StructureMembers.Member m4) {
        TableParser.Field f = (TableParser.Field)m4.getDataObject();
        return ((String)f.parse(this.line)).trim();
    }

    @Override
    public String[] getJavaArrayString(StructureMembers.Member m4) {
        return new String[]{this.getScalarString(m4)};
    }

    @Override
    public StructureData getScalarStructure(StructureMembers.Member m4) {
        return null;
    }

    @Override
    public ArrayStructure getArrayStructure(StructureMembers.Member m4) {
        return null;
    }

    @Override
    public ArraySequence getArraySequence(StructureMembers.Member m4) {
        return null;
    }
}

