/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;

class MemTracker {
    private List<Mem> memList = new ArrayList<Mem>();
    private long fileSize;

    MemTracker(long fileSize) {
        this.fileSize = fileSize;
    }

    void add(String name, long start, long end) {
        this.memList.add(new Mem(name, start, end));
    }

    void addByLen(String name, long start, long size) {
        this.memList.add(new Mem(name, start, start + size));
    }

    void report(Formatter f) {
        f.format("Memory used file size= %d%n" + this.fileSize, new Object[0]);
        f.format("  start    end   size   name", new Object[0]);
        Collections.sort(this.memList);
        Mem prev = null;
        for (Mem m4 : this.memList) {
            if (prev != null && m4.start > prev.end) {
                f.format(" + %6d %6d %6d %6s%n", prev.end, m4.start, m4.start - prev.end, "HOLE");
            }
            char c = prev != null && prev.end != m4.start ? (char)'*' : ' ';
            f.format(" %s %6d %6d %6d %6s%n", Character.valueOf(c), m4.start, m4.end, m4.end - m4.start, m4.name);
            prev = m4;
        }
        f.format("%n", new Object[0]);
    }

    static class Mem
    implements Comparable {
        public String name;
        public long start;
        public long end;

        Mem(String name, long start, long end) {
            this.name = name;
            this.start = start;
            this.end = end;
        }

        public int compareTo(Object o1) {
            Mem m4 = (Mem)o1;
            return (int)(this.start - m4.start);
        }
    }
}

