/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.util.ArrayList;
import java.util.List;
import ucar.ma2.DataType;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.VariableSimpleIF;

public class VariableSimpleAdapter
implements VariableSimpleIF {
    private StructureMembers.Member m;

    public static List<VariableSimpleIF> convert(StructureMembers sm) {
        List<StructureMembers.Member> mlist = sm.getMembers();
        ArrayList<VariableSimpleIF> result = new ArrayList<VariableSimpleIF>(mlist.size());
        for (StructureMembers.Member m4 : mlist) {
            result.add(new VariableSimpleAdapter(m4));
        }
        return result;
    }

    public VariableSimpleAdapter(StructureMembers.Member m4) {
        this.m = m4;
    }

    @Override
    public String getFullName() {
        return this.m.getFullName();
    }

    @Override
    public String getName() {
        return this.m.getName();
    }

    @Override
    public String getShortName() {
        return this.m.getName();
    }

    @Override
    public DataType getDataType() {
        return this.m.getDataType();
    }

    @Override
    public String getDescription() {
        return this.m.getDescription();
    }

    @Override
    public String getUnitsString() {
        return this.m.getUnitsString();
    }

    @Override
    public int getRank() {
        return this.m.getShape().length;
    }

    @Override
    public int[] getShape() {
        return this.m.getShape();
    }

    @Override
    public List<Dimension> getDimensions() {
        ArrayList<Dimension> result = new ArrayList<Dimension>(this.getRank());
        for (int aShape : this.getShape()) {
            result.add(new Dimension(null, aShape, false));
        }
        return result;
    }

    @Override
    public List<Attribute> getAttributes() {
        return new ArrayList<Attribute>(1);
    }

    @Override
    public Attribute findAttributeIgnoreCase(String attName) {
        return null;
    }

    public String toString() {
        return this.m.getName();
    }

    @Override
    public int compareTo(VariableSimpleIF o) {
        assert (o != null);
        return this.getShortName().compareTo(o.getShortName());
    }
}

