/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.util.UnknownNameException;
import org.apache.sis.util.iso.DefaultLocalName;
import org.apache.sis.util.iso.TypeNames;
import org.opengis.util.NameSpace;
import org.opengis.util.TypeName;

@XmlType(name="TypeName_Type")
@XmlRootElement(name="TypeName")
public class DefaultTypeName
extends DefaultLocalName
implements TypeName {
    private static final long serialVersionUID = 7571710679743017926L;
    private final Type javaType;

    protected DefaultTypeName(NameSpace nameSpace, CharSequence charSequence) throws UnknownNameException {
        super(nameSpace, charSequence);
        try {
            this.javaType = TypeNames.toClass(TypeNames.namespace(nameSpace), super.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnknownNameException(TypeNames.unknown(super.toFullyQualifiedName()), classNotFoundException);
        }
        if (this.javaType == Void.TYPE) {
            throw new UnknownNameException(TypeNames.unknown(super.toFullyQualifiedName()));
        }
    }

    protected DefaultTypeName(NameSpace nameSpace, CharSequence charSequence, Type type) {
        super(nameSpace, charSequence);
        this.javaType = type;
    }

    public static DefaultTypeName castOrCopy(TypeName typeName) {
        if (typeName == null || typeName instanceof DefaultTypeName) {
            return (DefaultTypeName)typeName;
        }
        return new DefaultTypeName(typeName.scope(), typeName.toInternationalString(), null);
    }

    public Optional<Type> toJavaType() {
        return Optional.ofNullable(this.javaType);
    }

    @Deprecated
    public Class<?> toClass() {
        return this.javaType instanceof Class ? (Class)this.javaType : null;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            return Objects.equals(this.javaType, ((DefaultTypeName)object).javaType);
        }
        return false;
    }

    @Override
    int computeHashCode() {
        return super.computeHashCode() ^ Objects.hashCode(this.javaType);
    }

    private DefaultTypeName() {
        this.javaType = null;
    }
}

