/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import javax.measure.Unit;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.MapProjectionDescriptor;
import org.apache.sis.referencing.Builder;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public class ParameterBuilder
extends Builder<ParameterBuilder> {
    private boolean required;

    public ParameterBuilder() {
    }

    public ParameterBuilder(GeneralParameterDescriptor generalParameterDescriptor) {
        super(generalParameterDescriptor);
        if (generalParameterDescriptor != null) {
            this.required = generalParameterDescriptor.getMinimumOccurs() != 0;
        }
    }

    public ParameterBuilder setRequired(boolean bl) {
        this.required = bl;
        return this;
    }

    private static Double valueOf(double d) {
        return Double.isNaN(d) ? null : Double.valueOf(d);
    }

    public <T> ParameterDescriptor<T> create(Class<T> clazz, T t2) {
        return this.create(clazz, null, null, t2);
    }

    public ParameterDescriptor<Double> create(double d, Unit<?> unit) {
        MeasurementRange<Double> measurementRange = unit != null ? MeasurementRange.create(Double.NEGATIVE_INFINITY, false, Double.POSITIVE_INFINITY, false, unit) : null;
        return this.create(Double.class, measurementRange, null, ParameterBuilder.valueOf(d));
    }

    public ParameterDescriptor<Double> createStrictlyPositive(double d, Unit<?> unit) {
        NumberRange numberRange = unit != null ? MeasurementRange.createGreaterThan(0.0, unit) : NumberRange.create(0.0, false, Double.POSITIVE_INFINITY, false);
        return this.create(Double.class, numberRange, null, ParameterBuilder.valueOf(d));
    }

    public ParameterDescriptor<Double> createBounded(double d, double d2, double d3, Unit<?> unit) {
        NumberRange numberRange = unit != null ? MeasurementRange.create(d, true, d2, true, unit) : (d != Double.NEGATIVE_INFINITY || d2 != Double.POSITIVE_INFINITY ? NumberRange.create(d, true, d2, true) : null);
        return this.create(Double.class, numberRange, null, ParameterBuilder.valueOf(d3));
    }

    public ParameterDescriptor<Integer> createBounded(int n, int n2, int n3) {
        return this.create(Integer.class, NumberRange.create(n, true, n2, true), null, n3);
    }

    public <T extends Comparable<? super T>> ParameterDescriptor<T> createBounded(Class<T> clazz, T t2, T t3, T t4) {
        ArgumentChecks.ensureNonNull("valueClass", clazz);
        Range range = t2 == null && t3 == null ? null : (Number.class.isAssignableFrom(clazz) ? new NumberRange<Number>(clazz, (Number)((Object)t2), true, (Number)((Object)t3), true) : new Range(clazz, t2, true, t3, true));
        return this.create(clazz, range, null, t4);
    }

    public <T extends Comparable<? super T>> ParameterDescriptor<T> createBounded(Range<T> range, T t2) {
        ArgumentChecks.ensureNonNull("valueDomain", range);
        return this.create(range.getElementType(), range, null, t2);
    }

    public <T> ParameterDescriptor<T> createEnumerated(Class<T> clazz, T[] TArray, T t2) {
        ArgumentChecks.ensureNonNull("valueClass", clazz);
        return this.create(clazz, null, TArray, t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ParameterDescriptor<T> create(Class<T> clazz, Range<?> range, T[] TArray, T t2) {
        DefaultParameterDescriptor<T> defaultParameterDescriptor;
        this.onCreate(false);
        try {
            defaultParameterDescriptor = new DefaultParameterDescriptor<T>(this.properties, this.required ? 1 : 0, 1, clazz, range, TArray, t2);
        }
        finally {
            this.onCreate(true);
        }
        return defaultParameterDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterDescriptorGroup createGroup(int n, int n2, GeneralParameterDescriptor ... generalParameterDescriptorArray) {
        DefaultParameterDescriptorGroup defaultParameterDescriptorGroup;
        this.onCreate(false);
        try {
            defaultParameterDescriptorGroup = new DefaultParameterDescriptorGroup(this.properties, n, n2, generalParameterDescriptorArray);
        }
        finally {
            this.onCreate(true);
        }
        return defaultParameterDescriptorGroup;
    }

    public ParameterDescriptorGroup createGroup(GeneralParameterDescriptor ... generalParameterDescriptorArray) {
        return this.createGroup(this.required ? 1 : 0, 1, generalParameterDescriptorArray);
    }

    public ParameterDescriptorGroup createGroupWithSameParameters(ParameterDescriptorGroup parameterDescriptorGroup) {
        DefaultParameterDescriptorGroup defaultParameterDescriptorGroup;
        this.onCreate(false);
        try {
            defaultParameterDescriptorGroup = new DefaultParameterDescriptorGroup(this.properties, parameterDescriptorGroup);
        }
        finally {
            this.onCreate(true);
        }
        return defaultParameterDescriptorGroup;
    }

    public ParameterDescriptorGroup createGroupForMapProjection(ParameterDescriptor<?> ... parameterDescriptorArray) {
        MapProjectionDescriptor mapProjectionDescriptor;
        this.onCreate(false);
        try {
            mapProjectionDescriptor = new MapProjectionDescriptor(this.properties, parameterDescriptorArray);
        }
        finally {
            this.onCreate(true);
        }
        return mapProjectionDescriptor;
    }
}

