/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.IOException;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.io.CompoundFormat;
import org.apache.sis.io.wkt.AbstractParser;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Element;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.io.wkt.GeodeticObjectParser;
import org.apache.sis.io.wkt.KeywordCase;
import org.apache.sis.io.wkt.KeywordStyle;
import org.apache.sis.io.wkt.SingletonElement;
import org.apache.sis.io.wkt.StoredTree;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.io.wkt.Transliterator;
import org.apache.sis.io.wkt.UnparsableObjectException;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.Factory;

public class WKTFormat
extends CompoundFormat<Object> {
    private static final long serialVersionUID = -2909110214650709560L;
    public static final int SINGLE_LINE = -1;
    private Symbols symbols;
    private Colors colors;
    private Convention convention = Convention.DEFAULT;
    private Citation authority;
    private KeywordCase keywordCase;
    private KeywordStyle keywordStyle;
    private Transliterator transliterator;
    private byte indentation;
    private int listSizeLimit;
    private transient DefaultIdentifier defaultIdentifier;
    private Map<String, StoredTree> fragments;
    private transient boolean isCloned;
    private transient Map<Object, Object> sharedValues;
    private transient Formatter formatter;
    private transient AbstractParser parser;
    private transient ReferencingFactoryContainer factories;
    private transient Warnings warnings;

    public WKTFormat(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
        this.symbols = Symbols.getDefault();
        this.keywordCase = KeywordCase.DEFAULT;
        this.keywordStyle = KeywordStyle.DEFAULT;
        this.indentation = (byte)2;
        this.listSizeLimit = Integer.MAX_VALUE;
    }

    private Map<String, StoredTree> fragments(boolean bl) {
        if (this.fragments == null) {
            if (!bl) {
                return Collections.emptyMap();
            }
            this.fragments = new TreeMap<String, StoredTree>();
            this.isCloned = false;
        } else if (this.isCloned & bl) {
            this.fragments = new TreeMap<String, StoredTree>(this.fragments);
            this.isCloned = false;
        }
        return this.fragments;
    }

    private ReferencingFactoryContainer factories() {
        if (this.factories == null) {
            this.factories = new ReferencingFactoryContainer();
        }
        return this.factories;
    }

    @Override
    public Locale getLocale(Locale.Category category) {
        if (category == Locale.Category.FORMAT) {
            return this.symbols.getLocale();
        }
        return super.getLocale(category);
    }

    final Locale getErrorLocale() {
        Locale locale = this.getLocale(Locale.Category.DISPLAY);
        return locale != null && locale != Locale.ROOT ? locale : Locale.getDefault(Locale.Category.DISPLAY);
    }

    public Symbols getSymbols() {
        return this.symbols;
    }

    public void setSymbols(Symbols symbols) {
        ArgumentChecks.ensureNonNull("symbols", symbols);
        if (!symbols.equals(this.symbols)) {
            this.symbols = symbols.immutable();
            this.formatter = null;
            this.parser = null;
        }
    }

    public Transliterator getTransliterator() {
        Transliterator transliterator = this.transliterator;
        if (transliterator == null) {
            transliterator = this.convention == Convention.INTERNAL ? Transliterator.IDENTITY : Transliterator.DEFAULT;
        }
        return transliterator;
    }

    public void setTransliterator(Transliterator transliterator) {
        if (this.transliterator != transliterator) {
            this.transliterator = transliterator;
            this.updateFormatter(this.formatter);
            this.parser = null;
        }
    }

    public KeywordCase getKeywordCase() {
        return this.keywordCase;
    }

    public void setKeywordCase(KeywordCase keywordCase) {
        ArgumentChecks.ensureNonNull("keywordCase", (Object)keywordCase);
        this.keywordCase = keywordCase;
        this.updateFormatter(this.formatter);
    }

    public KeywordStyle getKeywordStyle() {
        return this.keywordStyle;
    }

    public void setKeywordStyle(KeywordStyle keywordStyle) {
        ArgumentChecks.ensureNonNull("keywordStyle", (Object)keywordStyle);
        this.keywordStyle = keywordStyle;
        this.updateFormatter(this.formatter);
    }

    public Colors getColors() {
        return this.colors;
    }

    public void setColors(Colors colors) {
        if (colors != null) {
            colors = colors.immutable();
        }
        this.colors = colors;
        this.updateFormatter(this.formatter);
    }

    public Convention getConvention() {
        return this.convention;
    }

    public void setConvention(Convention convention) {
        ArgumentChecks.ensureNonNull("convention", (Object)convention);
        if (this.convention != convention) {
            this.convention = convention;
            this.updateFormatter(this.formatter);
            this.parser = null;
        }
    }

    public Citation getNameAuthority() {
        Citation citation = this.authority;
        if (citation == null) {
            citation = this.convention.getNameAuthority();
        }
        return citation;
    }

    public void setNameAuthority(Citation citation) {
        this.authority = citation;
        this.updateFormatter(this.formatter);
    }

    private void updateFormatter(Formatter formatter) {
        if (formatter != null) {
            byte by;
            byte by2;
            switch (this.keywordCase) {
                case LOWER_CASE: {
                    by2 = -1;
                    break;
                }
                case UPPER_CASE: {
                    by2 = 1;
                    break;
                }
                case CAMEL_CASE: {
                    by2 = 0;
                    break;
                }
                default: {
                    by2 = this.convention.toUpperCase ? (byte)1 : 0;
                }
            }
            switch (this.keywordStyle) {
                case SHORT: {
                    by = -1;
                    break;
                }
                case LONG: {
                    by = 1;
                    break;
                }
                default: {
                    by = this.convention.majorVersion() == 1 ? (byte)-1 : 0;
                }
            }
            formatter.configure(this.convention, this.authority, this.colors, by2, by, this.indentation, this.listSizeLimit);
            if (this.transliterator != null) {
                formatter.transliterator = this.transliterator;
            }
        }
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int n) {
        ArgumentChecks.ensureBetween("indentation", -1, 127, n);
        this.indentation = (byte)n;
        this.updateFormatter(this.formatter);
    }

    public int getMaximumListElements() {
        return this.listSizeLimit;
    }

    public void setMaximumListElements(int n) {
        ArgumentChecks.ensureStrictlyPositive("limit", n);
        this.listSizeLimit = n;
        this.updateFormatter(this.formatter);
    }

    final void setDefaultIdentifier(DefaultIdentifier defaultIdentifier) {
        this.defaultIdentifier = defaultIdentifier;
    }

    private void ensureValidFactoryType(Class<?> clazz) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("type", clazz);
        if (clazz != CRSFactory.class && clazz != CSFactory.class && clazz != DatumFactory.class && clazz != MathTransformFactory.class && clazz != CoordinateOperationFactory.class) {
            throw new IllegalArgumentException(this.errors().getString((short)45, "type", clazz));
        }
    }

    public <T extends Factory> T getFactory(Class<T> clazz) {
        this.ensureValidFactoryType(clazz);
        return this.factories().getFactory(clazz);
    }

    public <T extends Factory> void setFactory(Class<T> clazz, T t2) {
        this.ensureValidFactoryType(clazz);
        if (this.factories().setFactory(clazz, t2)) {
            this.parser = null;
        }
    }

    @Override
    public final Class<Object> getValueType() {
        return Object.class;
    }

    public Set<String> getFragmentNames() {
        return this.fragments(true).keySet();
    }

    public void addFragment(String string, String string2) throws IllegalArgumentException, ParseException {
        ArgumentChecks.ensureNonEmpty("wkt", string2);
        ArgumentChecks.ensureNonEmpty("name", string);
        if (!CharSequences.isUnicodeIdentifier(string)) {
            throw new IllegalArgumentException(this.errors().getString((short)112, string));
        }
        ParsePosition parsePosition = new ParsePosition(0);
        StoredTree storedTree = this.textToTree(string2, parsePosition, string);
        int n = string2.length();
        int n2 = CharSequences.skipLeadingWhitespaces(string2, parsePosition.getIndex(), n);
        if (n2 < n) {
            throw new UnparsableObjectException(this.getErrorLocale(), 135, new Object[]{string + " = " + storedTree.keyword() + "[\u2026]", CharSequences.token(string2, n2)}, n2);
        }
        this.addFragment(string, storedTree);
        this.logWarnings(WKTFormat.class, "addFragment");
    }

    final void addFragment(String string, StoredTree storedTree) {
        if (this.fragments(true).putIfAbsent(string, storedTree) != null) {
            throw new IllegalArgumentException(this.errors().getString((short)27, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final StoredTree textToTree(String string, ParsePosition parsePosition, String string2) throws ParseException {
        Object v0;
        AbstractParser abstractParser = this.parser(true);
        ArrayList<Element> arrayList = new ArrayList<Element>(4);
        this.warnings = null;
        try {
            while (true) {
                arrayList.add(abstractParser.textToTree(string, parsePosition));
                if (string2 == null) break;
                int n = CharSequences.skipLeadingWhitespaces(string, parsePosition.getIndex(), string.length());
                String string3 = abstractParser.symbols.trimmedSeparator();
                if (!string.startsWith(string3, n)) break;
                parsePosition.setIndex(n + string3.length());
            }
            v0 = arrayList.isEmpty() ? null : arrayList.get(0);
        }
        catch (Throwable throwable) {
            this.warnings = abstractParser.getAndClearWarnings(arrayList.isEmpty() ? null : arrayList.get(0));
            throw throwable;
        }
        this.warnings = abstractParser.getAndClearWarnings(v0);
        if (this.sharedValues == null) {
            this.sharedValues = new HashMap<Object, Object>();
        }
        if (arrayList.size() == 1) {
            return new StoredTree((Element)arrayList.get(0), this.sharedValues);
        }
        return new StoredTree(arrayList, this.sharedValues);
    }

    final void clear() {
        this.warnings = null;
        this.sharedValues = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object parse(CharSequence charSequence, ParsePosition parsePosition) throws ParseException {
        this.clear();
        ArgumentChecks.ensureNonEmpty("wkt", charSequence);
        ArgumentChecks.ensureNonNull("pos", parsePosition);
        AbstractParser abstractParser = this.parser(false);
        Object object = null;
        try {
            object = abstractParser.createFromWKT(charSequence.toString(), parsePosition);
        }
        finally {
            this.warnings = abstractParser.getAndClearWarnings(object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object buildFromTree(StoredTree storedTree) throws ParseException {
        this.clear();
        AbstractParser abstractParser = this.parser(false);
        abstractParser.ignoredElements.clear();
        SingletonElement singletonElement = new SingletonElement();
        storedTree.toElements(abstractParser, singletonElement, 0);
        Element element = new Element(singletonElement.value);
        Object object = null;
        try {
            object = abstractParser.buildFromTree(element);
            element.close(abstractParser.ignoredElements);
        }
        finally {
            this.warnings = abstractParser.getAndClearWarnings(object);
        }
        return object;
    }

    private AbstractParser parser(boolean bl) {
        AbstractParser abstractParser = this.parser;
        if (abstractParser == null || this.isCloned & bl) {
            this.parser = abstractParser = new Parser(this.symbols, this.fragments(bl), (NumberFormat)this.getFormat(Number.class), (DateFormat)this.getFormat(Date.class), (UnitFormat)this.getFormat(Unit.class), this.convention, this.transliterator != null ? this.transliterator : Transliterator.DEFAULT, this.getErrorLocale(), this.factories());
        }
        return abstractParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void format(Object object, Appendable appendable) throws IOException {
        this.clear();
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("toAppendTo", appendable);
        StringBuffer stringBuffer = appendable instanceof StringBuffer ? (StringBuffer)appendable : new StringBuffer(500);
        Formatter formatter = this.formatter;
        if (formatter == null) {
            formatter = new Formatter(this.getLocale(), this.getErrorLocale(), this.symbols, (NumberFormat)this.getFormat(Number.class), (DateFormat)this.getFormat(Date.class), (UnitFormat)this.getFormat(Unit.class));
            this.updateFormatter(formatter);
            this.formatter = formatter;
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            boolean bl;
            try {
                formatter.setBuffer(stringBuffer);
                bl = formatter.appendElement(object) || formatter.appendValue(object);
            }
            finally {
                this.warnings = formatter.getWarnings();
                formatter.setBuffer(null);
                formatter.clear();
            }
            if (this.warnings != null) {
                this.warnings.setRoot(object);
            }
            if (!bl) {
                throw new ClassCastException(this.errors().getString((short)42, "object", object.getClass()));
            }
            if (stringBuffer != appendable) {
                appendable.append(stringBuffer);
            }
        }
    }

    @Override
    protected Format createFormat(Class<?> clazz) {
        if (clazz == Number.class) {
            return this.symbols.createNumberFormat();
        }
        if (clazz == Date.class) {
            return new StandardDateFormat(this.symbols.getLocale(), this.getTimeZone());
        }
        Format format = super.createFormat(clazz);
        if (format instanceof UnitFormat) {
            ((UnitFormat)format).setStyle(UnitFormat.Style.NAME);
        }
        return format;
    }

    public Warnings getWarnings() {
        if (this.warnings != null) {
            this.warnings.publish();
        }
        return this.warnings;
    }

    final void logWarnings(Class<?> clazz, String string) {
        if (this.warnings != null) {
            LogRecord logRecord = new LogRecord(Level.WARNING, this.warnings.toString());
            logRecord.setLoggerName("org.apache.sis.io.wkt");
            Logging.log(clazz, string, logRecord);
        }
    }

    final Errors errors() {
        return Errors.getResources(this.getErrorLocale());
    }

    @Override
    public WKTFormat clone() {
        WKTFormat wKTFormat = (WKTFormat)super.clone();
        wKTFormat.clear();
        wKTFormat.factories = null;
        wKTFormat.formatter = null;
        wKTFormat.parser = null;
        this.isCloned = true;
        wKTFormat.isCloned = true;
        return wKTFormat;
    }

    private final class Parser
    extends GeodeticObjectParser
    implements Function<Object, Object> {
        Parser(Symbols symbols, Map<String, StoredTree> map, NumberFormat numberFormat, DateFormat dateFormat, UnitFormat unitFormat, Convention convention, Transliterator transliterator, Locale locale, ReferencingFactoryContainer referencingFactoryContainer) {
            super(symbols, map, numberFormat, dateFormat, unitFormat, convention, transliterator, locale, referencingFactoryContainer);
        }

        @Override
        String getPublicFacade() {
            return WKTFormat.class.getName();
        }

        @Override
        String getFacadeMethod() {
            return "parse";
        }

        @Override
        public Object apply(Object object) {
            return new ImmutableIdentifier(WKTFormat.this.defaultIdentifier.getAuthority(), WKTFormat.this.defaultIdentifier.getCodeSpace(), WKTFormat.this.defaultIdentifier.getCode(), WKTFormat.this.defaultIdentifier.getVersion(), WKTFormat.this.defaultIdentifier.getDescription());
        }

        @Override
        void completeRoot(Map<String, Object> map) {
            if (WKTFormat.this.defaultIdentifier != null) {
                map.computeIfAbsent("identifiers", this);
            }
        }
    }
}

