/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.util.logging.Logging;

public final class DefaultFactories
extends SystemListener {
    private static final Map<Class<?>, Object> FACTORIES = new IdentityHashMap(4);

    private DefaultFactories() {
        super("org.apache.sis.util");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void classpathChanged() {
        Class<DefaultFactories> clazz = DefaultFactories.class;
        synchronized (DefaultFactories.class) {
            FACTORIES.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized <T> boolean isDefaultInstance(Class<T> clazz, T t2) {
        return t2 == null || FACTORIES.get(clazz) == t2;
    }

    public static synchronized <T> T forClass(Class<T> clazz) {
        T t2 = clazz.cast(FACTORIES.get(clazz));
        if (t2 == null && !FACTORIES.containsKey(clazz)) {
            Object var2_2 = null;
            for (T object : DefaultFactories.createServiceLoader(clazz)) {
                if (object.getClass().getName().startsWith("org.apache.sis.")) {
                    if (t2 != null) {
                        throw new ServiceConfigurationError("Found two implementations of " + clazz);
                    }
                    t2 = object;
                    continue;
                }
                if (var2_2 != null) continue;
                var2_2 = object;
            }
            if (t2 == null) {
                t2 = var2_2;
            }
            if (t2 != null) {
                for (Object object : FACTORIES.values()) {
                    if (object == null || !t2.getClass().equals(object.getClass())) continue;
                    t2 = clazz.cast(object);
                    break;
                }
            }
            FACTORIES.put(clazz, t2);
        }
        return t2;
    }

    public static <T> T forBuildin(Class<T> clazz) {
        T t2 = DefaultFactories.forClass(clazz);
        if (t2 == null) {
            throw new ServiceConfigurationError("Missing \u201cMETA-INF/services/" + clazz.getName() + "\u201d file. The JAR file may be corrupted or the classpath incorrect.");
        }
        return t2;
    }

    public static <T, I extends T> I forBuildin(Class<T> clazz, Class<I> clazz2) {
        T t2 = DefaultFactories.forBuildin(clazz);
        if (!clazz2.isInstance(t2)) {
            throw new ServiceConfigurationError("The \u201cMETA-INF/services/" + clazz.getName() + "\u201d file should contain only \u201c" + clazz2.getName() + "\u201d in the Apache SIS namespace, but we found \u201c" + t2.getClass().getName() + "\u201d.");
        }
        return clazz2.cast(t2);
    }

    public static <T> ServiceLoader<T> createServiceLoader(Class<T> clazz) {
        try {
            return ServiceLoader.load(clazz, DefaultFactories.getContextClassLoader());
        }
        catch (SecurityException securityException) {
            Logging.recoverableException(Logger.getLogger("org.apache.sis.system"), DefaultFactories.class, "createServiceLoader", securityException);
            return ServiceLoader.load(clazz);
        }
    }

    public static ClassLoader getContextClassLoader() throws SecurityException {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        HashSet<ClassLoader> hashSet = new HashSet<ClassLoader>();
        for (ClassLoader classLoader2 = classLoader; classLoader2 != null; classLoader2 = classLoader2.getParent()) {
            hashSet.add(classLoader2);
        }
        boolean bl = false;
        for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
            String string = stackTraceElement.getClassName();
            if (!string.startsWith("org.apache.sis.")) continue;
            try {
                ClassLoader classLoader3;
                if (hashSet.contains(classLoader3)) continue;
                classLoader = classLoader3;
                hashSet.clear();
                for (classLoader3 = Class.forName(string).getClassLoader(); classLoader3 != null; classLoader3 = classLoader3.getParent()) {
                    hashSet.add(classLoader3);
                }
            }
            catch (ClassNotFoundException | SecurityException exception) {
                if (bl) continue;
                bl = true;
                Logging.recoverableException(Logger.getLogger("org.apache.sis.system"), DefaultFactories.class, "getContextClassLoader", exception);
            }
        }
        return classLoader;
    }

    static {
        SystemListener.add(new DefaultFactories());
    }
}

