/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.GeographicToTopocentric;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix4;
import org.apache.sis.referencing.operation.transform.EllipsoidToCentricTransform;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class GeocentricToTopocentric
extends AbstractProvider {
    private static final long serialVersionUID = 6064563343153407987L;
    private static final ParameterDescriptor<Double> ORIGIN_X;
    private static final ParameterDescriptor<Double> ORIGIN_Y;
    private static final ParameterDescriptor<Double> ORIGIN_Z;
    private static final ParameterDescriptorGroup PARAMETERS;

    public GeocentricToTopocentric() {
        super(Conversion.class, PARAMETERS, CartesianCS.class, 3, true, CartesianCS.class, 3, false);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws FactoryException {
        try {
            return GeocentricToTopocentric.create(mathTransformFactory, Parameters.castOrWrap(parameterValueGroup), false);
        }
        catch (TransformException transformException) {
            throw new FactoryException(transformException);
        }
    }

    static MathTransform create(MathTransformFactory mathTransformFactory, Parameters parameters, boolean bl) throws FactoryException, TransformException {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double[] dArray;
        MathTransform mathTransform;
        ParameterValue<?> parameterValue = parameters.parameter("semi_major");
        Unit<Length> unit = parameterValue.getUnit().asType(Length.class);
        double d6 = parameterValue.doubleValue();
        double d7 = parameters.parameter("semi_minor").doubleValue(unit);
        if (bl) {
            mathTransform = EllipsoidToCentricTransform.createGeodeticConversion(mathTransformFactory, d6, d7, unit, true, EllipsoidToCentricTransform.TargetType.CARTESIAN);
            dArray = new double[]{parameters.doubleValue(GeographicToTopocentric.ORIGIN_X), parameters.doubleValue(GeographicToTopocentric.ORIGIN_Y), parameters.doubleValue(GeographicToTopocentric.ORIGIN_Z)};
            d5 = Math.toRadians(dArray[0]);
            d4 = Math.toRadians(dArray[1]);
            mathTransform.transform(dArray, 0, dArray, 0, 1);
            d3 = dArray[0];
            d2 = dArray[1];
            d = dArray[2];
        } else {
            mathTransform = new EllipsoidToCentricTransform(d6, d7, unit, false, EllipsoidToCentricTransform.TargetType.CARTESIAN);
            double[] dArray2 = new double[3];
            d3 = parameters.doubleValue(ORIGIN_X, unit);
            dArray2[0] = d3 / d6;
            d2 = parameters.doubleValue(ORIGIN_Y, unit);
            dArray2[1] = d2 / d6;
            d = parameters.doubleValue(ORIGIN_Z, unit);
            dArray2[2] = d / d6;
            dArray = dArray2;
            mathTransform.inverse().transform(dArray, 0, dArray, 0, 1);
            d5 = dArray[0];
            d4 = dArray[1];
        }
        double d8 = Math.sin(d5);
        double d9 = Math.cos(d5);
        double d10 = Math.sin(d4);
        double d11 = Math.cos(d4);
        MathTransform mathTransform2 = mathTransformFactory.createAffineTransform(new Matrix4(-d8, -d10 * d9, d11 * d9, d3, d9, -d10 * d8, d11 * d8, d2, 0.0, d11, d10, d, 0.0, 0.0, 0.0, 1.0)).inverse();
        if (bl) {
            mathTransform2 = mathTransformFactory.createConcatenatedTransform(mathTransform, mathTransform2);
        }
        return mathTransform2;
    }

    static {
        ParameterBuilder parameterBuilder = GeocentricToTopocentric.builder();
        ORIGIN_X = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8837")).addName("Geocentric X of topocentric origin")).create(Double.NaN, Units.METRE);
        ORIGIN_Y = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8838")).addName("Geocentric Y of topocentric origin")).create(Double.NaN, Units.METRE);
        ORIGIN_Z = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8839")).addName("Geocentric Z of topocentric origin")).create(Double.NaN, Units.METRE);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("9836")).addName("Geocentric/topocentric conversions")).createGroupForMapProjection(ORIGIN_X, ORIGIN_Y, ORIGIN_Z);
    }
}

