/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.IdentifierMapAdapter;
import org.apache.sis.internal.jaxb.IdentifierMapEntry;
import org.apache.sis.internal.jaxb.SpecializedIdentifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.ValueConverter;
import org.apache.sis.xml.XLink;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;

public final class ModifiableIdentifierMap
extends IdentifierMapAdapter {
    private static final long serialVersionUID = -80325787192055778L;

    public ModifiableIdentifierMap(Collection<Identifier> collection) {
        super(collection);
    }

    private URI setHRef(URI uRI) {
        Object object;
        URI uRI2 = this.store(IdentifierSpace.HREF, null);
        Identifier identifier = this.getIdentifier(IdentifierSpace.XLINK);
        if (identifier instanceof SpecializedIdentifier && (object = ((SpecializedIdentifier)identifier).value) instanceof XLink) {
            if (uRI2 == null) {
                uRI2 = ((XLink)object).getHRef();
            }
            ((XLink)object).setHRef(uRI);
            return uRI2;
        }
        if (uRI != null) {
            object = new XLink();
            ((XLink)object).setHRef(uRI);
            this.store(IdentifierSpace.XLINK, object);
        }
        return uRI2;
    }

    @Override
    final boolean isModifiable() {
        return true;
    }

    @Override
    public void clear() {
        this.identifiers.clear();
    }

    @Override
    public String remove(Object object) {
        return object instanceof Citation ? this.put((Citation)object, null) : null;
    }

    @Override
    public String put(Citation citation, String string) {
        Object object;
        Object object2;
        ArgumentChecks.ensureNonNull("authority", citation);
        String string2 = null;
        Object object3 = null;
        switch (ModifiableIdentifierMap.specialCase(citation)) {
            case 2: {
                object2 = null;
                if (string != null) {
                    object = Context.current();
                    ValueConverter valueConverter = Context.converter((Context)object);
                    try {
                        object2 = valueConverter.toURI((MarshalContext)object, string);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        SpecializedIdentifier.parseFailure((Context)object, string, URI.class, uRISyntaxException);
                        object3 = this.setHRef(null);
                        break;
                    }
                }
                object = this.getIdentifier(citation);
                if ((object2 = this.setHRef((URI)object2)) != null) {
                    string2 = ((URI)object2).toString();
                } else if (object != null) {
                    string2 = object.getCode();
                }
                return string2;
            }
        }
        object2 = this.identifiers.iterator();
        while (object2.hasNext()) {
            object = (Identifier)object2.next();
            if (object == null) {
                object2.remove();
                continue;
            }
            if (!Objects.equals(citation, object.getAuthority())) continue;
            if (string != null && object instanceof IdentifierMapEntry) {
                return ((IdentifierMapEntry)object).setValue(string);
            }
            if (string2 == null) {
                string2 = object.getCode();
            }
            object2.remove();
        }
        if (string != null) {
            this.identifiers.add(SpecializedIdentifier.parse(citation, string));
        }
        if (string2 == null && object3 != null) {
            string2 = object3.toString();
        }
        return string2;
    }

    @Override
    public <T> T putSpecialized(IdentifierSpace<T> identifierSpace, T t2) {
        switch (ModifiableIdentifierMap.specialCase(identifierSpace)) {
            default: {
                return this.store(identifierSpace, t2);
            }
            case 2: 
        }
        return (T)this.setHRef((URI)t2);
    }

    private <T> T store(IdentifierSpace<T> identifierSpace, T t2) {
        ArgumentChecks.ensureNonNull("authority", identifierSpace);
        T t3 = null;
        Iterator iterator = this.identifiers.iterator();
        while (iterator.hasNext()) {
            Identifier identifier = (Identifier)iterator.next();
            if (identifier == null) {
                iterator.remove();
                continue;
            }
            if (!Objects.equals(identifierSpace, identifier.getAuthority())) continue;
            if (identifier instanceof SpecializedIdentifier) {
                SpecializedIdentifier specializedIdentifier = (SpecializedIdentifier)identifier;
                if (t3 == null) {
                    t3 = specializedIdentifier.value;
                }
                if (t2 != null) {
                    specializedIdentifier.value = t2;
                    return t3;
                }
            }
            iterator.remove();
        }
        if (t2 != null) {
            this.identifiers.add(new SpecializedIdentifier<T>(identifierSpace, t2));
        }
        return t3;
    }
}

