/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.coverage.j2d.ColorsForRange;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.ScaledColorSpace;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.InternationalString;

public final class Colorizer {
    public static final ColorModel NULL_COLOR_MODEL = null;
    private static final InternationalString TRANSPARENT = Vocabulary.formatInternational((short)249);
    private static final InternationalString COLOR_INDEX = Vocabulary.formatInternational((short)30);
    private static final InternationalString VISUAL = Vocabulary.formatInternational((short)221);
    private static final int MAX_VALUE = 255;
    public static final int TYPE_COMPACT = 0;
    public static final Function<Category, Color[]> GRAYSCALE = category -> {
        Color[] colorArray;
        if (category.isQuantitative()) {
            Color[] colorArray2 = new Color[2];
            colorArray2[0] = Color.BLACK;
            colorArray = colorArray2;
            colorArray2[1] = Color.WHITE;
        } else {
            colorArray = null;
        }
        return colorArray;
    };
    private final Function<Category, Color[]> colors;
    private ColorsForRange[] entries;
    private SampleDimension source;
    private SampleDimension target;
    private NumberRange<?> defaultRange;

    public Colorizer(Collection<Map.Entry<NumberRange<?>, Color[]>> collection) {
        ArgumentChecks.ensureNonNull("colors", collection);
        this.entries = ColorsForRange.list(collection);
        this.colors = GRAYSCALE;
    }

    public Colorizer(Function<Category, Color[]> function) {
        this.colors = function != null ? function : GRAYSCALE;
    }

    private void checkInitializationStatus(boolean bl) {
        if (this.entries != null != bl) {
            throw new IllegalStateException(Errors.format(bl ? (short)189 : 188, this.getClass()));
        }
    }

    private static boolean isAlreadyScaled(NumberRange<?> numberRange) {
        return numberRange.getMinDouble(true) == 0.0 && numberRange.getMaxDouble(true) == 255.0;
    }

    public boolean initialize(SampleModel sampleModel, SampleDimension sampleDimension) {
        this.checkInitializationStatus(false);
        if (sampleDimension != null) {
            this.source = sampleDimension;
            List<Category> list = sampleDimension.getCategories();
            if (!list.isEmpty()) {
                int n;
                boolean bl = true;
                ColorsForRange[] colorsForRangeArray = new ColorsForRange[list.size()];
                for (n = 0; n < colorsForRangeArray.length; ++n) {
                    Category category = list.get(n);
                    colorsForRangeArray[n] = new ColorsForRange(category, this.colors);
                    bl &= category.isQuantitative();
                }
                if (bl && (sampleModel == null || !ImageUtilities.isIntegerType(sampleModel))) {
                    n = colorsForRangeArray.length;
                    colorsForRangeArray = Arrays.copyOf(colorsForRangeArray, n + 1);
                    colorsForRangeArray[n] = new ColorsForRange(TRANSPARENT, NumberRange.create(Float.class, Float.valueOf(Float.NaN)), null, false);
                }
                this.entries = colorsForRangeArray;
                return true;
            }
        }
        return false;
    }

    public boolean initialize(SampleModel sampleModel, int n) {
        this.checkInitializationStatus(false);
        if (ImageUtilities.isIntegerType(sampleModel)) {
            long l = 0L;
            long l2 = Numerics.bitmask(sampleModel.getSampleSize(n)) - 1L;
            if (!ImageUtilities.isUnsignedType(sampleModel)) {
                l = (l2 >>>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            this.initialize(l, l2);
            return true;
        }
        return false;
    }

    public boolean initialize(ColorModel colorModel) {
        ColorSpace colorSpace;
        this.checkInitializationStatus(false);
        if (colorModel != null && (colorSpace = colorModel.getColorSpace()) instanceof ScaledColorSpace) {
            ScaledColorSpace scaledColorSpace = (ScaledColorSpace)colorSpace;
            this.initialize(scaledColorSpace.offset, scaledColorSpace.maximum);
            return true;
        }
        return false;
    }

    public void initialize(double d, double d2) {
        this.checkInitializationStatus(false);
        ArgumentChecks.ensureFinite("minimum", d);
        ArgumentChecks.ensureFinite("maximum", d2);
        this.defaultRange = NumberRange.create(d, true, d2, true);
        this.target = new SampleDimension.Builder().setBackground(TRANSPARENT, 0).addQuantitative(COLOR_INDEX, NumberRange.create(1, true, 255, true), this.defaultRange).setName(VISUAL).build();
        this.source = this.target.forConvertedValues(true);
        List<Category> list = this.target.getCategories();
        ColorsForRange[] colorsForRangeArray = new ColorsForRange[list.size()];
        for (int i = 0; i < colorsForRangeArray.length; ++i) {
            Category category;
            colorsForRangeArray[i] = new ColorsForRange(category, (category = list.get(i)).getName() == TRANSPARENT ? GRAYSCALE : this.colors);
        }
        this.entries = colorsForRangeArray;
    }

    public void rescaleMainRange(ColorModel colorModel) {
        ColorSpace colorSpace;
        this.checkInitializationStatus(true);
        if (colorModel != null && (colorSpace = colorModel.getColorSpace()) instanceof ScaledColorSpace) {
            ScaledColorSpace scaledColorSpace = (ScaledColorSpace)colorSpace;
            double d = scaledColorSpace.offset;
            double d2 = scaledColorSpace.maximum;
            ColorsForRange colorsForRange = null;
            double d3 = 0.0;
            for (ColorsForRange colorsForRange2 : this.entries) {
                double d4 = Math.min(colorsForRange2.sampleRange.getMaxDouble(), d2) - Math.max(colorsForRange2.sampleRange.getMinDouble(), d);
                if (!(d4 > d3)) continue;
                d3 = d4;
                colorsForRange = colorsForRange2;
            }
            this.defaultRange = NumberRange.create(d, true, d2, false);
            if (colorsForRange != null && d3 != colorsForRange.sampleRange.getSpan()) {
                colorsForRange.sampleRange = this.defaultRange;
                this.target = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void compact() {
        void var13_26;
        int n;
        Object[] objectArray;
        block23: {
            if (this.target != null) {
                return;
            }
            objectArray = this.entries;
            if (this.source != null) {
                this.target = this.source.forConvertedValues(false);
                if (this.target.getSampleRange().filter(Colorizer::isAlreadyScaled).isPresent()) {
                    int n2;
                    if (this.target == this.source) {
                        return;
                    }
                    HashMap hashMap = new HashMap();
                    for (Category category : this.target.getCategories()) {
                        if (hashMap.put(category.forConvertedValues(true).getSampleRange(), category.getSampleRange()) == null) continue;
                        break block23;
                    }
                    NumberRange[] numberRangeArray = new NumberRange[objectArray.length];
                    for (n2 = 0; n2 < objectArray.length; ++n2) {
                        numberRangeArray[n2] = (NumberRange)hashMap.remove(((ColorsForRange)objectArray[n2]).sampleRange);
                        if (numberRangeArray[n2] != null) {
                            continue;
                        }
                        break block23;
                    }
                    for (n2 = 0; n2 < objectArray.length; ++n2) {
                        ((ColorsForRange)objectArray[n2]).sampleRange = numberRangeArray[n2];
                    }
                    return;
                }
            }
        }
        Arrays.sort(objectArray);
        double d = 0.0;
        int n3 = 0;
        int n4 = 0;
        int n5 = objectArray.length;
        NumberRange<Object> numberRange = null;
        HashMap<NumberRange<Integer>, Object> hashMap = new HashMap<NumberRange<Integer>, Object>();
        SampleDimension.Builder builder = new SampleDimension.Builder();
        for (n = 0; n < n5; ++n) {
            Object object = objectArray[n];
            NumberRange<Object> numberRange2 = ((ColorsForRange)object).sampleRange;
            if (!((ColorsForRange)object).isData) {
                NumberRange<Integer> numberRange3;
                if (n3 >= 255) {
                    throw new IllegalArgumentException(Resources.format((short)62));
                }
                if (hashMap.put(numberRange3 = NumberRange.create(n3++, true, n3, false), object) != null) continue;
                double category = numberRange2.getMinDouble();
                if (Double.isNaN(category)) {
                    builder.mapQualitative(((ColorsForRange)object).name, numberRange3, (float)category);
                    continue;
                }
                if (category == ((ColorsForRange)object).sampleRange.getMaxDouble()) {
                    numberRange2 = NumberRange.create(category - 0.5, true, category + 0.5, false);
                }
                builder.addQuantitative(((ColorsForRange)object).name, numberRange3, numberRange2);
                numberRange = numberRange != null ? numberRange.unionAny(numberRange2) : numberRange2;
                continue;
            }
            double d3 = numberRange2.getSpan();
            if (d3 > 0.0) {
                d += d3;
                System.arraycopy(objectArray, n4, objectArray, n4 + 1, n - n4);
                objectArray[n4++] = object;
                continue;
            }
            System.arraycopy(objectArray, n + 1, objectArray, n, --n5 - n);
            objectArray[n5] = null;
        }
        if (n4 == 0 && numberRange != null) {
            if (this.defaultRange == null) {
                this.defaultRange = NumberRange.create(0, true, 32768, false);
            }
            for (NumberRange<?> numberRange2 : this.defaultRange.subtractAny(numberRange)) {
                d += numberRange2.getSpan();
                ColorsForRange[] colorsForRangeArray = (ColorsForRange[])Arrays.copyOf(objectArray, ++n5);
                System.arraycopy(objectArray, n4++, colorsForRangeArray, n4, n5 - n4);
                colorsForRangeArray[n4 - 1] = new ColorsForRange(null, numberRange2, new Color[]{Color.BLACK, Color.WHITE}, true);
                objectArray = colorsForRangeArray;
            }
        }
        objectArray = (ColorsForRange[])ArraysExt.resize(objectArray, n5);
        this.entries = objectArray;
        n = n3;
        double d4 = (double)(256 - n) / d;
        d = 0.0;
        boolean bl = false;
        while (var13_26 < n4) {
            Object object = objectArray[var13_26];
            int n2 = Math.toIntExact(Math.round((d += ((ColorsForRange)object).sampleRange.getSpan()) * d4) + (long)n);
            if (n2 <= n3) {
                throw new IllegalArgumentException(Resources.format((short)62));
            }
            NumberRange<Integer> numberRange3 = NumberRange.create(n3, true, n2, false);
            if (hashMap.put(numberRange3, object) == null) {
                builder.addQuantitative(((ColorsForRange)object).name, numberRange3, ((ColorsForRange)object).sampleRange);
            }
            n3 = n2;
            ++var13_26;
        }
        if (this.source != null) {
            builder.setName(this.source.getName());
        } else {
            builder.setName(VISUAL);
        }
        this.target = builder.build();
        for (Category category : this.target.getCategories()) {
            NumberRange<?> numberRange4 = category.getSampleRange();
            ((ColorsForRange)hashMap.get(numberRange4)).sampleRange = numberRange4;
        }
    }

    public ColorModel createColorModel(int n, int n2, int n3) {
        this.checkInitializationStatus(true);
        ArgumentChecks.ensureStrictlyPositive("numBands", n2);
        ArgumentChecks.ensureBetween("visibleBand", 0, n2 - 1, n3);
        return ColorModelFactory.createPiecewise(n, n2, n3, this.entries);
    }

    public ColorModel compactColorModel(int n, int n2) {
        this.checkInitializationStatus(true);
        this.compact();
        return this.createColorModel(0, n, n2);
    }

    public MathTransform1D getSampleToIndexValues() throws NoninvertibleTransformException {
        this.checkInitializationStatus(true);
        return this.target != null ? this.target.getTransferFunction().orElseGet(Colorizer::identity).inverse() : Colorizer.identity();
    }

    private static MathTransform1D identity() {
        return (MathTransform1D)((Object)MathTransforms.identity(1));
    }
}

