/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureType;
import org.apache.sis.feature.Field;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class FeatureFormat
extends TabularFormat<Object> {
    private static final long serialVersionUID = -5792086817264884947L;
    private static final String SEPARATOR = ", ";
    private static final AtomicReference<FeatureFormat> INSTANCE = new AtomicReference();
    private final Locale displayLocale;
    private final EnumSet<Column> columns = EnumSet.allOf(Column.class);
    private static final int MAXIMAL_VALUE_LENGTH = 40;
    private transient int illegalNaN;

    public FeatureFormat() {
        super(Locale.getDefault(Locale.Category.FORMAT), TimeZone.getDefault());
        this.displayLocale = Locale.getDefault(Locale.Category.DISPLAY);
        this.columnSeparator = " \u2502 ";
    }

    public FeatureFormat(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
        this.displayLocale = locale != null ? locale : Locale.ROOT;
        this.columnSeparator = " \u2502 ";
    }

    @Override
    public final Class<Object> getValueType() {
        return Object.class;
    }

    @Override
    public Locale getLocale(Locale.Category category) {
        return category == Locale.Category.DISPLAY ? this.displayLocale : super.getLocale(category);
    }

    public Set<Column> getAllowedColumns() {
        return this.columns.clone();
    }

    public void setAllowedColumns(Set<Column> set) {
        ArgumentChecks.ensureNonNull("inclusion", set);
        this.columns.clear();
        this.columns.addAll(set);
    }

    private void nextColumn(TableAppender tableAppender) {
        tableAppender.append(this.beforeFill);
        tableAppender.nextColumn(this.fillCharacter);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void format(Object var1_1, Appendable var2_2) throws IOException {
        ArgumentChecks.ensureNonNull("object", var1_1);
        ArgumentChecks.ensureNonNull("toAppendTo", var2_2);
        if (var1_1 instanceof AbstractFeature) {
            var4_3 = (AbstractFeature)var1_1;
            var3_4 = var4_3.getType();
        } else if (var1_1 instanceof DefaultFeatureType) {
            var3_4 = (DefaultFeatureType)var1_1;
            var4_3 = null;
        } else {
            throw new IllegalArgumentException(Errors.getResources(this.displayLocale).getString((short)163, var1_1.getClass()));
        }
        var5_5 = this.columns.clone();
        var6_6 = false;
        var7_9 = false;
        var8_12 = false;
        for (AbstractIdentifiedType var10_16 : var3_4.getProperties(true)) {
            if (!var6_6) {
                v0 = var6_6 = var10_16 /* !! */ .getDesignation() != null;
            }
            if (!var7_9 && var10_16 /* !! */  instanceof DefaultAttributeType) {
                v1 = var7_9 = ((DefaultAttributeType)var10_16 /* !! */ ).characteristics().isEmpty() == false;
            }
            if (var8_12 || !(var10_16 /* !! */  instanceof Deprecable)) continue;
            var8_12 = var10_16 /* !! */ .isDeprecated();
        }
        if (!var6_6) {
            var5_5.remove((Object)Column.DESIGNATION);
        }
        if (!var7_9) {
            var5_5.remove((Object)Column.CHARACTERISTICS);
        }
        if (!var8_12) {
            var5_5.remove((Object)Column.REMARKS);
        }
        var2_2.append(this.toString(var3_4.getName()));
        if (var4_3 == null) {
            var6_7 = " \u21fe ";
            for (FeatureType var8_13 : var3_4.getSuperTypes()) {
                var2_2.append(var6_7).append(this.toString(var8_13.getName()));
                var6_7 = ", ";
            }
            var7_10 = var3_4.getDefinition();
            if (var7_10 != null && (var8_14 = Strings.trimOrNull(var7_10.toString(this.displayLocale))) != null) {
                var2_2.append(this.getLineSeparator()).append(var8_14);
            }
        }
        var2_2.append(this.getLineSeparator());
        var6_8 = Vocabulary.getResources(this.displayLocale);
        var7_11 = new TableAppender(var2_2, this.columnSeparator);
        var7_11.setMultiLinesCells(true);
        var7_11.nextLine('\u2500');
        var8_12 = true;
        var9_15 = var5_5.iterator();
        while (var9_15.hasNext()) {
            var10_16 /* !! */  = (Column)var9_15.next();
            var11_17 = var10_16 /* !! */ .resourceKey;
            if (var4_3 == null) {
                if (var11_17 == 20) {
                    var11_17 = 138;
                }
                if (var11_17 == 213) {
                    var11_17 = 56;
                }
            }
            if (!var8_12) {
                this.nextColumn(var7_11);
            }
            var7_11.append(var6_8.getString((short)var11_17));
            var8_12 = false;
        }
        var7_11.nextLine();
        var7_11.nextLine('\u2500');
        var9_15 = new StringBuffer();
        var10_16 /* !! */  = new FieldPosition(-1);
        var11_18 = new ArrayList<String>();
        for (AbstractIdentifiedType var13_21 : var3_4.getProperties(true)) {
            var14_23 = null;
            var15_24 = -1;
            if (var4_3 != null) {
                if (!(var13_21 instanceof DefaultAttributeType) && !(var13_21 instanceof DefaultAssociationRole) && !DefaultFeatureType.isParameterlessOperation(var13_21)) continue;
                var14_23 = var4_3.getPropertyValue(var13_21.getName().toString());
                if (var14_23 == null) {
                    if (var13_21 instanceof DefaultAttributeType && ((DefaultAttributeType)var13_21).getMinimumOccurs() == 0 && ((DefaultAttributeType)var13_21).characteristics().isEmpty() || var13_21 instanceof DefaultAssociationRole && ((DefaultAssociationRole)var13_21).getMinimumOccurs() == 0) continue;
                    var15_24 = 0;
                } else {
                    var15_24 = var14_23 instanceof Collection ? ((Collection)var14_23).size() : 1;
                }
            } else if (var13_21 instanceof DefaultAttributeType) {
                var14_23 = ((DefaultAttributeType)var13_21).getDefaultValue();
            } else if (var13_21 instanceof AbstractOperation) {
                var9_15.append(" = ");
                try {
                    ((AbstractOperation)var13_21).formatResultFormula((Appendable)var9_15);
                }
                catch (IOException var16_26) {
                    throw new UncheckedIOException(var16_26);
                }
                var14_23 = CharSequences.trimWhitespaces((CharSequence)var9_15).toString();
                var9_15.setLength(0);
            }
            var20_30 = var13_21 instanceof AbstractOperation != false ? ((AbstractOperation)var13_21).getResult() : var13_21;
            if (var20_30 instanceof DefaultAttributeType) {
                var21_31 = (DefaultAttributeType)var20_30;
                var18_28 = var21_31.getMinimumOccurs();
                var19_29 = var21_31.getMaximumOccurs();
                var17_27 = var21_31.getValueClass();
                var16_25 = this.getFormat(Class.class).format(var17_27, (StringBuffer)var9_15, (FieldPosition)var10_16 /* !! */ ).toString();
                var9_15.setLength(0);
            } else if (var20_30 instanceof DefaultAssociationRole) {
                var21_31 = (DefaultAssociationRole)var20_30;
                var18_28 = var21_31.getMinimumOccurs();
                var19_29 = var21_31.getMaximumOccurs();
                var16_25 = this.toString(DefaultAssociationRole.getValueTypeName((DefaultAssociationRole)var21_31));
                var17_27 = AbstractFeature.class;
            } else {
                var16_25 = var20_30 != null ? this.toString(var20_30.getName()) : "";
                var17_27 = null;
                var18_28 = -1;
                var19_29 = -1;
            }
            var8_12 = true;
            var21_31 = var5_5.iterator();
            block17: while (var21_31.hasNext()) {
                var22_32 = (Column)var21_31.next();
                if (!var8_12) {
                    this.nextColumn(var7_11);
                }
                var8_12 = false;
                block2 : switch (1.$SwitchMap$org$apache$sis$feature$FeatureFormat$Column[var22_32.ordinal()]) {
                    case 1: {
                        var23_33 = var13_21.getDesignation();
                        if (var23_33 == null) break;
                        var7_11.append(var23_33.toString(this.displayLocale));
                        break;
                    }
                    case 2: {
                        var7_11.append(this.toString(var13_21.getName()));
                        break;
                    }
                    case 3: {
                        var7_11.append(var16_25);
                        break;
                    }
                    case 4: {
                        var7_11.setCellAlignment((byte)1);
                        if (var15_24 >= 0) {
                            var7_11.append(this.getFormat(Integer.class).format(var15_24, (StringBuffer)var9_15, (FieldPosition)var10_16 /* !! */ ));
                            var9_15.setLength(0);
                        }
                        if (var19_29 < 0) break;
                        if (var15_24 >= 0) {
                            var7_11.append(' ').append((char)(var15_24 >= var18_28 && var15_24 <= var19_29 ? 8712 : 8713)).append(' ');
                        }
                        var23_34 = this.getFormat(Integer.class);
                        var7_11.append('[').append(var23_34.format(var18_28, (StringBuffer)var9_15, (FieldPosition)var10_16 /* !! */ )).append(" \u2026 ");
                        var9_15.setLength(0);
                        if (var19_29 != 0x7FFFFFFF) {
                            var7_11.append(var23_34.format(var19_29, (StringBuffer)var9_15, (FieldPosition)var10_16 /* !! */ ));
                        } else {
                            var7_11.append('\u221e');
                        }
                        var9_15.setLength(0);
                        var7_11.append(']');
                        break;
                    }
                    case 5: {
                        var7_11.setCellAlignment((byte)-1);
                        var23_35 = this.getFormat(var17_27);
                        var24_38 = CollectionsExt.toCollection(var14_23).iterator();
                        var25_39 = "";
                        var26_40 = 0;
                        while (var24_38.hasNext()) {
                            var14_23 = var24_38.next();
                            if (var14_23 == null) continue;
                            if (!(var13_21 instanceof DefaultAssociationRole)) ** GOTO lbl178
                            var27_42 = DefaultAssociationRole.getTitleProperty((DefaultAssociationRole)var13_21);
                            if (var27_42 != null && (var14_23 = ((AbstractFeature)var14_23).getPropertyValue((String)var27_42)) == null) {
                                continue;
                            }
                            ** GOTO lbl198
lbl178:
                            // 1 sources

                            if (var23_35 == null || !var17_27.isInstance(var14_23)) ** GOTO lbl198
                            var27_42 = var23_35.format(var14_23, (StringBuffer)var9_15, (FieldPosition)var10_16 /* !! */ );
                            if (!(var14_23 instanceof Number) || !Float.isNaN(var28_43 = ((Number)var14_23).floatValue())) ** GOTO lbl197
                            if ("\ufffd".contentEquals((StringBuffer)var27_42)) {
                                var27_42.setLength(0);
                                var27_42.append("NaN");
                            }
                            try {
                                var29_45 = MathFunctions.toNanOrdinal(var28_43);
                                if (var29_45 > 0) {
                                    var27_42.append(" #").append(var29_45);
                                }
                            }
                            catch (IllegalArgumentException var29_46) {
                                var30_48 = Float.floatToRawIntBits(var28_43);
                                if (var30_48 == this.illegalNaN) ** GOTO lbl197
                                this.illegalNaN = var30_48;
                                Logging.recoverableException(Logger.getLogger("org.apache.sis.feature"), FeatureFormat.class, "format", var29_46);
                            }
lbl197:
                            // 4 sources

                            var14_23 = var27_42;
lbl198:
                            // 3 sources

                            var26_40 = this.formatValue(var14_23, var7_11.append((CharSequence)var25_39), var26_40);
                            var9_15.setLength(0);
                            if (var26_40 < 0) break block2;
                            var25_39 = ", ";
                            var26_40 += ", ".length();
                        }
                        break;
                    }
                    case 6: {
                        if (!(var13_21 instanceof DefaultAttributeType)) break;
                        var23_36 = 0;
                        var24_38 = "";
                        for (DefaultAttributeType var26_41 : ((DefaultAttributeType)var13_21).characteristics().values()) {
                            var27_42 = var26_41.getName();
                            var28_44 = this.toString((GenericName)var27_42);
                            var7_11.append((CharSequence)var24_38).append(var28_44);
                            var23_36 += var24_38.length() + var28_44.length();
                            var29_47 /* !! */  = CollectionsExt.singletonOrEmpty(var26_41.getDefaultValue());
                            if (var4_3 != null && (var30_49 = var4_3.getProperty(var13_21.getName().toString())) instanceof AbstractAttribute && (var31_51 = ((AbstractAttribute)var30_49).characteristics().get(var27_42.toString())) != null) {
                                var29_47 /* !! */  = var31_51.getValues();
                            }
                            var30_48 = var26_41.getMaximumOccurs() > 1 ? 1 : 0;
                            var31_51 = var30_48 != 0 ? " = {" : " = ";
                            for (E var33_53 : var29_47 /* !! */ ) {
                                var23_36 += var31_51.length();
                                var23_36 = this.formatValue(var33_53, var7_11.append((CharSequence)var31_51), var23_36);
                                if (var23_36 < 0) break block2;
                                var31_51 = ", ";
                            }
                            var24_38 = ", ";
                            if (var30_48 == 0 || var31_51 != ", ") continue;
                            var7_11.append('}');
                        }
                        continue block17;
                    }
                    case 7: {
                        if (!Field.isDeprecated(var13_21)) break;
                        var7_11.append(var6_8.getString((short)57));
                        var23_37 = var13_21.getRemarks();
                        if (var23_37 == null) break;
                        var11_18.add(var23_37.toString(this.displayLocale));
                        FeatureFormat.appendSuperscript(var11_18.size(), var7_11);
                    }
                }
            }
            var7_11.nextLine();
        }
        var7_11.nextLine('\u2500');
        var7_11.flush();
        var12_20 = var11_18.size();
        for (var13_22 = 0; var13_22 < var12_20; ++var13_22) {
            FeatureFormat.appendSuperscript(var13_22 + 1, var2_2);
            var2_2.append(' ').append((CharSequence)var11_18.get(var13_22)).append(this.lineSeparator);
        }
    }

    private String toString(GenericName genericName) {
        String string;
        if (genericName == null) {
            return "";
        }
        InternationalString internationalString = genericName.toInternationalString();
        if (internationalString != null && (string = internationalString.toString(this.displayLocale)) != null) {
            return string;
        }
        return genericName.toString();
    }

    private int formatValue(Object object, TableAppender tableAppender, int n) {
        int n2 = 40 - n;
        String string = object instanceof InternationalString ? ((InternationalString)object).toString(this.displayLocale) : (object instanceof GenericName ? this.toString((GenericName)object) : (object instanceof AbstractIdentifiedType ? this.toString(((AbstractIdentifiedType)object).getName()) : (object instanceof IdentifiedObject ? IdentifiedObjects.getIdentifierOrName((IdentifiedObject)object) : Geometries.wrap(object).map(GeometryWrapper::toString).orElseGet(object::toString))));
        if (n2 >= string.length()) {
            tableAppender.append(string);
            return n + string.length();
        }
        tableAppender.append(string, 0, Math.max(0, n2 - 1)).append('\u2026');
        return -1;
    }

    private static void appendSuperscript(int n, Appendable appendable) throws IOException {
        if (n >= 0 && n < 10) {
            appendable.append(Characters.toSuperScript((char)(48 + n)));
        } else {
            appendable.append('(').append(String.valueOf(n)).append(')');
        }
    }

    static String sharedFormat(Object object) {
        FeatureFormat featureFormat = INSTANCE.getAndSet(null);
        if (featureFormat == null) {
            featureFormat = new FeatureFormat();
        }
        String string = featureFormat.format(object);
        INSTANCE.set(featureFormat);
        return string;
    }

    @Override
    public Object parse(CharSequence charSequence, ParsePosition parsePosition) throws ParseException {
        throw new ParseException(Errors.getResources(this.displayLocale).getString((short)162, "parse"), parsePosition.getIndex());
    }

    @Override
    public FeatureFormat clone() {
        return (FeatureFormat)super.clone();
    }

    public static enum Column {
        DESIGNATION(60),
        NAME(139),
        TYPE(203),
        CARDINALITY(20),
        VALUE(213),
        CHARACTERISTICS(26),
        REMARKS(169);

        final short resourceKey;

        private Column(short s2) {
            this.resourceKey = s2;
        }
    }
}

