/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.nowrad;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CDM;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;
import ucar.unidata.util.StringUtil2;

public class NOWRadheader {
    static final int NEXET = 2;
    static final int NEXLH = 5;
    static final int NEXLL = 3;
    static final int NEXLM = 4;
    static final int NEXVI = 6;
    static final int NOWRADHF = 0;
    static final int USRADHF = 1;
    public static String[] mons = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private static Logger log = LoggerFactory.getLogger(NOWRadheader.class);
    DateFormatter formatter = new DateFormatter();
    private String cmemo;
    private String ctilt;
    private String ctitle;
    private String cunit;
    private String cname;
    private NetcdfFile ncfile;
    private int numX;
    private int numY;
    private RandomAccessFile raf;

    public boolean isValidFile(RandomAccessFile raf) {
        try {
            long t = raf.length();
            if (t == 0L) {
                throw new IOException("zero length file ");
            }
        }
        catch (IOException e) {
            return false;
        }
        try {
            int p = this.readTop(raf);
            if (p == 0) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    int readTop(RandomAccessFile raf) throws IOException {
        int pos = 0;
        raf.seek(pos);
        int readLen = 35;
        byte[] b = new byte[readLen];
        int rc = raf.read(b);
        if (rc != readLen) {
            return 0;
        }
        if (this.convertunsignedByte2Short(b[0]) != 0 || this.convertunsignedByte2Short(b[1]) != 240 || this.convertunsignedByte2Short(b[2]) != 9) {
            return 0;
        }
        String pidd = new String(b, 15, 5, CDM.utf8Charset);
        if (pidd.contains("NOWRA") || pidd.contains("USRAD") || pidd.contains("NEX")) {
            return 1;
        }
        return 0;
    }

    public byte[] getData(int offset) throws IOException {
        int readLen = (int)this.raf.length();
        byte[] b = new byte[readLen];
        int pos = 0;
        this.raf.seek(pos);
        this.raf.readFully(b);
        return b;
    }

    public void setProperty(String name, String value) {
    }

    void read(RandomAccessFile raf, NetcdfFile ncfile) throws Exception {
        this.raf = raf;
        int readLen = 250;
        this.ncfile = ncfile;
        int pos = 0;
        raf.seek(pos);
        byte[] b = new byte[readLen];
        int rc = raf.read(b);
        if (rc != readLen) {
            log.warn(" error reading nids product header " + raf.getLocation());
        }
        byte hsize = b[3];
        String product = new String(b, 15, 8, CDM.utf8Charset);
        int t1 = 0;
        int ii = 0;
        for (int i = 0; i < readLen; ++i) {
            if (this.convertunsignedByte2Short(b[i + hsize]) != 240 || this.convertunsignedByte2Short(b[i + 1 + hsize]) != 10) continue;
            t1 = i + hsize;
            ii = i;
            break;
        }
        if (t1 == 0) {
            return;
        }
        String lstr = this.trim(new String(b, t1 + 2, 4, CDM.utf8Charset));
        this.numY = Integer.parseInt(lstr);
        String estr = this.trim(new String(b, t1 + 6, 5, CDM.utf8Charset));
        this.numX = Integer.parseInt(estr);
        t1 = 0;
        for (int i = ii; i < readLen; ++i) {
            if (this.convertunsignedByte2Short(b[i + hsize]) != 240 || this.convertunsignedByte2Short(b[i + 1 + hsize]) != 3) continue;
            t1 = i + hsize;
            ii = i;
            break;
        }
        if (t1 == 0) {
            return;
        }
        int off = 0;
        if (product.contains("USRADHF")) {
            off = 3;
        }
        String ts = new String(b, t1 + 22 + off, 2, CDM.utf8Charset);
        int hr = Integer.parseInt(ts);
        ts = new String(b, t1 + 25 + off, 2, CDM.utf8Charset);
        int min2 = Integer.parseInt(ts);
        ts = new String(b, t1 + 28 + off, 2, CDM.utf8Charset);
        int dd = Integer.parseInt(ts);
        String mon = ts = new String(b, t1 + 31 + off, 3, CDM.utf8Charset);
        int month = this.getMonth(mon);
        ts = new String(b, t1 + 35 + off, 2, CDM.utf8Charset);
        int year = Integer.parseInt(ts);
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        sdf.applyPattern("yyyy/MM/dd HH:mm");
        Date date = sdf.parse(year + "/" + month + "/" + dd + " " + hr + ":" + min2);
        t1 = 0;
        for (int i = ii; i < readLen; ++i) {
            if (this.convertunsignedByte2Short(b[i + hsize]) != 240 || this.convertunsignedByte2Short(b[i + 1 + hsize]) != 11) continue;
            t1 = i + hsize;
            break;
        }
        if (t1 == 0) {
            return;
        }
        if (product.contains("NOWRAD")) {
            String ot = new String(b, t1 + 2, 68, CDM.utf8Charset);
            String[] toks = StringUtil2.splitString(ot);
            double nav1 = Math.toDegrees(Double.parseDouble(toks[1]));
            double nav2 = Math.toDegrees(Double.parseDouble(toks[2]));
            double nav3 = Math.toDegrees(Double.parseDouble(toks[3]));
            double nav4 = Math.toDegrees(Double.parseDouble(toks[4]));
            double nav5 = Math.toDegrees(Double.parseDouble(toks[5]));
            float rlat1 = (float)(nav2 - (double)(this.numY - 1) * nav4);
            float rlon1 = (float)(nav1 + nav3);
            float rlat2 = (float)nav2;
            float rlon2 = (float)(nav1 - nav3);
            int hoffset = t1 + 71;
            if (this.convertunsignedByte2Short(b[172 + hsize]) != 240 || this.convertunsignedByte2Short(b[173 + hsize]) != 12) {
                return;
            }
            this.setProductInfo(product, date);
            this.nowrad(hoffset, rlat1, rlon1, rlat2, rlon2, (float)nav4, (float)nav5, date);
        } else if (product.contains("USRADHF")) {
            String ot = new String(b, t1 + 2, 107, CDM.utf8Charset);
            String[] toks = StringUtil2.splitString(ot);
            double nav1 = Math.toDegrees(Double.parseDouble(toks[1]));
            double nav2 = Math.toDegrees(Double.parseDouble(toks[2]));
            double nav3 = Math.toDegrees(Double.parseDouble(toks[3]));
            double nav4 = Math.toDegrees(Double.parseDouble(toks[4]));
            double nav5 = Math.toDegrees(Double.parseDouble(toks[5]));
            double nav6 = Math.toDegrees(Double.parseDouble(toks[6]));
            int hoffset = t1 + 110;
            if (this.convertunsignedByte2Short(b[t1 + 110]) != 240 || this.convertunsignedByte2Short(b[t1 + 111]) != 12) {
                return;
            }
            this.setProductInfo(product, date);
            this.nowradL(hoffset, (float)nav1, (float)nav2, (float)nav3, (float)nav4, (float)nav5, (float)nav6, date);
        }
        ncfile.finish();
    }

    String trim(String str) {
        int len = str.length();
        StringBuilder ostr = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char sc = str.charAt(i);
            if (!Character.isDigit(sc)) continue;
            ostr.append(sc);
        }
        return ostr.toString();
    }

    int getMonth(String m3) {
        for (int i = 0; i < 12; ++i) {
            if (!m3.equalsIgnoreCase(mons[i])) continue;
            return i + 1;
        }
        return 0;
    }

    ProjectionImpl nowradL(int hoff, float lat1, float lat2, float clat, float clon, float lat, float lon, Date dd) {
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        Dimension dimT = new Dimension("time", 1, true, false, false);
        this.ncfile.addDimension(null, dimT);
        String timeCoordName = "time";
        Variable taxis = new Variable(this.ncfile, null, null, timeCoordName);
        taxis.setDataType(DataType.DOUBLE);
        taxis.setDimensions("time");
        taxis.addAttribute(new Attribute("long_name", "time since base date"));
        taxis.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        double[] tdata = new double[]{dd.getTime()};
        Array dataT = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{1}, (Object)tdata);
        taxis.setCachedData(dataT, false);
        DateFormatter formatter = new DateFormatter();
        taxis.addAttribute(new Attribute("units", "msecs since " + formatter.toDateTimeStringISO(new Date(0L))));
        this.ncfile.addVariable(null, taxis);
        dims.add(dimT);
        Dimension jDim = new Dimension("y", this.numY, true, false, false);
        Dimension iDim = new Dimension("x", this.numX, true, false, false);
        dims.add(jDim);
        dims.add(iDim);
        this.ncfile.addDimension(null, iDim);
        this.ncfile.addDimension(null, jDim);
        this.ncfile.addAttribute(null, new Attribute("cdm_data_type", FeatureType.GRID.toString()));
        String coordinates = "time y x";
        Variable v = new Variable(this.ncfile, null, null, this.cname);
        v.setDataType(DataType.BYTE);
        v.setDimensions(dims);
        this.ncfile.addVariable(null, v);
        v.addAttribute(new Attribute("long_name", this.ctitle));
        v.addAttribute(new Attribute("units", this.cunit));
        v.addAttribute(new Attribute("scale_factor", Float.valueOf(5.0f)));
        v.addAttribute(new Attribute("missing_value", 0));
        v.setSPobject(new Vinfo(this.numX, this.numY, hoff));
        v.addAttribute(new Attribute("_CoordinateAxes", coordinates));
        Variable xaxis = new Variable(this.ncfile, null, null, "x");
        xaxis.setDataType(DataType.DOUBLE);
        xaxis.setDimensions("x");
        xaxis.addAttribute(new Attribute("standard_name", "projection x coordinate"));
        xaxis.addAttribute(new Attribute("units", "km"));
        xaxis.addAttribute(new Attribute("_CoordinateAxisType", "GeoX"));
        double[] data1 = new double[this.numX];
        LambertConformal projection = new LambertConformal(clat, clon, lat1, lat2);
        double ullat = 51.8294;
        double ullon = -135.8736;
        double lrlat = 17.2454;
        double lrlon = -70.1154;
        ProjectionPointImpl ptul = (ProjectionPointImpl)projection.latLonToProj(new LatLonPointImpl(ullat, ullon));
        ProjectionPointImpl ptlr = (ProjectionPointImpl)projection.latLonToProj(new LatLonPointImpl(lrlat, lrlon));
        double startX = ptul.getX();
        double startY = ptlr.getY();
        double dx = (ptlr.getX() - ptul.getX()) / (double)(this.numX - 1);
        for (int i = 0; i < this.numX; ++i) {
            data1[i] = startX + (double)i * dx;
        }
        Array dataA = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{this.numX}, (Object)data1);
        xaxis.setCachedData(dataA, false);
        this.ncfile.addVariable(null, xaxis);
        Variable yaxis = new Variable(this.ncfile, null, null, "y");
        yaxis.setDataType(DataType.DOUBLE);
        yaxis.setDimensions("y");
        yaxis.addAttribute(new Attribute("standard_name", "projection y coordinate"));
        yaxis.addAttribute(new Attribute("units", "km"));
        yaxis.addAttribute(new Attribute("_CoordinateAxisType", "GeoY"));
        data1 = new double[this.numY];
        double dy = (ptul.getY() - ptlr.getY()) / (double)(this.numY - 1);
        for (int i = 0; i < this.numY; ++i) {
            data1[i] = startY + (double)i * dy;
        }
        dataA = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{this.numY}, (Object)data1);
        yaxis.setCachedData(dataA, false);
        this.ncfile.addVariable(null, yaxis);
        Variable ct = new Variable(this.ncfile, null, null, projection.getClassName());
        ct.setDataType(DataType.CHAR);
        ct.setDimensions("");
        List<Parameter> params = projection.getProjectionParameters();
        for (Parameter p : params) {
            ct.addAttribute(new Attribute(p));
        }
        ct.addAttribute(new Attribute("_CoordinateTransformType", "Projection"));
        ct.addAttribute(new Attribute("_CoordinateAxes", "x y "));
        dataA = Array.factory(DataType.CHAR.getPrimitiveClassType(), new int[0]);
        dataA.setChar(dataA.getIndex(), ' ');
        ct.setCachedData(dataA, false);
        this.ncfile.addVariable(null, ct);
        return projection;
    }

    ProjectionImpl nowrad(int hoff, float rlat1, float rlon1, float rlat2, float rlon2, float dlat, float dlon, Date dd) {
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        Dimension dimT = new Dimension("time", 1, true, false, false);
        this.ncfile.addDimension(null, dimT);
        String timeCoordName = "time";
        Variable taxis = new Variable(this.ncfile, null, null, timeCoordName);
        taxis.setDataType(DataType.DOUBLE);
        taxis.setDimensions("time");
        taxis.addAttribute(new Attribute("long_name", "time since base date"));
        taxis.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        double[] tdata = new double[]{dd.getTime()};
        Array dataT = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{1}, (Object)tdata);
        taxis.setCachedData(dataT, false);
        DateFormatter formatter = new DateFormatter();
        taxis.addAttribute(new Attribute("units", "msecs since " + formatter.toDateTimeStringISO(new Date(0L))));
        this.ncfile.addVariable(null, taxis);
        dims.add(dimT);
        Dimension jDim = new Dimension("lat", this.numY, true, false, false);
        Dimension iDim = new Dimension("lon", this.numX, true, false, false);
        dims.add(jDim);
        dims.add(iDim);
        this.ncfile.addDimension(null, iDim);
        this.ncfile.addDimension(null, jDim);
        this.ncfile.addAttribute(null, new Attribute("cdm_data_type", FeatureType.GRID.toString()));
        String coordinates = "time lat lon";
        Variable v = new Variable(this.ncfile, null, null, this.cname);
        v.setDataType(DataType.BYTE);
        v.setDimensions(dims);
        this.ncfile.addVariable(null, v);
        v.addAttribute(new Attribute("long_name", this.ctitle));
        v.addAttribute(new Attribute("scale_factor", Float.valueOf(5.0f)));
        v.addAttribute(new Attribute("missing_value", 0));
        v.addAttribute(new Attribute("units", this.cunit));
        v.setSPobject(new Vinfo(this.numX, this.numY, hoff));
        v.addAttribute(new Attribute("_CoordinateAxes", coordinates));
        Variable xaxis = new Variable(this.ncfile, null, null, "lon");
        xaxis.setDataType(DataType.DOUBLE);
        xaxis.setDimensions("lon");
        xaxis.addAttribute(new Attribute("long_name", "longitude"));
        xaxis.addAttribute(new Attribute("units", "degree"));
        xaxis.addAttribute(new Attribute("_CoordinateAxisType", "Lon"));
        double[] data1 = new double[this.numX];
        for (int i = 0; i < this.numX; ++i) {
            data1[i] = rlon1 + (float)i * dlon;
        }
        Array dataA = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{this.numX}, (Object)data1);
        xaxis.setCachedData(dataA, false);
        this.ncfile.addVariable(null, xaxis);
        Variable yaxis = new Variable(this.ncfile, null, null, "lat");
        yaxis.setDataType(DataType.DOUBLE);
        yaxis.setDimensions("lat");
        yaxis.addAttribute(new Attribute("long_name", "latitude"));
        yaxis.addAttribute(new Attribute("units", "degree"));
        yaxis.addAttribute(new Attribute("_CoordinateAxisType", "Lat"));
        data1 = new double[this.numY];
        for (int i = 0; i < this.numY; ++i) {
            data1[i] = rlat1 + (float)i * dlat;
        }
        dataA = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{this.numY}, (Object)data1);
        yaxis.setCachedData(dataA, false);
        this.ncfile.addVariable(null, yaxis);
        return null;
    }

    void setProductInfo(String prod, Date dd) {
        String summary = null;
        if (prod.contains("NOWRADHF")) {
            this.cmemo = "NOWRAD  Base Reflectivity at Tilt 1";
            this.ctitle = "BREF: Base Reflectivity [dBZ]";
            this.cunit = "dBZ";
            this.cname = "Reflectivity";
            summary = "NOWRAD Product";
        } else if (prod.contains("USRADHF")) {
            this.cmemo = "NOWRAD  Base Reflectivity at Tilt 1";
            this.ctitle = "BREF: Base Reflectivity [dBZ]";
            this.cunit = "dBZ";
            this.cname = "Reflectivity";
            summary = "NOWRAD Product";
        } else if (prod.contains("NEXET")) {
            this.cmemo = "NOWRAD Echo Tops";
            this.ctitle = "Echo Tops Composite";
            this.cunit = "K FT";
            this.cname = "EchoTopsComposite";
            summary = "NOWRAD Product";
        } else if (prod.contains("NEXLL")) {
            this.cmemo = "NOWRAD Layer Comp. Reflectivity - Low";
            this.ctitle = "LayerReflectivityLow";
            this.cunit = "dBZ";
            this.cname = "Reflectivity";
            summary = "NOWRAD Product";
        } else if (prod.contains("NEXLM")) {
            this.cmemo = "NOWRAD Layer Comp. Reflectivity - Mid";
            this.ctitle = "LayerReflectivityMid";
            this.cunit = "dBZ";
            this.cname = "Reflectivity";
            summary = "NOWRAD Product";
        } else if (prod.contains("NEXLH")) {
            this.cmemo = "NOWRAD Layer Comp. Reflectivity - High";
            this.ctitle = "LayerReflectivityHigh";
            this.cunit = "dBZ";
            this.cname = "ReflectivityHigh";
            summary = "NOWRAD Product";
        } else if (prod.contains("NEXVI")) {
            this.cmemo = "NOWRAD ";
            this.ctitle = "Vert. Integrated Liquid Water";
            this.cunit = "Knots";
            this.cname = "VILwater";
            summary = "NOWRAD ";
        } else {
            this.ctilt = "error";
            this.ctitle = "error";
            this.cunit = "error";
            this.cname = "error";
        }
        this.ncfile.addAttribute(null, new Attribute("summary", "NOWRAD radar composite products." + summary));
        this.ncfile.addAttribute(null, new Attribute("title", "NOWRAD"));
        this.ncfile.addAttribute(null, new Attribute("keywords", "NOWRAD"));
        this.ncfile.addAttribute(null, new Attribute("creator_name", "NOAA/NWS"));
        this.ncfile.addAttribute(null, new Attribute("creator_url", "http://www.ncdc.noaa.gov/oa/radar/radarproducts.html"));
        this.ncfile.addAttribute(null, new Attribute("naming_authority", "NOAA/NCDC"));
        this.ncfile.addAttribute(null, new Attribute("base_date", this.formatter.toDateOnlyString(dd)));
        this.ncfile.addAttribute(null, new Attribute("conventions", "_Coordinates"));
        this.ncfile.addAttribute(null, new Attribute("cdm_data_type", FeatureType.GRID.toString()));
    }

    public static int shortsToInt(short s1, short s2, boolean swapBytes) {
        byte[] b = new byte[]{(byte)(s1 >>> 8), (byte)(s1 >>> 0), (byte)(s2 >>> 8), (byte)(s2 >>> 0)};
        return NOWRadheader.bytesToInt(b, false);
    }

    public static int bytesToInt(byte[] bytes, boolean swapBytes) {
        byte a = bytes[0];
        byte b = bytes[1];
        byte c = bytes[2];
        byte d = bytes[3];
        if (swapBytes) {
            return (a & 0xFF) + ((b & 0xFF) << 8) + ((c & 0xFF) << 16) + ((d & 0xFF) << 24);
        }
        return ((a & 0xFF) << 24) + ((b & 0xFF) << 16) + ((c & 0xFF) << 8) + (d & 0xFF);
    }

    public static int bytesToInt(byte a, byte b, boolean swapBytes) {
        if (swapBytes) {
            return (a & 0xFF) + (b << 8);
        }
        return (a << 8) + (b & 0xFF);
    }

    public short convertunsignedByte2Short(byte b) {
        return b < 0 ? (short)((short)b + 256) : (short)b;
    }

    public int convertShort2unsignedInt(short b) {
        return b < 0 ? -1 * b + 32768 : b;
    }

    public static Date getDate(int julianDays, int msecs) {
        long total = (long)(julianDays - 1) * 24L * 3600L * 1000L + (long)msecs;
        return new Date(total);
    }

    public void flush() throws IOException {
        this.raf.flush();
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }

    static class Vinfo {
        long hoff;
        int xt;
        int yt;

        Vinfo(int xt, int yt, long hoff) {
            this.xt = xt;
            this.yt = yt;
            this.hoff = hoff;
        }
    }
}

