/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.InflaterInputStream;
import org.itadaki.bzip2.BZip2InputStream;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Variable;
import ucar.nc2.iosp.LayoutBB;
import ucar.nc2.iosp.LayoutBBTiled;
import ucar.nc2.iosp.hdf5.DataBTree;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.util.IO;
import ucar.unidata.io.RandomAccessFile;

class H5tiledLayoutBB
implements LayoutBB {
    private LayoutBBTiled delegate;
    private RandomAccessFile raf;
    private H5header.Filter[] filters;
    private ByteOrder byteOrder;
    private Section want;
    private int[] chunkSize;
    private int elemSize;
    private int nChunkDims;
    private boolean debug = false;

    H5tiledLayoutBB(Variable v2, Section wantSection, RandomAccessFile raf, H5header.Filter[] filters, ByteOrder byteOrder) throws InvalidRangeException, IOException {
        wantSection = Section.fill(wantSection, v2.getShape());
        H5header.Vinfo vinfo = (H5header.Vinfo)v2.getSPobject();
        assert (vinfo.isChunked);
        assert (vinfo.btree != null);
        this.raf = raf;
        this.filters = filters;
        this.byteOrder = byteOrder;
        DataType dtype = v2.getDataType();
        this.want = dtype == DataType.CHAR && wantSection.getRank() < vinfo.storageSize.length ? new Section(wantSection).appendRange(1) : wantSection;
        this.nChunkDims = dtype == DataType.CHAR ? vinfo.storageSize.length : vinfo.storageSize.length - 1;
        this.chunkSize = new int[this.nChunkDims];
        System.arraycopy(vinfo.storageSize, 0, this.chunkSize, 0, this.nChunkDims);
        this.elemSize = vinfo.storageSize[vinfo.storageSize.length - 1];
        DataBTree.DataChunkIterator iter = vinfo.btree.getDataChunkIteratorFilter(this.want);
        DataChunkIterator dcIter = new DataChunkIterator(iter);
        this.delegate = new LayoutBBTiled(dcIter, this.chunkSize, this.elemSize, this.want);
        if (this.debug) {
            System.out.println(" H5tiledLayout: " + this);
        }
    }

    @Override
    public long getTotalNelems() {
        return this.delegate.getTotalNelems();
    }

    @Override
    public int getElemSize() {
        return this.delegate.getElemSize();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public LayoutBB.Chunk next() throws IOException {
        return this.delegate.next();
    }

    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("want=").append(this.want).append("; ");
        sbuff.append("chunkSize=[");
        for (int i = 0; i < this.chunkSize.length; ++i) {
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(this.chunkSize[i]);
        }
        sbuff.append("] totalNelems=").append(this.getTotalNelems());
        sbuff.append(" elemSize=").append(this.elemSize);
        return sbuff.toString();
    }

    private class DataChunk
    implements LayoutBBTiled.DataChunk {
        DataBTree.DataChunk delegate;

        DataChunk(DataBTree.DataChunk delegate) {
            this.delegate = delegate;
        }

        @Override
        public int[] getOffset() {
            int[] offset = this.delegate.offset;
            if (offset.length > H5tiledLayoutBB.this.nChunkDims) {
                offset = new int[H5tiledLayoutBB.this.nChunkDims];
                System.arraycopy(this.delegate.offset, 0, offset, 0, H5tiledLayoutBB.this.nChunkDims);
            }
            return offset;
        }

        @Override
        public ByteBuffer getByteBuffer() throws IOException {
            byte[] data = new byte[this.delegate.size];
            H5tiledLayoutBB.this.raf.seek(this.delegate.filePos);
            H5tiledLayoutBB.this.raf.readFully(data);
            for (int i = H5tiledLayoutBB.this.filters.length - 1; i >= 0; --i) {
                H5header.Filter f = H5tiledLayoutBB.this.filters[i];
                if (this.isBitSet(this.delegate.filterMask, i)) {
                    if (!H5tiledLayoutBB.this.debug) continue;
                    System.out.println("skip for chunk " + this.delegate);
                    continue;
                }
                if (f.id == 1) {
                    data = this.inflate(data);
                    continue;
                }
                if (f.id == 2) {
                    data = this.shuffle(data, f.data[0]);
                    continue;
                }
                if (f.id == 3) {
                    data = this.checkfletcher32(data);
                    continue;
                }
                if (f.id == 307) {
                    data = this.unbzip2(data);
                    continue;
                }
                throw new RuntimeException("Unknown filter type=" + f.id);
            }
            ByteBuffer result = ByteBuffer.wrap(data);
            result.order(H5tiledLayoutBB.this.byteOrder);
            return result;
        }

        private byte[] inflate(byte[] compressed) throws IOException {
            ByteArrayInputStream in = new ByteArrayInputStream(compressed);
            InflaterInputStream inflater = new InflaterInputStream(in);
            ByteArrayOutputStream out = new ByteArrayOutputStream(8 * compressed.length);
            IO.copy(inflater, out);
            byte[] uncomp = out.toByteArray();
            if (H5tiledLayoutBB.this.debug) {
                System.out.println(" inflate bytes in= " + compressed.length + " bytes out= " + uncomp.length);
            }
            return uncomp;
        }

        private byte[] unbzip2(byte[] compressed) throws IOException {
            int max = 20 * compressed.length;
            byte[] buffer = new byte[max];
            ByteArrayOutputStream out = new ByteArrayOutputStream(20 * compressed.length);
            ByteArrayInputStream in = new ByteArrayInputStream(compressed);
            try (BZip2InputStream bzIn = new BZip2InputStream(in, false);){
                int bytesRead;
                int totRead = 0;
                while ((bytesRead = bzIn.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                    totRead += bytesRead;
                }
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return out.toByteArray();
        }

        private byte[] checkfletcher32(byte[] org) throws IOException {
            byte[] result = new byte[org.length - 4];
            System.arraycopy(org, 0, result, 0, result.length);
            if (H5tiledLayoutBB.this.debug) {
                System.out.println(" checkfletcher32 bytes in= " + org.length + " bytes out= " + result.length);
            }
            return result;
        }

        private byte[] shuffle(byte[] data, int n) throws IOException {
            if (H5tiledLayoutBB.this.debug) {
                System.out.println(" shuffle bytes in= " + data.length + " n= " + n);
            }
            assert (data.length % n == 0);
            if (n <= 1) {
                return data;
            }
            int m3 = data.length / n;
            int[] count = new int[n];
            for (int k = 0; k < n; ++k) {
                count[k] = k * m3;
            }
            byte[] result = new byte[data.length];
            for (int i = 0; i < m3; ++i) {
                for (int j = 0; j < n; ++j) {
                    result[i * n + j] = data[i + count[j]];
                }
            }
            return result;
        }

        boolean isBitSet(int val, int bitno) {
            return (val >>> bitno & 1) != 0;
        }
    }

    private class DataChunkIterator
    implements LayoutBBTiled.DataChunkIterator {
        DataBTree.DataChunkIterator delegate;

        DataChunkIterator(DataBTree.DataChunkIterator delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public LayoutBBTiled.DataChunk next() throws IOException {
            return new DataChunk(this.delegate.next());
        }
    }
}

