/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class TransverseMercator
extends NormalizedProjection {
    private static final long serialVersionUID = -627685138188387835L;
    private static final boolean ALLOW_TRIGONOMETRIC_IDENTITIES = true;
    private static final byte SOUTH_VARIANT = 1;
    private final double cf2;
    private final double cf4;
    private final double cf6;
    private final double cf8;
    private final double ci2;
    private final double ci4;
    private final double ci6;
    private final double ci8;

    private static boolean identityEquals(double d, double d2) {
        return !(Math.abs(d - d2) > 1.5706706731410455E-12 * Math.max(1.0, Math.abs(d2)));
    }

    public TransverseMercator(OperationMethod operationMethod, Parameters parameters) {
        this(TransverseMercator.initializer(operationMethod, parameters));
    }

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        boolean bl = TransverseMercator.identMatch(operationMethod, "(?i).*\\bSouth\\b.*", "9808");
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor>(NormalizedProjection.ParameterRole.class);
        NormalizedProjection.ParameterRole parameterRole = NormalizedProjection.ParameterRole.FALSE_EASTING;
        NormalizedProjection.ParameterRole parameterRole2 = NormalizedProjection.ParameterRole.FALSE_NORTHING;
        if (bl) {
            parameterRole = NormalizedProjection.ParameterRole.FALSE_WESTING;
            parameterRole2 = NormalizedProjection.ParameterRole.FALSE_SOUTHING;
        }
        enumMap.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.internal.referencing.provider.TransverseMercator.LONGITUDE_OF_ORIGIN);
        enumMap.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, org.apache.sis.internal.referencing.provider.TransverseMercator.SCALE_FACTOR);
        enumMap.put(parameterRole, org.apache.sis.internal.referencing.provider.TransverseMercator.FALSE_EASTING);
        enumMap.put(parameterRole2, org.apache.sis.internal.referencing.provider.TransverseMercator.FALSE_NORTHING);
        return new Initializer(operationMethod, parameters, enumMap, bl ? (byte)1 : 0);
    }

    TransverseMercator(Initializer initializer) {
        super(initializer);
        double d = Math.toRadians(initializer.getAndStore(org.apache.sis.internal.referencing.provider.TransverseMercator.LATITUDE_OF_ORIGIN));
        DoubleDouble doubleDouble = initializer.axisLengthRatio();
        doubleDouble.ratio_1m_1p();
        double d2 = doubleDouble.doubleValue();
        double d3 = d2 * d2;
        double d4 = d3 * d2;
        double d5 = d3 * d3;
        this.cf2 = 0.22777777777777777 * d5 + 0.3125 * d4 + -0.6666666666666666 * d3 + d2 / 2.0;
        double d6 = 0.38680555555555557 * d5 + -0.6 * d4 + 0.2708333333333333 * d3;
        double d7 = -0.7357142857142858 * d5 + 0.25416666666666665 * d4;
        double d8 = 0.30729786706349205 * d5;
        this.ci2 = -0.002777777777777778 * d5 + 0.3854166666666667 * d4 + -0.6666666666666666 * d3 + d2 / 2.0;
        double d9 = -0.3034722222222222 * d5 + 0.06666666666666667 * d4 + 0.020833333333333332 * d3;
        double d10 = -0.04404761904761905 * d5 + 0.035416666666666666 * d4;
        double d11 = 0.02726314484126984 * d5;
        DoubleDouble doubleDouble2 = new DoubleDouble(doubleDouble);
        doubleDouble2.square();
        doubleDouble2.series(1.0, 0.25, 0.015625);
        doubleDouble.add(1.0);
        doubleDouble2.divide(doubleDouble);
        double d12 = MathFunctions.asinh(Math.tan(d)) - this.eccentricity * MathFunctions.atanh(this.eccentricity * Math.sin(d));
        double d13 = Math.atan(Math.sinh(d12));
        DoubleDouble doubleDouble3 = new DoubleDouble();
        doubleDouble3.value = d8 * Math.sin(8.0 * d13) + d7 * Math.sin(6.0 * d13) + d6 * Math.sin(4.0 * d13) + this.cf2 * Math.sin(2.0 * d13) + d13;
        doubleDouble3.multiply(doubleDouble2);
        doubleDouble3.negate();
        MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        matrixSIS.convertBefore(0, doubleDouble2, null);
        matrixSIS.convertBefore(1, doubleDouble2, doubleDouble3);
        d9 *= 4.0;
        d10 *= 16.0;
        d11 *= 64.0;
        this.cf4 = d6 *= 4.0;
        this.cf6 = d7 *= 16.0;
        this.cf8 = d8 *= 64.0;
        this.ci4 = d9;
        this.ci6 = d10;
        this.ci8 = d11;
    }

    TransverseMercator(TransverseMercator transverseMercator) {
        super(transverseMercator);
        this.cf2 = transverseMercator.cf2;
        this.cf4 = transverseMercator.cf4;
        this.cf6 = transverseMercator.cf6;
        this.cf8 = transverseMercator.cf8;
        this.ci2 = transverseMercator.ci2;
        this.ci4 = transverseMercator.ci4;
        this.ci6 = transverseMercator.ci6;
        this.ci8 = transverseMercator.ci8;
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory mathTransformFactory) throws FactoryException {
        TransverseMercator transverseMercator = this;
        if (this.eccentricity == 0.0) {
            transverseMercator = new Spherical(this);
        }
        return this.context.completeTransform(mathTransformFactory, transverseMercator);
    }

    private static Matrix outsideDomainOfValidity(double[] dArray, int n, boolean bl) {
        if (dArray != null) {
            dArray[n + 1] = Double.NaN;
            dArray[n] = Double.NaN;
        }
        if (bl) {
            return new Matrix2(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        }
        return null;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        if (Math.abs(d) > 1.5707963267948966 && Math.abs(Math.IEEEremainder(d, Math.PI * 2)) > 1.5707963267948966) {
            return TransverseMercator.outsideDomainOfValidity(dArray2, n2, bl);
        }
        double d3 = Math.sin(d);
        double d4 = Math.sin(d2) * this.eccentricity;
        double d5 = MathFunctions.asinh(Math.tan(d2)) - MathFunctions.atanh(d4) * this.eccentricity;
        double d6 = Math.cosh(d5);
        double d7 = MathFunctions.atanh(d3 / d6);
        double d8 = Math.cosh(d7);
        double d9 = Math.asin(Math.tanh(d5) * d8);
        double d10 = Math.sin(2.0 * d9);
        double d11 = Math.cos(2.0 * d9);
        double d12 = d10 * d10;
        double d13 = d11 * d11;
        double d14 = d10 * d11;
        assert (TransverseMercator.identityEquals(d14, Math.sin(4.0 * d9) / 2.0)) : d9;
        double d15 = (d13 - d12) * 0.5;
        assert (TransverseMercator.identityEquals(d15, Math.cos(4.0 * d9) / 2.0)) : d9;
        double d16 = (0.75 - d12) * d10;
        assert (TransverseMercator.identityEquals(d16, Math.sin(6.0 * d9) / 4.0)) : d9;
        double d17 = (d13 - 0.75) * d11;
        assert (TransverseMercator.identityEquals(d17, Math.cos(6.0 * d9) / 4.0)) : d9;
        double d18 = d14 * d15;
        assert (TransverseMercator.identityEquals(d18, Math.sin(8.0 * d9) / 8.0)) : d9;
        double d19 = 0.125 - d14 * d14;
        assert (TransverseMercator.identityEquals(d19, Math.cos(8.0 * d9) / 8.0)) : d9;
        d12 = Math.sinh(2.0 * d7);
        d13 = Math.cosh(2.0 * d7);
        double d20 = d12 * d12;
        double d21 = d13 * d13;
        double d22 = (d21 + d20) * 0.5;
        assert (TransverseMercator.identityEquals(d22, Math.cosh(4.0 * d7) / 2.0)) : d7;
        double d23 = d13 * d12;
        assert (TransverseMercator.identityEquals(d23, Math.sinh(4.0 * d7) / 2.0)) : d7;
        double d24 = d13 * (d21 - 0.75);
        assert (TransverseMercator.identityEquals(d24, Math.cosh(6.0 * d7) / 4.0)) : d7;
        double d25 = d12 * (d20 + 0.75);
        assert (TransverseMercator.identityEquals(d25, Math.sinh(6.0 * d7) / 4.0)) : d7;
        double d26 = d23 * d23 + 0.125;
        assert (TransverseMercator.identityEquals(d26, Math.cosh(8.0 * d7) / 8.0)) : d7;
        double d27 = d23 * d22;
        assert (TransverseMercator.identityEquals(d27, Math.sinh(8.0 * d7) / 8.0)) : d7;
        if (dArray2 != null) {
            dArray2[n2] = this.cf8 * d19 * d27 + this.cf6 * d17 * d25 + this.cf4 * d15 * d23 + this.cf2 * d11 * d12 + d7;
            dArray2[n2 + 1] = this.cf8 * d18 * d26 + this.cf6 * d16 * d24 + this.cf4 * d14 * d22 + this.cf2 * d10 * d13 + d9;
        }
        if (!bl) {
            return null;
        }
        d20 = Math.cos(d);
        d21 = Math.cos(d2);
        double d28 = d6 * d6;
        double d29 = Math.sinh(d5);
        double d30 = Math.tanh(d5);
        double d31 = d28 - d3 * d3;
        double d32 = Math.sinh(d7);
        double d33 = Math.sqrt(1.0 - d30 * d30 * (d8 * d8));
        double d34 = 1.0 / d21 - this.eccentricitySquared * d21 / (1.0 - d4 * d4);
        double d35 = d20 * d6 / d31;
        double d36 = -d34 * d3 * d29 / d31;
        double d37 = d29 * d32 * d20 / (d31 * d33);
        double d38 = (d34 * d8 / d28 + d36 * d32 * d30) / d33;
        double d39 = d37 + 2.0 * (this.cf2 * (d37 * d11 * d13 + d35 * d12 * d10) + 3.0 * this.cf6 * (d37 * d17 * d24 + d35 * d25 * d16) + 2.0 * (this.cf4 * (d37 * d15 * d22 + d35 * d23 * d14) + 2.0 * this.cf8 * (d37 * d19 * d26 + d35 * d27 * d18)));
        double d40 = d38 + 2.0 * (this.cf2 * (d38 * d11 * d13 + d36 * d12 * d10) + 3.0 * this.cf6 * (d38 * d17 * d24 + d36 * d25 * d16) + 2.0 * (this.cf4 * (d38 * d15 * d22 + d36 * d23 * d14) + 2.0 * this.cf8 * (d38 * d19 * d26 + d36 * d27 * d18)));
        double d41 = d35 + 2.0 * (this.cf2 * (d35 * d13 * d11 - d37 * d10 * d12) + 3.0 * this.cf6 * (d35 * d24 * d17 - d37 * d16 * d25) + 2.0 * (this.cf4 * (d35 * d22 * d15 - d37 * d14 * d23) + 2.0 * this.cf8 * (d35 * d26 * d19 - d37 * d18 * d27)));
        double d42 = d36 + 2.0 * (this.cf2 * (d36 * d13 * d11 - d38 * d10 * d12) + 3.0 * this.cf6 * (d36 * d24 * d17 - d38 * d16 * d25) + 2.0 * (this.cf4 * (d36 * d22 * d15 - d38 * d14 * d23) + 2.0 * this.cf8 * (d36 * d26 * d19 - d38 * d18 * d27)));
        return new Matrix2(d41, d42, d39, d40);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.sin(2.0 * d2);
        double d4 = Math.cos(2.0 * d2);
        double d5 = Math.sinh(2.0 * d);
        double d6 = Math.cosh(2.0 * d);
        double d7 = d3 * d3;
        double d8 = d4 * d4;
        double d9 = d3 * d4;
        assert (TransverseMercator.identityEquals(d9, Math.sin(4.0 * d2) / 2.0)) : d2;
        double d10 = (d8 - d7) * 0.5;
        assert (TransverseMercator.identityEquals(d10, Math.cos(4.0 * d2) / 2.0)) : d2;
        double d11 = (0.75 - d7) * d3;
        assert (TransverseMercator.identityEquals(d11, Math.sin(6.0 * d2) / 4.0)) : d2;
        double d12 = (d8 - 0.75) * d4;
        assert (TransverseMercator.identityEquals(d12, Math.cos(6.0 * d2) / 4.0)) : d2;
        double d13 = d9 * d10;
        assert (TransverseMercator.identityEquals(d13, Math.sin(8.0 * d2) / 8.0)) : d2;
        double d14 = 0.125 - d9 * d9;
        assert (TransverseMercator.identityEquals(d14, Math.cos(8.0 * d2) / 8.0)) : d2;
        double d15 = d5 * d5;
        double d16 = d6 * d6;
        double d17 = (d16 + d15) * 0.5;
        assert (TransverseMercator.identityEquals(d17, Math.cosh(4.0 * d) / 2.0)) : d;
        double d18 = d6 * d5;
        assert (TransverseMercator.identityEquals(d18, Math.sinh(4.0 * d) / 2.0)) : d;
        double d19 = d6 * (d16 - 0.75);
        assert (TransverseMercator.identityEquals(d19, Math.cosh(6.0 * d) / 4.0)) : d;
        double d20 = d5 * (d15 + 0.75);
        assert (TransverseMercator.identityEquals(d20, Math.sinh(6.0 * d) / 4.0)) : d;
        double d21 = d18 * d18 + 0.125;
        assert (TransverseMercator.identityEquals(d21, Math.cosh(8.0 * d) / 8.0)) : d;
        double d22 = d18 * d17;
        assert (TransverseMercator.identityEquals(d22, Math.sinh(8.0 * d) / 8.0)) : d;
        d7 = d2 - (this.ci8 * d13 * d21 + this.ci6 * d11 * d19 + this.ci4 * d9 * d17 + this.ci2 * d3 * d6);
        d8 = d - (this.ci8 * d14 * d22 + this.ci6 * d12 * d20 + this.ci4 * d10 * d18 + this.ci2 * d4 * d5);
        d15 = Math.asin(Math.sin(d7) / Math.cosh(d8));
        d16 = MathFunctions.asinh(Math.tan(d15));
        double d23 = this.eccentricity * MathFunctions.atanh(this.eccentricity * Math.tanh(d16));
        double d24 = d16 + d23;
        for (int i = 0; i < 18; ++i) {
            double d25 = this.eccentricity * MathFunctions.atanh(this.eccentricity * Math.tanh(d24));
            d24 = d16 + d25;
            if (Math.abs(d25 - d23) <= 3.926676682852614E-10) {
                dArray2[n2] = Math.asin(Math.tanh(d8) / Math.cos(d15));
                dArray2[n2 + 1] = Math.atan(Math.sinh(d24));
                return;
            }
            d23 = d25;
        }
        throw new ProjectionException(Resources.format((short)46));
    }

    private static final class Spherical
    extends TransverseMercator {
        private static final long serialVersionUID = 8903592710452235162L;

        protected Spherical(TransverseMercator transverseMercator) {
            super(transverseMercator);
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.sin(d);
            double d4 = Math.cos(d);
            if (d4 < 0.0) {
                return TransverseMercator.outsideDomainOfValidity(dArray2, n2, bl);
            }
            double d5 = Math.sin(d2);
            double d6 = Math.cos(d2);
            double d7 = d5 / d6;
            double d8 = d6 * d3;
            if (dArray2 != null) {
                dArray2[n2] = MathFunctions.atanh(d8);
                dArray2[n2 + 1] = Math.atan2(d7, d4);
            }
            if (!bl) {
                return null;
            }
            double d9 = d8 * d8 - 1.0;
            double d10 = d4 * d4 + d7 * d7;
            return new Matrix2(-(d6 * d4) / d9, d5 * d3 / d9, d7 * d3 / d10, d4 / (d6 * d6 * d10));
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.sinh(d);
            double d4 = Math.cos(d2);
            dArray2[n2] = Math.atan2(d3, d4);
            dArray2[n2 + 1] = Math.copySign(Math.asin(Math.sqrt((1.0 - d4 * d4) / (1.0 + d3 * d3))), d2);
        }
    }
}

