/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.referencing.AnnotatedMatrix;
import org.apache.sis.internal.referencing.ExtentSelector;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Matrix;

@XmlType(name="GeodeticDatumType", propOrder={"primeMeridian", "ellipsoid"})
@XmlRootElement(name="GeodeticDatum")
public class DefaultGeodeticDatum
extends AbstractDatum
implements GeodeticDatum {
    private static final long serialVersionUID = 8832100095648302943L;
    public static final String BURSA_WOLF_KEY = "bursaWolf";
    private static final BursaWolfParameters[] EMPTY_ARRAY = new BursaWolfParameters[0];
    private Ellipsoid ellipsoid;
    private PrimeMeridian primeMeridian;
    private final BursaWolfParameters[] bursaWolf;

    public DefaultGeodeticDatum(Map<String, ?> map, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) {
        super(map);
        ArgumentChecks.ensureNonNull("ellipsoid", ellipsoid);
        ArgumentChecks.ensureNonNull("primeMeridian", primeMeridian);
        this.ellipsoid = ellipsoid;
        this.primeMeridian = primeMeridian;
        this.bursaWolf = CollectionsExt.nonEmpty(CollectionsExt.nonNullArraySet(BURSA_WOLF_KEY, map.get(BURSA_WOLF_KEY), EMPTY_ARRAY));
        if (this.bursaWolf != null) {
            for (int i = 0; i < this.bursaWolf.length; ++i) {
                BursaWolfParameters bursaWolfParameters = this.bursaWolf[i];
                ArgumentChecks.ensureNonNullElement(BURSA_WOLF_KEY, i, bursaWolfParameters);
                bursaWolfParameters = bursaWolfParameters.clone();
                bursaWolfParameters.verify(primeMeridian);
                this.bursaWolf[i] = bursaWolfParameters;
            }
        }
    }

    protected DefaultGeodeticDatum(GeodeticDatum geodeticDatum) {
        super(geodeticDatum);
        this.ellipsoid = geodeticDatum.getEllipsoid();
        this.primeMeridian = geodeticDatum.getPrimeMeridian();
        this.bursaWolf = geodeticDatum instanceof DefaultGeodeticDatum ? ((DefaultGeodeticDatum)geodeticDatum).bursaWolf : null;
    }

    public static DefaultGeodeticDatum castOrCopy(GeodeticDatum geodeticDatum) {
        return geodeticDatum == null || geodeticDatum instanceof DefaultGeodeticDatum ? (DefaultGeodeticDatum)geodeticDatum : new DefaultGeodeticDatum(geodeticDatum);
    }

    public Class<? extends GeodeticDatum> getInterface() {
        return GeodeticDatum.class;
    }

    @Override
    @XmlElement(name="ellipsoid", required=true)
    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    @Override
    @XmlElement(name="primeMeridian", required=true)
    public PrimeMeridian getPrimeMeridian() {
        return this.primeMeridian;
    }

    public BursaWolfParameters[] getBursaWolfParameters() {
        if (this.bursaWolf == null) {
            return EMPTY_ARRAY;
        }
        BursaWolfParameters[] bursaWolfParametersArray = (BursaWolfParameters[])this.bursaWolf.clone();
        for (int i = 0; i < bursaWolfParametersArray.length; ++i) {
            bursaWolfParametersArray[i] = bursaWolfParametersArray[i].clone();
        }
        return bursaWolfParametersArray;
    }

    /*
     * Unable to fully structure code
     */
    public Matrix getPositionVectorTransformation(GeodeticDatum var1_1, Extent var2_2) {
        ArgumentChecks.ensureNonNull("targetDatum", var1_1);
        var3_3 = new ExtentSelector<BursaWolfParameters>(var2_2);
        var4_4 = this.select(var1_1, var3_3);
        if (var4_4 != null) {
            return DefaultGeodeticDatum.createTransformation(var4_4, var2_2);
        }
        if (var1_1 instanceof DefaultGeodeticDatum) {
            var4_4 = ((DefaultGeodeticDatum)var1_1).select(this, var3_3);
            if (var4_4 != null) {
                try {
                    return Matrices.inverse(DefaultGeodeticDatum.createTransformation(var4_4, var2_2));
                }
                catch (NoninvertibleMatrixException var5_5) {
                    Logging.unexpectedException(Logging.getLogger("org.apache.sis.referencing.operation"), DefaultGeodeticDatum.class, "getPositionVectorTransformation", var5_5);
                }
            }
            if (this.bursaWolf != null) {
                var5_6 = var3_3.getAreaOfInterest();
                var6_7 = var3_3.getTimeOfInterest();
                var7_8 = true;
                while (true) {
                    for (BursaWolfParameters var11_12 : this.bursaWolf) {
                        if (!var3_3.setExtentOfInterest(var11_12.getDomainOfValidity(), var5_6, var6_7) || (var4_4 = ((DefaultGeodeticDatum)var1_1).select(var11_12.getTargetDatum(), var3_3)) == null) continue;
                        var12_13 = DefaultGeodeticDatum.createTransformation(var11_12, var2_2);
                        var13_14 = DefaultGeodeticDatum.createTransformation(var4_4, var2_2);
                        try {
                            var14_16 = MatrixSIS.castOrCopy(var13_14).inverse().multiply(var12_13);
                            return AnnotatedMatrix.indirect(var14_16, var7_8);
                        }
                        catch (NoninvertibleMatrixException var14_15) {
                            Logging.unexpectedException(Logging.getLogger("org.apache.sis.referencing.operation"), DefaultGeodeticDatum.class, "getPositionVectorTransformation", var14_15);
                        }
                    }
                    var7_8 = false;
                    v0 = var5_6;
                    var5_6 = null;
                    if (v0 != null) ** continue;
                    v1 = var6_7;
                    var6_7 = null;
                    if (v1 == null) break;
                }
            }
        }
        return null;
    }

    private static Matrix createTransformation(BursaWolfParameters bursaWolfParameters, Extent extent) {
        return bursaWolfParameters.getPositionVectorTransformation(bursaWolfParameters.getClass() != BursaWolfParameters.class ? Extents.getDate(extent, 0.5) : null);
    }

    private BursaWolfParameters select(GeodeticDatum geodeticDatum, ExtentSelector<BursaWolfParameters> extentSelector) {
        if (this.bursaWolf == null) {
            return null;
        }
        for (BursaWolfParameters bursaWolfParameters : this.bursaWolf) {
            if (!Utilities.deepEquals(geodeticDatum, bursaWolfParameters.getTargetDatum(), ComparisonMode.IGNORE_METADATA)) continue;
            extentSelector.evaluate(bursaWolfParameters.getDomainOfValidity(), bursaWolfParameters);
        }
        return extentSelector.best();
    }

    @Override
    public boolean isHeuristicMatchForName(String string) {
        final String string2 = this.primeMeridian.getName().getCode();
        return NameToIdentifier.isHeuristicMatchForName(super.getName(), super.getAlias(), string, new AbstractDatum.Simplifier(){

            @Override
            protected CharSequence apply(CharSequence charSequence) {
                int n;
                int n2 = CharSequences.indexOf(charSequence = super.apply(charSequence), string2, 0, charSequence.length()) - 1;
                if (n2 >= 0 && charSequence.charAt(n2) == '(' && (n = n2 + string2.length() + 1) < charSequence.length() && charSequence.charAt(n) == ')') {
                    int n3;
                    for (n2 = CharSequences.skipTrailingWhitespaces(charSequence, 0, n2); n2 > 0; n2 -= Character.charCount(n3)) {
                        n3 = Character.codePointBefore(charSequence, n2);
                        if (!Character.isLetterOrDigit(n3)) continue;
                        charSequence = new StringBuilder(charSequence).delete(n2, n + 1).toString();
                        break;
                    }
                }
                return charSequence;
            }
        });
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                DefaultGeodeticDatum defaultGeodeticDatum = (DefaultGeodeticDatum)object;
                return Objects.equals(this.ellipsoid, defaultGeodeticDatum.ellipsoid) && Objects.equals(this.primeMeridian, defaultGeodeticDatum.primeMeridian) && Arrays.equals(this.bursaWolf, defaultGeodeticDatum.bursaWolf);
            }
        }
        GeodeticDatum geodeticDatum = (GeodeticDatum)object;
        return Utilities.deepEquals(this.getEllipsoid(), geodeticDatum.getEllipsoid(), comparisonMode) && Utilities.deepEquals(this.getPrimeMeridian(), geodeticDatum.getPrimeMeridian(), comparisonMode);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hashCode(this.ellipsoid) + (long)(31 * Objects.hashCode(this.primeMeridian));
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean bl;
        super.formatTo(formatter);
        formatter.newLine();
        formatter.append(WKTUtilities.toFormattable(this.getEllipsoid()));
        boolean bl2 = bl = formatter.getConvention().majorVersion() == 1;
        if (bl && this.bursaWolf != null) {
            for (BursaWolfParameters bursaWolfParameters : this.bursaWolf) {
                if (!bursaWolfParameters.isToWGS84()) continue;
                formatter.newLine();
                formatter.append(bursaWolfParameters);
                break;
            }
        }
        formatter.newLine();
        if (!bl && !(formatter.getEnclosingElement(1) instanceof GeodeticCRS)) {
            return formatter.shortOrLong("Datum", "GeodeticDatum");
        }
        return "Datum";
    }

    private DefaultGeodeticDatum() {
        this.bursaWolf = null;
    }

    private void setEllipsoid(Ellipsoid ellipsoid) {
        if (this.ellipsoid == null) {
            this.ellipsoid = ellipsoid;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultGeodeticDatum.class, "setEllipsoid", "ellipsoid");
        }
    }

    private void setPrimeMeridian(PrimeMeridian primeMeridian) {
        if (this.primeMeridian == null) {
            this.primeMeridian = primeMeridian;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultGeodeticDatum.class, "setPrimeMeridian", "primeMeridian");
        }
    }
}

