/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.util.AbstractMap;
import org.apache.sis.util.Deprecable;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.GenericName;

final class Properties
extends AbstractMap<String, Object>
implements Serializable {
    private static final long serialVersionUID = 836068852472172370L;
    private static final String[] KEYS = new String[]{"name", "identifiers", "alias", "remarks", "scope", "domainOfValidity", "operationVersion", "coordinateOperationAccuracy", "formula", "parameters", "deprecated"};
    private static final Map<String, Integer> INDICES = new HashMap<String, Integer>(16);
    final IdentifiedObject object;
    final int excludeMask;

    Properties(IdentifiedObject identifiedObject, String[] stringArray) {
        this.object = identifiedObject;
        int n = 0;
        for (String string : stringArray) {
            Integer n2 = INDICES.get(string);
            if (n2 == null) continue;
            n |= 1 << n2;
        }
        this.excludeMask = n;
    }

    final Object getAt(int n) {
        if ((this.excludeMask & 1 << n) == 0) {
            switch (n) {
                case 0: {
                    return this.object.getName();
                }
                case 1: {
                    int n2;
                    Set<ReferenceIdentifier> set = this.object.getIdentifiers();
                    if (set == null || (n2 = set.size()) == 0) break;
                    return set.toArray(new ReferenceIdentifier[n2]);
                }
                case 2: {
                    int n3;
                    Collection<GenericName> collection = this.object.getAlias();
                    if (collection == null || (n3 = collection.size()) == 0) break;
                    return collection.toArray(new GenericName[n3]);
                }
                case 3: {
                    return this.object.getRemarks();
                }
                case 4: {
                    if (this.object instanceof ReferenceSystem) {
                        return ((ReferenceSystem)this.object).getScope();
                    }
                    if (this.object instanceof Datum) {
                        return ((Datum)this.object).getScope();
                    }
                    if (!(this.object instanceof CoordinateOperation)) break;
                    return ((CoordinateOperation)this.object).getScope();
                }
                case 5: {
                    if (this.object instanceof ReferenceSystem) {
                        return ((ReferenceSystem)this.object).getDomainOfValidity();
                    }
                    if (this.object instanceof Datum) {
                        return ((Datum)this.object).getDomainOfValidity();
                    }
                    if (!(this.object instanceof CoordinateOperation)) break;
                    return ((CoordinateOperation)this.object).getDomainOfValidity();
                }
                case 6: {
                    if (!(this.object instanceof CoordinateOperation)) break;
                    return ((CoordinateOperation)this.object).getOperationVersion();
                }
                case 7: {
                    int n4;
                    Collection<PositionalAccuracy> collection;
                    if (!(this.object instanceof CoordinateOperation) || (collection = ((CoordinateOperation)this.object).getCoordinateOperationAccuracy()) == null || (n4 = collection.size()) == 0) break;
                    return collection.toArray(new PositionalAccuracy[n4]);
                }
                case 8: {
                    if (!(this.object instanceof OperationMethod)) break;
                    return ((OperationMethod)this.object).getFormula();
                }
                case 9: {
                    if (!(this.object instanceof SingleOperation)) break;
                    return ((SingleOperation)this.object).getParameterValues();
                }
                case 10: {
                    if (!(this.object instanceof Deprecable)) break;
                    return ((Deprecable)((Object)this.object)).isDeprecated();
                }
                default: {
                    throw new AssertionError(n);
                }
            }
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < KEYS.length; ++i) {
            if (this.getAt(i) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        int n = 0;
        for (int i = 0; i < KEYS.length; ++i) {
            if (this.getAt(i) == null) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Object get(Object object) {
        Integer n = INDICES.get(object);
        return n != null ? this.getAt(n) : null;
    }

    @Override
    protected AbstractMap.EntryIterator<String, Object> entryIterator() {
        return new AbstractMap.EntryIterator<String, Object>(){
            private int nextIndex;
            private Object value;

            @Override
            protected boolean next() {
                while (this.nextIndex < KEYS.length) {
                    this.value = Properties.this.getAt(this.nextIndex++);
                    if (this.value == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            protected String getKey() {
                return KEYS[this.nextIndex - 1];
            }

            @Override
            protected Object getValue() {
                return this.value;
            }
        };
    }

    static {
        for (int i = 0; i < KEYS.length; ++i) {
            if (INDICES.put(KEYS[i], i) != null) {
                throw new AssertionError(i);
            }
        }
    }
}

