/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.metadata.Identifiers;
import org.apache.sis.internal.metadata.NameMeaning;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.AuthorityFactories;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.Properties;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;

public final class IdentifiedObjects
extends Static {
    private IdentifiedObjects() {
    }

    public static Map<String, ?> getProperties(IdentifiedObject identifiedObject, String ... stringArray) {
        ArgumentChecks.ensureNonNull("object", identifiedObject);
        ArgumentChecks.ensureNonNull("excludes", stringArray);
        return new Properties(identifiedObject, stringArray);
    }

    public static Set<String> getNames(IdentifiedObject identifiedObject, Citation citation) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(8);
        IdentifiedObjects.getName(identifiedObject, citation, linkedHashSet);
        return linkedHashSet;
    }

    public static String getName(IdentifiedObject identifiedObject, Citation citation) {
        return IdentifiedObjects.getName(identifiedObject, citation, null);
    }

    private static String getName(IdentifiedObject identifiedObject, Citation citation, Collection<String> collection) {
        if (identifiedObject != null) {
            Object object;
            Identifier identifier = identifiedObject.getName();
            if (identifier != null && (citation == null || Citations.identifierMatches(citation, identifier.getAuthority())) && (object = identifier.getCode()) != null) {
                if (collection == null) {
                    return object;
                }
                collection.add((String)object);
            }
            for (GenericName genericName : CollectionsExt.nonNull(identifiedObject.getAlias())) {
                String string;
                if (genericName == null) continue;
                if (genericName instanceof Identifier) {
                    identifier = (Identifier)((Object)genericName);
                    if (citation != null && !Citations.identifierMatches(citation, identifier.getAuthority())) continue;
                    string = identifier.getCode();
                } else {
                    GenericName genericName2;
                    NameSpace nameSpace;
                    if (citation != null && ((nameSpace = genericName.scope()) == null || (genericName2 = nameSpace.name()) == null || !Citations.identifierMatches(citation, genericName2.toString()))) continue;
                    string = genericName.toString();
                }
                if (string == null) continue;
                if (collection == null) {
                    return string;
                }
                collection.add(string);
            }
        }
        return null;
    }

    public static Identifier getIdentifier(IdentifiedObject identifiedObject, Citation citation) {
        if (identifiedObject != null) {
            for (Identifier identifier : CollectionsExt.nonNull(identifiedObject.getIdentifiers())) {
                if (identifier == null || citation != null && !Citations.identifierMatches(citation, identifier.getAuthority())) continue;
                return identifier;
            }
        }
        return null;
    }

    public static String getIdentifierOrName(IdentifiedObject identifiedObject) {
        if (identifiedObject != null) {
            for (Identifier identifier : CollectionsExt.nonNull(identifiedObject.getIdentifiers())) {
                String string = IdentifiedObjects.toString(identifier);
                if (string == null) continue;
                return string;
            }
            String string = IdentifiedObjects.toString(identifiedObject.getName());
            if (string != null) {
                return string;
            }
        }
        return null;
    }

    public static String getSimpleNameOrIdentifier(IdentifiedObject identifiedObject) {
        if (identifiedObject != null) {
            String string;
            Iterator<ReferenceIdentifier> iterator;
            ReferenceIdentifier referenceIdentifier = identifiedObject.getName();
            if (referenceIdentifier != null && CharSequences.isUnicodeIdentifier((CharSequence)((Object)(iterator = referenceIdentifier.getCode())))) {
                return iterator;
            }
            for (GenericName genericName : CollectionsExt.nonNull(identifiedObject.getAlias())) {
                LocalName localName;
                if (genericName == null || (localName = genericName.tip()) == null || !CharSequences.isUnicodeIdentifier(string = localName.toString())) continue;
                return string;
            }
            for (Identifier identifier : CollectionsExt.nonNull(identifiedObject.getIdentifiers())) {
                if (identifier == null || !CharSequences.isUnicodeIdentifier(string = identifier.getCode())) continue;
                return string;
            }
        }
        return null;
    }

    public static String getDisplayName(IdentifiedObject identifiedObject, Locale locale) {
        String string;
        block4: {
            Identifier identifier;
            if (identifiedObject == null) {
                return null;
            }
            string = IdentifiedObjects.toString(identifiedObject.getName(), locale);
            for (GenericName object2 : CollectionsExt.nonNull(identifiedObject.getAlias())) {
                String string2 = IdentifiedObjects.toString(object2, locale);
                if (string2 == null) continue;
                if (string == null || CharSequences.isAcronymForWords(string, string2)) {
                    return string2;
                }
                String string3 = object2.toString();
                if (string2.equals(string3) || !CharSequences.isAcronymForWords(string, string3)) continue;
                return string2;
            }
            if (string != null) break block4;
            Iterator<Object> iterator = CollectionsExt.nonNull(identifiedObject.getIdentifiers()).iterator();
            while (iterator.hasNext() && (string = IdentifiedObjects.toString(identifier = (Identifier)iterator.next(), locale)) == null) {
            }
        }
        return string;
    }

    public static String lookupURN(IdentifiedObject identifiedObject, Citation citation) throws FactoryException {
        List<IdentifiedObject> list;
        IdentifiedObjectFinder identifiedObjectFinder;
        if (identifiedObject == null) {
            return null;
        }
        try {
            identifiedObjectFinder = IdentifiedObjects.newFinder(Citations.toCodeSpace(citation));
        }
        catch (NoSuchAuthorityFactoryException noSuchAuthorityFactoryException) {
            IdentifiedObjects.warning("lookupURN", noSuchAuthorityFactoryException);
            identifiedObjectFinder = IdentifiedObjects.newFinder(null);
        }
        String string = IdentifiedObjects.lookupURN(identifiedObject, citation, identifiedObjectFinder);
        if (string != null) {
            return string;
        }
        if (identifiedObject instanceof CompoundCRS) {
            list = CRS.getSingleComponents((CompoundCRS)identifiedObject);
        } else if (identifiedObject instanceof ConcatenatedOperation) {
            list = ((ConcatenatedOperation)identifiedObject).getOperations();
        } else {
            return null;
        }
        StringBuilder stringBuilder = null;
        for (IdentifiedObject identifiedObject2 : list) {
            string = IdentifiedObjects.lookupURN(identifiedObject2, citation, identifiedObjectFinder);
            if (string == null) {
                return null;
            }
            assert (string.startsWith("urn:ogc:def")) : string;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(40).append("urn:ogc:def").append(':').append(NameMeaning.toObjectType(identifiedObject.getClass()));
            }
            stringBuilder.append(',').append(string, "urn:ogc:def".length() + 1, string.length());
        }
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    private static String lookupURN(IdentifiedObject identifiedObject, Citation citation, IdentifiedObjectFinder identifiedObjectFinder) throws FactoryException {
        String string = null;
        if (identifiedObject != null) {
            for (IdentifiedObject identifiedObject2 : identifiedObjectFinder.find(identifiedObject)) {
                String string2 = IdentifiedObjects.toURN(identifiedObject2.getClass(), IdentifiedObjects.getIdentifier(identifiedObject2, citation));
                if (string2 == null && citation == null) {
                    for (Identifier identifier : identifiedObject2.getIdentifiers()) {
                        string2 = IdentifiedObjects.toURN(identifiedObject2.getClass(), identifier);
                        if (string2 == null) continue;
                        break;
                    }
                }
                if (string2 == null) continue;
                if (string != null && !string.equals(string2)) {
                    return null;
                }
                string = string2;
            }
        }
        return string;
    }

    public static Integer lookupEPSG(IdentifiedObject identifiedObject) throws FactoryException {
        Integer n = null;
        if (identifiedObject != null) {
            for (IdentifiedObject identifiedObject2 : IdentifiedObjects.newFinder("EPSG").find(identifiedObject)) {
                Identifier identifier = IdentifiedObjects.getIdentifier(identifiedObject2, Citations.EPSG);
                if (identifier == null) continue;
                try {
                    Integer n2 = n;
                    n = Integer.valueOf(identifier.getCode());
                    if (n2 == null || n2.equals(n)) continue;
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    IdentifiedObjects.warning("lookupEPSG", numberFormatException);
                }
            }
        }
        return n;
    }

    private static void warning(String string, Exception exception) {
        Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing"), IdentifiedObjects.class, string, exception);
    }

    public static IdentifiedObjectFinder newFinder(String string) throws NoSuchAuthorityFactoryException, FactoryException {
        GeodeticAuthorityFactory geodeticAuthorityFactory = string == null ? AuthorityFactories.ALL : AuthorityFactories.ALL.getAuthorityFactory(GeodeticAuthorityFactory.class, string, null);
        return ((GeodeticAuthorityFactory)geodeticAuthorityFactory).newIdentifiedObjectFinder();
    }

    public static boolean isHeuristicMatchForName(IdentifiedObject identifiedObject, String string) {
        ArgumentChecks.ensureNonNull("name", string);
        if (identifiedObject == null) {
            return false;
        }
        if (identifiedObject instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)identifiedObject).isHeuristicMatchForName(string);
        }
        return NameToIdentifier.isHeuristicMatchForName(identifiedObject.getName(), identifiedObject.getAlias(), string, NameToIdentifier.Simplifier.DEFAULT);
    }

    public static String toURN(Class<?> clazz, Identifier identifier) {
        ArgumentChecks.ensureNonNull("type", clazz);
        if (identifier == null) {
            return null;
        }
        String string = null;
        if (identifier instanceof ReferenceIdentifier) {
            string = ((ReferenceIdentifier)identifier).getCodeSpace();
        }
        if (string == null || string.isEmpty()) {
            string = Identifiers.getIdentifier(identifier.getAuthority(), true);
        }
        return NameMeaning.toURN(clazz, string, identifier instanceof ReferenceIdentifier ? ((ReferenceIdentifier)identifier).getVersion() : null, identifier.getCode());
    }

    public static String toString(Identifier identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier instanceof GenericName) {
            return identifier.toString();
        }
        String string = identifier.getCode();
        String string2 = null;
        if (identifier instanceof ReferenceIdentifier) {
            string2 = ((ReferenceIdentifier)identifier).getCodeSpace();
        }
        if (string2 == null || string2.isEmpty()) {
            string2 = Citations.toCodeSpace(identifier.getAuthority());
        }
        if (string2 != null) {
            return string2 + ':' + string;
        }
        return string;
    }

    private static String toString(Identifier identifier, Locale locale) {
        String string;
        if (identifier == null) {
            return null;
        }
        if (identifier instanceof GenericName && (string = IdentifiedObjects.toString(((GenericName)((Object)identifier)).tip(), locale)) != null) {
            return string;
        }
        return Strings.trimOrNull(identifier.getCode());
    }

    private static String toString(GenericName genericName, Locale locale) {
        String string;
        InternationalString internationalString;
        if (genericName == null) {
            return null;
        }
        if (locale != null && (internationalString = genericName.toInternationalString()) != null && (string = Strings.trimOrNull(internationalString.toString(locale))) != null) {
            return string;
        }
        return Strings.trimOrNull(genericName.toString());
    }
}

