/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultIndividual;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibility;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.util.InternationalString;

@XmlType(name="CI_ResponsibleParty_Type", namespace="http://www.isotc211.org/2005/gmd", propOrder={"individualName", "organisationName", "positionName", "contactInfo", "role"})
@XmlRootElement(name="CI_ResponsibleParty", namespace="http://www.isotc211.org/2005/gmd")
public class DefaultResponsibleParty
extends DefaultResponsibility
implements ResponsibleParty {
    private static final long serialVersionUID = -1022635486627088812L;

    public DefaultResponsibleParty() {
    }

    public DefaultResponsibleParty(Role role) {
        super(role, null, null);
    }

    public DefaultResponsibleParty(DefaultResponsibility defaultResponsibility) {
        super(defaultResponsibility);
    }

    public DefaultResponsibleParty(ResponsibleParty responsibleParty) {
        super(responsibleParty);
        if (responsibleParty != null && !(responsibleParty instanceof DefaultResponsibility)) {
            this.setIndividualName(responsibleParty.getIndividualName());
            this.setOrganisationName(responsibleParty.getOrganisationName());
        }
    }

    public static DefaultResponsibleParty castOrCopy(ResponsibleParty responsibleParty) {
        if (responsibleParty == null || responsibleParty instanceof DefaultResponsibleParty) {
            return (DefaultResponsibleParty)responsibleParty;
        }
        return new DefaultResponsibleParty(responsibleParty);
    }

    private InternationalString getIndividual(boolean bl) {
        InternationalString internationalString;
        block1: {
            Collection<AbstractParty> collection = this.getParties();
            internationalString = DefaultResponsibleParty.getName(collection, DefaultIndividual.class, bl);
            if (internationalString != null || collection == null) break block1;
            for (AbstractParty abstractParty : collection) {
                if (abstractParty instanceof DefaultOrganisation && (internationalString = DefaultResponsibleParty.getName(((DefaultOrganisation)abstractParty).getIndividual(), DefaultIndividual.class, bl)) != null) break;
            }
        }
        return internationalString;
    }

    private static InternationalString getName(Collection<? extends AbstractParty> collection, Class<? extends AbstractParty> clazz, boolean bl) {
        InternationalString internationalString = null;
        if (collection != null) {
            for (AbstractParty abstractParty : collection) {
                if (!clazz.isInstance(abstractParty)) continue;
                if (internationalString != null) {
                    LegacyPropertyAdapter.warnIgnoredExtraneous(clazz, DefaultResponsibleParty.class, bl ? "getPositionName" : (clazz == DefaultIndividual.class ? "getIndividualName" : "getOrganisationName"));
                    break;
                }
                internationalString = bl ? ((DefaultIndividual)abstractParty).getPositionName() : abstractParty.getName();
            }
        }
        return internationalString;
    }

    private void setName(Class<? extends AbstractParty> clazz, boolean bl, InternationalString internationalString, Function<InternationalString, AbstractParty> function) {
        Object object;
        Collection<AbstractParty> collection = this.getParties();
        this.checkWritePermission(MetadataUtilities.valueIfDefined(collection));
        if (collection != null) {
            object = collection.iterator();
            while (object.hasNext()) {
                AbstractParty abstractParty = object.next();
                if (!clazz.isInstance(abstractParty)) continue;
                if (bl) {
                    ((DefaultIndividual)abstractParty).setPositionName(internationalString);
                } else {
                    abstractParty.setName(internationalString);
                }
                if (abstractParty.isEmpty()) {
                    object.remove();
                }
                return;
            }
        }
        if (internationalString != null) {
            object = function.apply(internationalString);
            if (collection != null) {
                collection.add((AbstractParty)object);
            } else {
                this.setParties(Collections.singletonList(object));
            }
        }
    }

    @Override
    @Deprecated
    @Dependencies(value={"getParties"})
    @XmlElement(name="individualName")
    public String getIndividualName() {
        InternationalString internationalString = this.getIndividual(false);
        return internationalString != null ? internationalString.toString() : null;
    }

    @Deprecated
    public void setIndividualName(String string) {
        this.setName(DefaultIndividual.class, false, Types.toInternationalString(string), DefaultResponsibleParty::individual);
    }

    private static AbstractParty individual(InternationalString internationalString) {
        return new DefaultIndividual(internationalString, null, null);
    }

    @Override
    @Deprecated
    @Dependencies(value={"getParties"})
    @XmlElement(name="organisationName")
    public InternationalString getOrganisationName() {
        return DefaultResponsibleParty.getName(this.getParties(), DefaultOrganisation.class, false);
    }

    @Deprecated
    public void setOrganisationName(InternationalString internationalString) {
        this.setName(DefaultOrganisation.class, false, internationalString, DefaultResponsibleParty::organisation);
    }

    private static AbstractParty organisation(InternationalString internationalString) {
        return new DefaultOrganisation(internationalString, null, null, null);
    }

    @Override
    @Deprecated
    @Dependencies(value={"getParties"})
    @XmlElement(name="positionName")
    public InternationalString getPositionName() {
        return this.getIndividual(true);
    }

    @Deprecated
    public void setPositionName(InternationalString internationalString) {
        this.setName(DefaultIndividual.class, true, internationalString, DefaultResponsibleParty::position);
    }

    private static AbstractParty position(InternationalString internationalString) {
        return new DefaultIndividual(null, internationalString, null);
    }

    @Override
    @Deprecated
    @Dependencies(value={"getParties"})
    @XmlElement(name="contactInfo")
    public Contact getContactInfo() {
        Collection<AbstractParty> collection = this.getParties();
        if (collection != null) {
            for (AbstractParty abstractParty : collection) {
                Collection<Contact> collection2 = abstractParty.getContactInfo();
                if (collection2 == null) continue;
                for (Contact contact : collection2) {
                    if (contact == null) continue;
                    return contact;
                }
            }
        }
        return null;
    }

    @Deprecated
    public void setContactInfo(Contact contact) {
        Object object;
        Collection<AbstractParty> collection = this.getParties();
        this.checkWritePermission(MetadataUtilities.valueIfDefined(collection));
        if (collection != null && (object = collection.iterator()).hasNext()) {
            AbstractParty abstractParty = object.next();
            abstractParty.setContactInfo(contact != null ? Collections.singleton(contact) : null);
            if (abstractParty.isEmpty()) {
                object.remove();
            }
            return;
        }
        if (contact != null) {
            object = new DefaultIndividual(null, null, contact);
            if (collection != null) {
                collection.add((AbstractParty)object);
            } else {
                this.setParties(Collections.singletonList(object));
            }
        }
    }

    @Override
    @XmlElement(name="role", required=true)
    public Role getRole() {
        return super.getRole();
    }

    @Override
    public void setRole(Role role) {
        super.setRole(role);
    }
}

