/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamSource;
import org.apache.sis.internal.referencing.DefinitionVerifier;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.xml.StoreProvider;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.XML;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

final class Store
extends URIDataStore
implements Filter {
    private StreamSource source;
    private Object object;
    private Metadata metadata;

    public Store(StoreProvider storeProvider, StorageConnector storageConnector) throws DataStoreException {
        super(storeProvider, storageConnector);
        Closeable closeable;
        InputStream inputStream = storageConnector.getStorageAs(InputStream.class);
        if (inputStream != null) {
            this.source = new StreamSource(inputStream);
        } else {
            closeable = storageConnector.getStorageAs(Reader.class);
            if (closeable != null) {
                this.source = new StreamSource((Reader)closeable);
            }
        }
        closeable = Store.input(this.source);
        storageConnector.closeAllExcept(closeable);
        if (closeable == null) {
            throw new UnsupportedStorageException(super.getLocale(), "XML", storageConnector.getStorage(), storageConnector.getOption(OptionKey.OPEN_OPTIONS));
        }
    }

    private static Closeable input(StreamSource streamSource) {
        Closeable closeable = null;
        if (streamSource != null && (closeable = streamSource.getInputStream()) == null) {
            closeable = streamSource.getReader();
        }
        return closeable;
    }

    private Map<String, ?> properties() {
        if (this.listeners.hasListeners(WarningEvent.class)) {
            return Collections.singletonMap("org.apache.sis.xml.warningFilter", this);
        }
        return null;
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        logRecord.setLoggerName("org.apache.sis.xml");
        this.listeners.warning(logRecord);
        return false;
    }

    private void unmarshal() throws DataStoreException {
        StreamSource streamSource = this.source;
        Closeable closeable = Store.input(streamSource);
        this.source = null;
        if (closeable != null) {
            try {
                try {
                    this.object = XML.unmarshal(streamSource, this.properties());
                }
                finally {
                    closeable.close();
                }
            }
            catch (IOException | JAXBException exception) {
                throw new DataStoreException(Errors.format((short)12, this.getDisplayName()), exception);
            }
        }
        if (this.object instanceof CoordinateReferenceSystem) {
            try {
                DefinitionVerifier definitionVerifier = DefinitionVerifier.withAuthority((CoordinateReferenceSystem)this.object, null, false, this.getLocale());
                if (definitionVerifier != null) {
                    this.log(definitionVerifier.warning(false));
                }
            }
            catch (FactoryException factoryException) {
                this.listeners.warning(factoryException);
            }
        }
    }

    private void log(LogRecord logRecord) {
        if (logRecord != null) {
            logRecord.setSourceClassName(Store.class.getName());
            logRecord.setSourceMethodName("getMetadata");
            logRecord.setLoggerName("org.apache.sis.xml");
            this.listeners.warning(logRecord);
        }
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            this.unmarshal();
            if (this.object instanceof Metadata) {
                this.metadata = (Metadata)this.object;
            } else if (this.object instanceof ReferenceSystem) {
                MetadataBuilder metadataBuilder = new MetadataBuilder();
                metadataBuilder.addReferenceSystem((ReferenceSystem)this.object);
                metadataBuilder.addTitle(this.getDisplayName());
                this.metadata = metadataBuilder.build(true);
            }
        }
        return this.metadata;
    }

    @Override
    public synchronized void close() throws DataStoreException {
        this.object = null;
        Closeable closeable = Store.input(this.source);
        this.source = null;
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                throw new DataStoreException(iOException);
            }
        }
    }
}

