/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.Molodensky;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.transform.WraparoundTransform;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Wraparound
extends AbstractProvider {
    private static final long serialVersionUID = -7464255385789611569L;
    public static final ParameterDescriptor<Integer> DIMENSION;
    public static final ParameterDescriptor<Integer> WRAPAROUND_DIMENSION;
    public static final ParameterDescriptor<Double> PERIOD;
    public static final ParameterDescriptorGroup PARAMETERS;

    public Wraparound() {
        super(2, 2, PARAMETERS);
    }

    public final Class<Conversion> getOperationType() {
        return Conversion.class;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws FactoryException {
        Parameters parameters = Parameters.castOrWrap(parameterValueGroup);
        return WraparoundTransform.create(parameters.intValue(DIMENSION), parameters.intValue(WRAPAROUND_DIMENSION), parameters.doubleValue(PERIOD), Double.NaN, 0.0);
    }

    static {
        ParameterBuilder parameterBuilder = (ParameterBuilder)Wraparound.builder().setCodeSpace(Citations.SIS, "SIS");
        DIMENSION = ((ParameterBuilder)parameterBuilder.addName(Molodensky.DIMENSION.getName())).createBounded(Integer.class, Integer.valueOf(1), null, null);
        WRAPAROUND_DIMENSION = ((ParameterBuilder)parameterBuilder.addName("wraparound_dim")).createBounded(Integer.class, Integer.valueOf(0), null, null);
        PERIOD = ((ParameterBuilder)parameterBuilder.addName("period")).createStrictlyPositive(Double.NaN, null);
        PARAMETERS = ((ParameterBuilder)parameterBuilder.addName("Wraparound")).createGroup(DIMENSION, WRAPAROUND_DIMENSION, PERIOD);
    }
}

