/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractMercator;
import org.apache.sis.internal.referencing.provider.AlbersEqualArea;
import org.apache.sis.internal.referencing.provider.Equirectangular;
import org.apache.sis.internal.referencing.provider.Mercator1SP;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

@XmlTransient
public class ObliqueMercator
extends AbstractMercator {
    private static final long serialVersionUID = 9100327311220773612L;
    public static final String IDENTIFIER_A = "9812";
    public static final ParameterDescriptor<Double> LATITUDE_OF_CENTRE;
    public static final ParameterDescriptor<Double> LONGITUDE_OF_CENTRE;
    public static final ParameterDescriptor<Double> AZIMUTH;
    public static final ParameterDescriptor<Double> RECTIFIED_GRID_ANGLE;
    public static final ParameterDescriptor<Double> SCALE_FACTOR;
    static final ParameterDescriptorGroup PARAMETERS_A;

    public ObliqueMercator() {
        super(PARAMETERS_A);
    }

    ObliqueMercator(ParameterDescriptorGroup parameterDescriptorGroup) {
        super(parameterDescriptorGroup);
    }

    @Override
    protected final NormalizedProjection createProjection(Parameters parameters) {
        return new org.apache.sis.referencing.operation.projection.ObliqueMercator(this, parameters);
    }

    static {
        ParameterBuilder parameterBuilder = ObliqueMercator.builder();
        LATITUDE_OF_CENTRE = ObliqueMercator.createLatitude((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8811")).addName("Latitude of projection centre")).addNameAndIdentifier(Citations.OGC, AlbersEqualArea.LATITUDE_OF_FALSE_ORIGIN)).addName(Citations.ESRI, "Latitude_Of_Center")).addNameAndIdentifier(Citations.GEOTIFF, Equirectangular.LATITUDE_OF_ORIGIN)).addNameAndIdentifier(Citations.PROJ4, Equirectangular.LATITUDE_OF_ORIGIN), false);
        LONGITUDE_OF_CENTRE = ObliqueMercator.createLongitude((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8812")).addName("Longitude of projection centre")).addNameAndIdentifier(Citations.OGC, AlbersEqualArea.LONGITUDE_OF_FALSE_ORIGIN)).addName(Citations.ESRI, "Longitude_Of_Center")).addNameAndIdentifier(Citations.GEOTIFF, Equirectangular.LONGITUDE_OF_ORIGIN)).addName(Citations.PROJ4, "lonc"));
        AZIMUTH = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8813")).addIdentifier(Citations.GEOTIFF, "3094")).addName("Azimuth of initial line")).addName(Citations.OGC, "azimuth")).addName(Citations.ESRI, "Azimuth")).addName(Citations.GEOTIFF, "AzimuthAngle")).addName(Citations.PROJ4, "alpha")).createBounded(-360.0, 360.0, Double.NaN, Units.DEGREE);
        RECTIFIED_GRID_ANGLE = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8814")).addIdentifier(Citations.GEOTIFF, "3096")).addName("Angle from Rectified to Skew Grid")).addName(Citations.OGC, "rectified_grid_angle")).addName(Citations.ESRI, "XY_Plane_Rotation")).addName(Citations.GEOTIFF, "RectifiedGridAngle")).addName(Citations.PROJ4, "gamma")).createBounded(-360.0, 360.0, Double.NaN, Units.DEGREE);
        SCALE_FACTOR = ObliqueMercator.createScale((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addNamesAndIdentifiers(Mercator1SP.SCALE_FACTOR)).reidentify(Citations.EPSG, "8815")).reidentify(Citations.GEOTIFF, "3093")).rename(Citations.EPSG, "Scale factor on initial line")).rename(Citations.GEOTIFF, "ScaleAtCenter")).rename(Citations.NETCDF, new CharSequence[0]));
        PARAMETERS_A = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier(IDENTIFIER_A)).addName("Hotine Oblique Mercator (variant A)")).addName("Hotine Oblique Mercator")).addName(Citations.OGC, "Hotine_Oblique_Mercator")).addName(Citations.ESRI, "Hotine_Oblique_Mercator_Azimuth_Natural_Origin")).addName(Citations.ESRI, "Rectified_Skew_Orthomorphic_Natural_Origin")).addName(Citations.S57, "Hotine Oblique Mercator")).addName(Citations.S57, "HOM")).addIdentifier(Citations.S57, "5")).addName(Citations.GEOTIFF, "CT_ObliqueMercator_Hotine")).addIdentifier(Citations.GEOTIFF, "3")).createGroupForMapProjection(LATITUDE_OF_CENTRE, LONGITUDE_OF_CENTRE, AZIMUTH, RECTIFIED_GRID_ANGLE, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING);
    }
}

