/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.DiscreteSampling;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.Node;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.ucar.DimensionWrapper;
import org.apache.sis.internal.netcdf.ucar.FeaturesWrapper;
import org.apache.sis.internal.netcdf.ucar.GridWrapper;
import org.apache.sis.internal.netcdf.ucar.GroupWrapper;
import org.apache.sis.internal.netcdf.ucar.LogAdapter;
import org.apache.sis.internal.netcdf.ucar.Utils;
import org.apache.sis.internal.netcdf.ucar.VariableWrapper;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.units.UnitException;

public final class DecoderWrapper
extends Decoder
implements CancelTask {
    private final NetcdfFile file;
    private Group[] groups;
    private transient VariableWrapper[] variables;
    private transient FeatureDataset features;
    private transient Grid[] geometries;
    private boolean done;

    public DecoderWrapper(NetcdfFile netcdfFile, GeometryLibrary geometryLibrary, StoreListeners storeListeners) {
        super(geometryLibrary, storeListeners);
        this.file = netcdfFile;
        this.groups = new Group[1];
        this.initialize();
    }

    public DecoderWrapper(String string, GeometryLibrary geometryLibrary, StoreListeners storeListeners) throws IOException {
        super(geometryLibrary, storeListeners);
        DatasetUrl datasetUrl = DatasetUrl.findDatasetUrl((String)string);
        this.file = NetcdfDatasets.openDataset((DatasetUrl)datasetUrl, Collections.singleton(NetcdfDataset.Enhance.CoordSystems), (int)-1, (CancelTask)this, null);
        this.groups = new Group[1];
        this.initialize();
    }

    @Override
    public String getFilename() {
        String string = Utils.nonEmpty(this.file.getLocation());
        if (string != null) {
            int n = string.lastIndexOf(File.separatorChar);
            if (n < 0 && File.separatorChar != '/') {
                n = string.lastIndexOf(47);
            }
            if (n >= 0) {
                string = string.substring(n + 1);
            }
        }
        return string;
    }

    @Override
    public String[] getFormatDescription() {
        String string = Utils.nonEmpty(this.file.getFileTypeVersion());
        String[] stringArray = new String[string != null ? 3 : 2];
        switch (stringArray.length) {
            default: {
                stringArray[2] = string;
            }
            case 2: {
                stringArray[1] = this.file.getFileTypeDescription();
            }
            case 1: {
                stringArray[0] = this.file.getFileTypeId();
            }
            case 0: 
        }
        return stringArray;
    }

    @Override
    public void setSearchPath(String ... stringArray) {
        Group[] groupArray = new Group[stringArray.length];
        int n = 0;
        for (String string : stringArray) {
            if (string != null) {
                Group group = this.file.findGroup(string);
                if (group == null) continue;
                groupArray[n] = group;
            }
            ++n;
        }
        this.groups = ArraysExt.resize(groupArray, n);
    }

    @Override
    public String[] getSearchPath() {
        String[] stringArray = new String[this.groups.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Group group = this.groups[i];
            if (group == null) continue;
            stringArray[i] = group.getShortName();
        }
        return stringArray;
    }

    @Override
    public Collection<String> getAttributeNames() {
        return VariableWrapper.toNames(this.file.getGlobalAttributes());
    }

    private Attribute findAttribute(Group group, String string) {
        String string2;
        Attribute attribute;
        Attribute attribute2 = attribute = group != null ? group.attributes().findAttributeIgnoreCase(string) : this.file.findGlobalAttributeIgnoreCase(string);
        if (attribute == null && (string2 = this.convention().mapAttributeName(string)) != string) {
            attribute = group != null ? group.attributes().findAttributeIgnoreCase(string2) : this.file.findGlobalAttributeIgnoreCase(string2);
        }
        return attribute;
    }

    @Override
    public String stringValue(String string) {
        if (string != null) {
            for (Group group : this.groups) {
                Attribute attribute = this.findAttribute(group, string);
                if (attribute == null || !attribute.isString()) continue;
                return Utils.nonEmpty(attribute.getStringValue());
            }
        }
        return null;
    }

    @Override
    public Number numericValue(String string) {
        if (string != null) {
            for (Group group : this.groups) {
                Attribute attribute = this.findAttribute(group, string);
                if (attribute == null) continue;
                Number number = attribute.getNumericValue();
                if (number != null) {
                    return Utils.fixSign(number, attribute.getDataType().isUnsigned());
                }
                String string2 = Utils.nonEmpty(attribute.getStringValue());
                if (string2 == null) continue;
                return this.parseNumber(string, string2);
            }
        }
        return null;
    }

    @Override
    public Date dateValue(String string) {
        if (string != null) {
            for (Group group : this.groups) {
                CalendarDate calendarDate;
                String string2;
                Attribute attribute = this.findAttribute(group, string);
                if (attribute == null || !attribute.isString() || (string2 = Utils.nonEmpty(attribute.getStringValue())) == null) continue;
                try {
                    calendarDate = CalendarDateFormatter.isoStringToCalendarDate(Calendar.proleptic_gregorian, string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.listeners.warning(illegalArgumentException);
                    continue;
                }
                return new Date(calendarDate.getMillis());
            }
        }
        return null;
    }

    @Override
    public Date[] numberToDate(String string, Number ... numberArray) {
        DateUnit dateUnit;
        Date[] dateArray = new Date[numberArray.length];
        try {
            dateUnit = new DateUnit(string);
        }
        catch (UnitException unitException) {
            this.listeners.warning(unitException);
            return dateArray;
        }
        for (int i = 0; i < numberArray.length; ++i) {
            Number number = numberArray[i];
            if (number == null) continue;
            dateArray[i] = dateUnit.makeDate(number.doubleValue());
        }
        return dateArray;
    }

    @Override
    public String getId() {
        return Utils.nonEmpty(this.file.getId());
    }

    @Override
    public String getTitle() {
        return Utils.nonEmpty(this.file.getTitle());
    }

    @Override
    public Variable[] getVariables() {
        if (this.variables == null) {
            ImmutableList immutableList = this.file.getVariables();
            this.variables = new VariableWrapper[immutableList != null ? immutableList.size() : 0];
            for (int i = 0; i < this.variables.length; ++i) {
                this.variables[i] = new VariableWrapper(this, (ucar.nc2.Variable)immutableList.get(i));
            }
        }
        return this.variables;
    }

    final VariableWrapper getWrapperFor(ucar.nc2.Variable variable) {
        for (VariableWrapper variableWrapper : (VariableWrapper[])this.getVariables()) {
            if (!variableWrapper.isWrapperFor(variable)) continue;
            return variableWrapper;
        }
        return new VariableWrapper(this, variable);
    }

    @Override
    public DiscreteSampling[] getDiscreteSampling(Object object) throws IOException, DataStoreException {
        List<FeatureCollection> list;
        if (this.features == null && this.file instanceof NetcdfDataset) {
            this.features = FeatureDatasetFactoryManager.wrap(null, (NetcdfDataset)this.file, this, new Formatter(new LogAdapter(this.listeners), this.listeners.getLocale()));
        }
        if (this.features instanceof FeatureDatasetPoint && (list = ((FeatureDatasetPoint)this.features).getPointFeatureCollectionList()) != null && !list.isEmpty()) {
            DiscreteSampling[] discreteSamplingArray = new FeaturesWrapper[list.size()];
            try {
                for (int i = 0; i < discreteSamplingArray.length; ++i) {
                    discreteSamplingArray[i] = new FeaturesWrapper((DsgFeatureCollection)list.get(i), this.geomlib, this.listeners, object);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DataStoreException(illegalArgumentException.getLocalizedMessage(), illegalArgumentException);
            }
            return discreteSamplingArray;
        }
        return super.getDiscreteSampling(object);
    }

    @Override
    public Grid[] getGrids() throws IOException {
        if (this.geometries == null) {
            ImmutableList immutableList = Collections.emptyList();
            if (this.file instanceof NetcdfDataset) {
                NetcdfDataset netcdfDataset = (NetcdfDataset)this.file;
                immutableList = netcdfDataset.getCoordinateSystems();
            }
            this.geometries = new Grid[immutableList.size()];
            for (int i = 0; i < this.geometries.length; ++i) {
                this.geometries[i] = new GridWrapper((CoordinateSystem)immutableList.get(i));
            }
        }
        return this.geometries;
    }

    @Override
    protected Dimension findDimension(String string) {
        ucar.nc2.Dimension dimension = this.file.findDimension(string);
        return dimension != null ? new DimensionWrapper(dimension) : null;
    }

    @Override
    protected Variable findVariable(String string) {
        ucar.nc2.Variable variable = this.file.findVariable(string);
        return variable != null ? this.getWrapperFor(variable) : null;
    }

    @Override
    protected Node findNode(String string) {
        ucar.nc2.Variable variable = this.file.findVariable(string);
        if (variable != null) {
            return this.getWrapperFor(variable);
        }
        Group group = this.file.findGroup(string);
        return group != null ? new GroupWrapper(this, group) : null;
    }

    @Override
    public void addAttributesTo(TreeTable.Node node) {
        this.addAttributesTo(node, this.file.getRootGroup());
    }

    private void addAttributesTo(TreeTable.Node node, Group group) {
        TreeTable.Node node2;
        for (Group cDMNode : group.getGroups()) {
            node2 = node.newChild();
            node2.setValue(TableColumn.NAME, cDMNode.getShortName());
            this.addAttributesTo(node2, cDMNode);
        }
        for (ucar.nc2.Variable variable : group.getVariables()) {
            node2 = node.newChild();
            node2.setValue(TableColumn.NAME, variable.getShortName());
            DecoderWrapper.addAttributesTo(node2, (Iterable<Attribute>)((Object)variable.attributes()));
        }
        DecoderWrapper.addAttributesTo(node, (Iterable<Attribute>)((Object)group.attributes()));
    }

    private static void addAttributesTo(TreeTable.Node node, Iterable<Attribute> iterable) {
        if (iterable != null) {
            block4: for (Attribute attribute : iterable) {
                Object[] objectArray;
                TreeTable.Node node2 = node.newChild();
                node2.setValue(TableColumn.NAME, attribute.getShortName());
                int n = attribute.getLength();
                switch (n) {
                    case 0: {
                        continue block4;
                    }
                    case 1: {
                        objectArray = attribute.getValue(0);
                        break;
                    }
                    default: {
                        Object[] objectArray2 = new Object[n];
                        for (int i = 0; i < n; ++i) {
                            objectArray2[i] = attribute.getValue(i);
                        }
                        objectArray = objectArray2;
                        break;
                    }
                }
                node2.setValue(TableColumn.VALUE, objectArray);
            }
        }
    }

    @Override
    public boolean isCancel() {
        return this.canceled;
    }

    @Override
    public void setProgress(String string, int n) {
    }

    @Override
    public void setError(String string) {
        this.listeners.warning(string);
    }

    public void setDone(boolean bl) {
        this.done = bl;
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public void close() throws IOException {
        if (this.features != null) {
            this.features.close();
            this.features = null;
        }
        this.file.close();
    }

    public String toString() {
        return "UCAR driver: \u201c" + this.getFilename() + '\u201d';
    }
}

