/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.j2d;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWithCRS;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.j2d.Factory;
import org.apache.sis.internal.feature.j2d.PointWrapper;
import org.apache.sis.internal.feature.j2d.ShapeProperties;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.internal.geoapi.filter.SpatialOperatorName;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.referencing.j2d.ShapeUtilities;
import org.apache.sis.util.ArraysExt;
import org.opengis.geometry.DirectPosition;

final class Wrapper
extends GeometryWithCRS<Shape> {
    final Shape geometry;
    private static final BiPredicate<Wrapper, Object>[] PREDICATES = new BiPredicate[SpatialOperatorName.OVERLAPS.ordinal() + 1];

    Wrapper(Shape shape) {
        this.geometry = shape;
    }

    @Override
    public Geometries<Shape> factory() {
        return Factory.INSTANCE;
    }

    @Override
    public Object implementation() {
        return this.geometry;
    }

    private Area area() {
        return this.geometry instanceof Area ? (Area)this.geometry : new Area(this.geometry);
    }

    @Override
    public GeneralEnvelope getEnvelope() {
        Rectangle2D rectangle2D = this.geometry.getBounds2D();
        GeneralEnvelope generalEnvelope = this.createEnvelope();
        generalEnvelope.setRange(0, rectangle2D.getMinX(), rectangle2D.getMaxX());
        generalEnvelope.setRange(1, rectangle2D.getMinY(), rectangle2D.getMaxY());
        return generalEnvelope;
    }

    @Override
    public DirectPosition getCentroid() {
        RectangularShape rectangularShape = this.geometry instanceof RectangularShape ? (RectangularShape)this.geometry : this.geometry.getBounds2D();
        return new DirectPosition2D(this.getCoordinateReferenceSystem(), rectangularShape.getCenterX(), rectangularShape.getCenterY());
    }

    @Override
    public double[] getPointCoordinates() {
        return null;
    }

    @Override
    public double[] getAllCoordinates() {
        List<double[]> list = new ShapeProperties(this.geometry).coordinatesAsDoubles();
        switch (list.size()) {
            case 0: {
                return ArraysExt.EMPTY_DOUBLE;
            }
            case 1: {
                return list.get(0);
            }
        }
        double[] dArray2 = new double[list.stream().mapToInt(dArray -> ((double[])dArray).length).sum()];
        int n = 0;
        for (double[] dArray3 : list) {
            System.arraycopy(dArray3, 0, dArray2, n, dArray3.length);
            n += dArray3.length;
        }
        return dArray2;
    }

    @Override
    protected Shape mergePolylines(Iterator<?> iterator) {
        return Wrapper.mergePolylines(this.geometry, iterator);
    }

    static Shape mergePolylines(Object object, Iterator<?> iterator) {
        boolean bl = ShapeUtilities.isFloat(object);
        Path2D path2D = bl ? new Path2D.Float() : new Path2D.Double();
        boolean bl2 = false;
        block0: while (true) {
            if (object instanceof Point2D) {
                double d = ((Point2D)object).getX();
                double d2 = ((Point2D)object).getY();
                if (Double.isNaN(d) || Double.isNaN(d2)) {
                    bl2 = false;
                } else if (bl2) {
                    path2D.lineTo(d, d2);
                } else {
                    path2D.moveTo(d, d2);
                    bl2 = true;
                }
            } else {
                path2D.append((Shape)object, false);
                bl2 = false;
            }
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object == null) continue;
                if (!bl || ShapeUtilities.isFloat(object)) continue block0;
                path2D = new Path2D.Double(path2D);
                bl = false;
                continue block0;
            }
            break;
        }
        return ShapeUtilities.toPrimitive(path2D);
    }

    @Override
    protected boolean predicateSameCRS(SpatialOperatorName spatialOperatorName, GeometryWrapper<Shape> geometryWrapper) {
        BiPredicate<Wrapper, Object> biPredicate;
        int n = spatialOperatorName.ordinal();
        if (n >= 0 && n < PREDICATES.length && (biPredicate = PREDICATES[n]) != null) {
            return biPredicate.test(this, geometryWrapper);
        }
        return super.predicateSameCRS(spatialOperatorName, geometryWrapper);
    }

    @Override
    protected Object operationSameCRS(SQLMM sQLMM, GeometryWrapper<Shape> geometryWrapper, Object object) {
        Shape shape;
        switch (sQLMM) {
            case ST_Dimension: 
            case ST_CoordDim: {
                return 2;
            }
            case ST_Is3D: 
            case ST_IsMeasured: {
                return Boolean.FALSE;
            }
            case ST_IsEmpty: {
                if (this.geometry instanceof RectangularShape) {
                    return ((RectangularShape)this.geometry).isEmpty();
                }
                return this.geometry.getPathIterator(null).isDone();
            }
            case ST_Overlaps: 
            case ST_Intersects: {
                return this.intersect(geometryWrapper);
            }
            case ST_Disjoint: {
                return !this.intersect(geometryWrapper);
            }
            case ST_Contains: {
                return this.contain(geometryWrapper);
            }
            case ST_Within: {
                return this.within(geometryWrapper);
            }
            case ST_Equals: {
                return this.equal(geometryWrapper);
            }
            case ST_Envelope: {
                return this.getEnvelope();
            }
            case ST_Boundary: {
                shape = this.geometry.getBounds2D();
                break;
            }
            case ST_Centroid: {
                RectangularShape rectangularShape = this.geometry instanceof RectangularShape ? (RectangularShape)this.geometry : this.geometry.getBounds2D();
                return new Point2D.Double(rectangularShape.getCenterX(), rectangularShape.getCenterY());
            }
            case ST_Intersection: {
                Area area = new Area(this.geometry);
                area.intersect(((Wrapper)geometryWrapper).area());
                shape = area;
                break;
            }
            case ST_Union: {
                Area area = new Area(this.geometry);
                area.add(((Wrapper)geometryWrapper).area());
                shape = area;
                break;
            }
            case ST_Difference: {
                Area area = new Area(this.geometry);
                area.subtract(((Wrapper)geometryWrapper).area());
                shape = area;
                break;
            }
            case ST_SymDifference: {
                Area area = new Area(this.geometry);
                area.exclusiveOr(((Wrapper)geometryWrapper).area());
                shape = area;
                break;
            }
            default: {
                return super.operationSameCRS(sQLMM, geometryWrapper, object);
            }
        }
        return shape;
    }

    private boolean equal(Object object) {
        if (object instanceof Wrapper) {
            Shape shape = ((Wrapper)object).geometry;
            PathIterator pathIterator = this.geometry.getPathIterator(null);
            PathIterator pathIterator2 = shape.getPathIterator(null);
            if (pathIterator.getWindingRule() == pathIterator2.getWindingRule()) {
                double[] dArray = new double[6];
                double[] dArray2 = new double[6];
                block5: while (!pathIterator.isDone()) {
                    int n;
                    if (pathIterator2.isDone()) {
                        return false;
                    }
                    int n2 = pathIterator.currentSegment(dArray);
                    if (n2 != pathIterator2.currentSegment(dArray2)) {
                        return false;
                    }
                    pathIterator.next();
                    pathIterator2.next();
                    switch (n2) {
                        case 4: {
                            continue block5;
                        }
                        case 0: 
                        case 1: {
                            n = 2;
                            break;
                        }
                        case 2: {
                            n = 4;
                            break;
                        }
                        default: {
                            n = 6;
                        }
                    }
                    if (JDK9.equals(dArray, 0, n, dArray2, 0, n)) continue;
                    return false;
                }
                return pathIterator2.isDone();
            }
        }
        return false;
    }

    private boolean within(Object object) {
        if (object instanceof Wrapper) {
            Shape shape = ((Wrapper)object).geometry;
            return shape.contains(this.geometry.getBounds2D());
        }
        return false;
    }

    private boolean contain(Object object) {
        if (object instanceof PointWrapper) {
            return this.geometry.contains(((PointWrapper)object).point);
        }
        Shape shape = ((Wrapper)object).geometry;
        return this.geometry.contains(shape.getBounds2D());
    }

    private boolean intersect(Object object) {
        if (object instanceof PointWrapper) {
            return this.geometry.contains(((PointWrapper)object).point);
        }
        Shape shape = ((Wrapper)object).geometry;
        return this.geometry.intersects(shape.getBounds2D()) && shape.intersects(this.geometry.getBounds2D());
    }

    private boolean bbox(Object object) {
        if (object instanceof PointWrapper) {
            return this.geometry.contains(((PointWrapper)object).point);
        }
        Shape shape = ((Wrapper)object).geometry;
        return this.geometry.intersects(shape.getBounds2D());
    }

    @Override
    public String formatWKT(double d) {
        return new ShapeProperties(this.geometry).toWKT(d);
    }

    static {
        BiPredicate<Wrapper, Object> biPredicate = Wrapper::intersect;
        Wrapper.PREDICATES[SpatialOperatorName.INTERSECTS.ordinal()] = biPredicate;
        Wrapper.PREDICATES[SpatialOperatorName.OVERLAPS.ordinal()] = biPredicate;
        Wrapper.PREDICATES[SpatialOperatorName.CONTAINS.ordinal()] = Wrapper::contain;
        Wrapper.PREDICATES[SpatialOperatorName.WITHIN.ordinal()] = Wrapper::within;
        Wrapper.PREDICATES[SpatialOperatorName.BBOX.ordinal()] = Wrapper::bbox;
        Wrapper.PREDICATES[SpatialOperatorName.EQUALS.ordinal()] = Wrapper::equal;
        Wrapper.PREDICATES[SpatialOperatorName.DISJOINT.ordinal()] = (wrapper, object) -> !wrapper.intersect(object);
    }
}

