/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.internal.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;

abstract class PathConverter<S, T>
extends SystemConverter<S, T> {
    private static final long serialVersionUID = 4361503025580262022L;

    PathConverter(Class<S> clazz, Class<T> clazz2) {
        super(clazz, clazz2);
    }

    @Override
    public final Set<FunctionProperty> properties() {
        return EnumSet.of(FunctionProperty.INJECTIVE, FunctionProperty.INVERTIBLE);
    }

    @Override
    public final T apply(S s2) throws UnconvertibleObjectException {
        if (s2 == null) {
            return null;
        }
        try {
            return this.doConvert(s2);
        }
        catch (Exception exception) {
            throw new UnconvertibleObjectException(this.formatErrorMessage(s2), exception);
        }
    }

    abstract T doConvert(S var1) throws Exception;

    public static final class URI_URL
    extends PathConverter<URI, URL> {
        private static final long serialVersionUID = 5478354821309176895L;
        static final URI_URL INSTANCE = new URI_URL();

        public URI_URL() {
            super(URI.class, URL.class);
        }

        @Override
        public ObjectConverter<URI, URL> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<URL, URI> inverse() {
            return URL_URI.INSTANCE;
        }

        @Override
        public URL doConvert(URI uRI) throws MalformedURLException {
            return uRI.toURL();
        }
    }

    public static final class URL_URI
    extends PathConverter<URL, URI> {
        private static final long serialVersionUID = 6327568235014244008L;
        static final URL_URI INSTANCE = new URL_URI();

        public URL_URI() {
            super(URL.class, URI.class);
        }

        @Override
        public ObjectConverter<URL, URI> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<URI, URL> inverse() {
            return URI_URL.INSTANCE;
        }

        @Override
        public URI doConvert(URL uRL) throws URISyntaxException {
            return uRL.toURI();
        }
    }

    public static final class URIFile
    extends PathConverter<URI, File> {
        private static final long serialVersionUID = 5070991554943811760L;
        static final URIFile INSTANCE = new URIFile();

        public URIFile() {
            super(URI.class, File.class);
        }

        @Override
        public ObjectConverter<URI, File> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<File, URI> inverse() {
            return FileURI.INSTANCE;
        }

        @Override
        public File doConvert(URI uRI) throws IllegalArgumentException {
            return new File(uRI);
        }
    }

    public static final class URLFile
    extends PathConverter<URL, File> {
        private static final long serialVersionUID = 3669726699184691997L;
        static final URLFile INSTANCE = new URLFile();

        public URLFile() {
            super(URL.class, File.class);
        }

        @Override
        public ObjectConverter<URL, File> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<File, URL> inverse() {
            return FileURL.INSTANCE;
        }

        @Override
        public File doConvert(URL uRL) throws URISyntaxException {
            return new File(uRL.toURI());
        }
    }

    public static final class URIPath
    extends PathConverter<URI, Path> {
        private static final long serialVersionUID = 5935532794533554151L;
        static final URIPath INSTANCE = new URIPath();

        public URIPath() {
            super(URI.class, Path.class);
        }

        @Override
        public ObjectConverter<URI, Path> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<Path, URI> inverse() {
            return PathURI.INSTANCE;
        }

        @Override
        public Path doConvert(URI uRI) throws IllegalArgumentException {
            return Paths.get(uRI);
        }
    }

    public static final class URLPath
    extends PathConverter<URL, Path> {
        private static final long serialVersionUID = 4030502499990629230L;
        static final URLPath INSTANCE = new URLPath();

        public URLPath() {
            super(URL.class, Path.class);
        }

        @Override
        public ObjectConverter<URL, Path> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<Path, URL> inverse() {
            return PathURL.INSTANCE;
        }

        @Override
        public Path doConvert(URL uRL) throws URISyntaxException {
            return Paths.get(uRL.toURI());
        }
    }

    public static final class FileURL
    extends PathConverter<File, URL> {
        private static final long serialVersionUID = 2191394598748096966L;
        static final FileURL INSTANCE = new FileURL();

        public FileURL() {
            super(File.class, URL.class);
        }

        @Override
        public ObjectConverter<File, URL> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<URL, File> inverse() {
            return URLFile.INSTANCE;
        }

        @Override
        public URL doConvert(File file) throws MalformedURLException {
            return file.toURI().toURL();
        }
    }

    public static final class FileURI
    extends PathConverter<File, URI> {
        private static final long serialVersionUID = 1122784850124333991L;
        static final FileURI INSTANCE = new FileURI();

        public FileURI() {
            super(File.class, URI.class);
        }

        @Override
        public ObjectConverter<File, URI> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<URI, File> inverse() {
            return URIFile.INSTANCE;
        }

        @Override
        public URI doConvert(File file) {
            return file.toURI();
        }
    }

    public static final class FilePath
    extends PathConverter<File, Path> {
        private static final long serialVersionUID = 6420947028493989549L;
        static final FilePath INSTANCE = new FilePath();

        public FilePath() {
            super(File.class, Path.class);
        }

        @Override
        public ObjectConverter<File, Path> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<Path, File> inverse() {
            return PathFile.INSTANCE;
        }

        @Override
        public Path doConvert(File file) {
            return file.toPath();
        }
    }

    public static final class PathFile
    extends PathConverter<Path, File> {
        private static final long serialVersionUID = 452241851474627778L;
        static final PathFile INSTANCE = new PathFile();

        public PathFile() {
            super(Path.class, File.class);
        }

        @Override
        public ObjectConverter<Path, File> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<File, Path> inverse() {
            return FilePath.INSTANCE;
        }

        @Override
        public File doConvert(Path path) throws UnsupportedOperationException {
            return path.toFile();
        }
    }

    public static final class PathURL
    extends PathConverter<Path, URL> {
        private static final long serialVersionUID = -289518201451769080L;
        static final PathURL INSTANCE = new PathURL();

        public PathURL() {
            super(Path.class, URL.class);
        }

        @Override
        public ObjectConverter<Path, URL> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<URL, Path> inverse() {
            return URLPath.INSTANCE;
        }

        @Override
        public URL doConvert(Path path) throws MalformedURLException {
            return path.toUri().toURL();
        }
    }

    public static final class PathURI
    extends PathConverter<Path, URI> {
        private static final long serialVersionUID = 740202123888081482L;
        static final PathURI INSTANCE = new PathURI();

        public PathURI() {
            super(Path.class, URI.class);
        }

        @Override
        public ObjectConverter<Path, URI> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<URI, Path> inverse() {
            return URIPath.INSTANCE;
        }

        @Override
        public URI doConvert(Path path) {
            return path.toUri();
        }
    }
}

