/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.Arrays;
import java.util.function.Supplier;
import javax.measure.Quantity;
import javax.measure.quantity.Length;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.WraparoundApplicator;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class CoordinateOperationFinder
implements Supplier<double[]> {
    private PixelInCell anchor;
    private final GridGeometry source;
    private final GridGeometry target;
    private double[] coordinates;
    private CoordinateOperation changeOfCRS;
    private boolean knowChangeOfCRS;
    private MathTransform forwardChangeOfCRS;
    private MathTransform inverseChangeOfCRS;
    private MathTransform gridToCRS;
    private MathTransform crsToGrid;
    private boolean isWraparoundNeedVerified;
    private boolean isWraparoundNeeded;
    private boolean isWraparoundApplied;
    private boolean isWraparoundDisabled;

    CoordinateOperationFinder(GridGeometry gridGeometry, GridGeometry gridGeometry2) {
        this.source = gridGeometry;
        this.target = gridGeometry2;
        this.anchor = PixelInCell.CELL_CORNER;
    }

    final void setAnchor(PixelInCell pixelInCell) {
        this.anchor = pixelInCell;
        this.gridToCRS = null;
        this.crsToGrid = null;
        if (this.coordinates != null) {
            this.coordinates = null;
            this.changeOfCRS = null;
            this.forwardChangeOfCRS = null;
            this.inverseChangeOfCRS = null;
            this.knowChangeOfCRS = false;
        }
    }

    final void nowraparound() {
        this.gridToCRS = null;
        this.crsToGrid = null;
        this.forwardChangeOfCRS = null;
        this.inverseChangeOfCRS = null;
        this.isWraparoundNeeded = false;
        this.isWraparoundApplied = true;
        this.isWraparoundNeedVerified = true;
        this.isWraparoundDisabled = true;
    }

    private CoordinateReferenceSystem getSourceCRS() {
        return this.source.isDefined(1) || this.target.isDefined(1) ? this.source.getCoordinateReferenceSystem() : null;
    }

    final CoordinateReferenceSystem getTargetCRS() {
        return this.changeOfCRS != null ? this.changeOfCRS.getTargetCRS() : this.getSourceCRS();
    }

    private CoordinateOperation changeOfCRS() throws FactoryException, TransformException {
        if (!this.knowChangeOfCRS) {
            block10: {
                ImmutableEnvelope immutableEnvelope = this.source.envelope;
                ImmutableEnvelope immutableEnvelope2 = this.target.envelope;
                try {
                    CoordinateReferenceSystem coordinateReferenceSystem;
                    CoordinateOperations.CONSTANT_COORDINATES.set(this);
                    if (immutableEnvelope != null && immutableEnvelope2 != null) {
                        this.changeOfCRS = Envelopes.findOperation(immutableEnvelope, immutableEnvelope2);
                    }
                    if (this.changeOfCRS != null || !this.target.isDefined(1) || (coordinateReferenceSystem = this.getSourceCRS()) == null) break block10;
                    DefaultGeographicBoundingBox defaultGeographicBoundingBox = null;
                    if (immutableEnvelope != null || immutableEnvelope2 != null) {
                        try {
                            defaultGeographicBoundingBox = new DefaultGeographicBoundingBox();
                            defaultGeographicBoundingBox.setBounds(immutableEnvelope2 != null ? immutableEnvelope2 : immutableEnvelope);
                        }
                        catch (TransformException transformException) {
                            defaultGeographicBoundingBox = null;
                            CoordinateOperationFinder.recoverableException("changeOfCRS", transformException);
                        }
                    }
                    this.changeOfCRS = CRS.findOperation(coordinateReferenceSystem, this.target.getCoordinateReferenceSystem(), defaultGeographicBoundingBox);
                }
                catch (BackingStoreException backingStoreException) {
                    throw backingStoreException.unwrapOrRethrow(TransformException.class);
                }
                finally {
                    CoordinateOperations.CONSTANT_COORDINATES.remove();
                }
            }
            this.knowChangeOfCRS = true;
        }
        return this.changeOfCRS;
    }

    final MathTransform gridToGrid() throws FactoryException, TransformException {
        MathTransform mathTransform;
        MathTransform mathTransform2 = this.gridToCRS();
        if (mathTransform2.equals(mathTransform = this.target.getGridToCRS(this.anchor))) {
            return MathTransforms.identity(mathTransform2.getSourceDimensions());
        }
        return MathTransforms.concatenate(mathTransform2, mathTransform.inverse());
    }

    final MathTransform gridToCRS() throws FactoryException, TransformException {
        block2: {
            block3: {
                DirectPosition directPosition;
                DirectPosition directPosition2;
                CoordinateOperation coordinateOperation;
                block4: {
                    if (this.gridToCRS != null) break block2;
                    this.gridToCRS = this.source.getGridToCRS(this.anchor);
                    coordinateOperation = this.changeOfCRS();
                    if (coordinateOperation == null) break block2;
                    if (this.forwardChangeOfCRS != null) break block3;
                    this.forwardChangeOfCRS = coordinateOperation.getMathTransform();
                    if (this.isWraparoundDisabled) break block3;
                    directPosition2 = CoordinateOperationFinder.median(this.source, this.forwardChangeOfCRS);
                    directPosition = CoordinateOperationFinder.median(this.target, null);
                    if (directPosition != null) break block4;
                    if (directPosition2 == null) break block3;
                    directPosition = directPosition2;
                    directPosition2 = null;
                }
                WraparoundApplicator wraparoundApplicator = new WraparoundApplicator(directPosition2, directPosition, coordinateOperation.getTargetCRS().getCoordinateSystem());
                this.forwardChangeOfCRS = wraparoundApplicator.forDomainOfUse(this.forwardChangeOfCRS);
            }
            this.gridToCRS = MathTransforms.concatenate(this.gridToCRS, this.forwardChangeOfCRS);
        }
        return this.gridToCRS;
    }

    final MathTransform inverse() throws FactoryException, TransformException {
        MathTransform mathTransform = this.source.getGridToCRS(this.anchor).inverse();
        CoordinateOperation coordinateOperation = this.changeOfCRS();
        if (coordinateOperation == null) {
            return mathTransform;
        }
        if (this.inverseChangeOfCRS == null) {
            this.inverseChangeOfCRS = coordinateOperation.getMathTransform().inverse();
            if (!this.isWraparoundDisabled) {
                this.isWraparoundApplied = false;
                if (!this.isWraparoundNeedVerified) {
                    this.isWraparoundNeedVerified = true;
                    MathTransform mathTransform2 = this.inverseChangeOfCRS;
                    MathTransform mathTransform3 = MathTransforms.concatenate(mathTransform2, mathTransform);
                    if (this.target.isDefined(5)) {
                        if (this.applyWraparound(mathTransform)) {
                            this.isWraparoundNeeded = this.isWraparoundNeeded(this.target.getExtent(), this.target.getGridToCRS(this.anchor), mathTransform3, null);
                        }
                    } else if (this.source.isDefined(4)) {
                        this.isWraparoundNeeded = this.isWraparoundNeeded(this.source.getExtent(), this.gridToCRS(), mathTransform3, mathTransform);
                    }
                    if (!this.isWraparoundNeeded) {
                        this.inverseChangeOfCRS = mathTransform2;
                        this.crsToGrid = mathTransform3;
                    }
                }
                if (this.isWraparoundNeeded) {
                    this.applyWraparound(mathTransform);
                }
            }
        }
        if (this.crsToGrid == null) {
            this.crsToGrid = MathTransforms.concatenate(this.inverseChangeOfCRS, mathTransform);
        }
        return this.crsToGrid;
    }

    private boolean isWraparoundNeeded(GridExtent gridExtent, MathTransform mathTransform, MathTransform mathTransform2, MathTransform mathTransform3) throws FactoryException, TransformException {
        boolean bl = this.anchor == PixelInCell.CELL_CORNER;
        int n = gridExtent.getDimension();
        int n2 = mathTransform2.getTargetDimensions();
        double[] dArray = new double[Math.max(mathTransform.getTargetDimensions(), n2)];
        double[] dArray2 = new double[Math.max(n, n2)];
        double[] dArray3 = new double[n2];
        long l = Numerics.bitmask(n);
        while (--l != 0L) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                long l2;
                long l3 = 1L << n3;
                if ((l & l3) == 0L) {
                    l2 = gridExtent.getLow(n3);
                } else {
                    l2 = gridExtent.getHigh(n3);
                    if (bl && l2 != Long.MAX_VALUE) {
                        ++l2;
                    }
                }
                dArray2[n3] = l2;
            }
            mathTransform.transform(dArray2, 0, dArray, 0, 1);
            mathTransform2.transform(dArray, 0, dArray3, 0, 1);
            if (mathTransform3 == null) {
                this.crsToGrid.transform(dArray, 0, dArray2, 0, 1);
            }
            n3 = 0;
            for (int i = 0; i < n2; ++i) {
                double d = Math.abs(dArray3[i] - dArray2[i]);
                if (d <= 1.0) continue;
                if (mathTransform3 == null) {
                    if (Double.isNaN(dArray2[i])) continue;
                    return true;
                }
                if (n3 == 0) {
                    n3 = 1;
                    if (!this.applyWraparound(mathTransform3)) {
                        return false;
                    }
                    this.crsToGrid.transform(dArray, 0, dArray, 0, 1);
                }
                double d2 = Math.abs(dArray[i] - dArray2[i]);
                double d3 = d <= Double.MAX_VALUE ? d : 1.0;
                if (!(d2 < d3)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean applyWraparound(MathTransform mathTransform) throws FactoryException, TransformException {
        if (!this.isWraparoundApplied) {
            this.isWraparoundApplied = true;
            DirectPosition directPosition = CoordinateOperationFinder.median(this.source, null);
            DirectPosition directPosition2 = CoordinateOperationFinder.median(this.target, this.inverseChangeOfCRS);
            if (directPosition == null) {
                directPosition = directPosition2;
                directPosition2 = null;
            }
            if (directPosition != null) {
                MathTransform mathTransform2 = this.inverseChangeOfCRS;
                WraparoundApplicator wraparoundApplicator = new WraparoundApplicator(directPosition2, directPosition, this.changeOfCRS().getSourceCRS().getCoordinateSystem());
                this.inverseChangeOfCRS = wraparoundApplicator.forDomainOfUse(mathTransform2);
                if (this.inverseChangeOfCRS != mathTransform2) {
                    this.crsToGrid = MathTransforms.concatenate(this.inverseChangeOfCRS, mathTransform);
                    return true;
                }
            }
        }
        return false;
    }

    private static DirectPosition median(final GridGeometry gridGeometry, final MathTransform mathTransform) throws TransformException {
        if (!gridGeometry.isDefined(12)) {
            return null;
        }
        return new AbstractDirectPosition(){
            private double[] coordinates;

            @Override
            public int getDimension() {
                return this.coordinates().length;
            }

            private double[] coordinates() {
                if (this.coordinates == null) {
                    try {
                        double[] dArray = gridGeometry.getExtent().getPointOfInterest();
                        MathTransform mathTransform2 = gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER);
                        if (mathTransform != null) {
                            mathTransform2 = MathTransforms.concatenate(mathTransform2, mathTransform);
                        }
                        this.coordinates = new double[mathTransform2.getTargetDimensions()];
                        mathTransform2.transform(dArray, 0, this.coordinates, 0, 1);
                    }
                    catch (TransformException transformException) {
                        throw new BackingStoreException(transformException);
                    }
                }
                return this.coordinates;
            }

            @Override
            public double getOrdinate(int n) {
                double d = this.coordinates()[n];
                int n2 = 10 - Math.getExponent(d);
                return Math.scalb(Math.rint(Math.scalb(d, n2)), -n2);
            }
        };
    }

    @Override
    public double[] get() {
        if (this.coordinates == null && this.target.isDefined(12)) {
            MathTransform mathTransform = this.target.getGridToCRS(this.anchor);
            this.coordinates = new double[mathTransform.getTargetDimensions()];
            double[] dArray = new double[mathTransform.getSourceDimensions()];
            Arrays.fill(dArray, Double.NaN);
            GridExtent gridExtent = this.target.getExtent();
            for (int i = 0; i < dArray.length; ++i) {
                long l = gridExtent.getLow(i);
                if (l != gridExtent.getHigh(i)) continue;
                dArray[i] = l;
            }
            try {
                mathTransform.transform(dArray, 0, this.coordinates, 0, 1);
            }
            catch (TransformException transformException) {
                throw new BackingStoreException(transformException);
            }
        }
        return this.coordinates;
    }

    final void setAccuracyOf(ImageProcessor imageProcessor) {
        double d = CRS.getLinearAccuracy(this.changeOfCRS);
        if (d > 0.0) {
            Length length = Quantities.create(d, Units.METRE);
            Quantity<?>[] quantityArray = imageProcessor.getPositionalAccuracyHints();
            for (int i = 0; i < quantityArray.length; ++i) {
                if (!Units.isLinear(quantityArray[i].getUnit())) continue;
                quantityArray[i] = length;
                length = null;
            }
            if (length != null) {
                quantityArray = ArraysExt.append(quantityArray, length);
            }
            imageProcessor.setPositionalAccuracyHints(quantityArray);
        }
    }

    private static void recoverableException(String string, Exception exception) {
        Logging.recoverableException(Logging.getLogger("org.apache.sis.raster"), CoordinateOperationFinder.class, string, exception);
    }
}

