/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dbf;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tika.exception.TikaException;

class DBFColumnHeader {
    private static final Map<Integer, ColType> COL_TYPE_MAP = new ConcurrentHashMap<Integer, ColType>();
    byte[] name;
    int fieldLength = -1;
    int decimalCount = -1;
    private ColType colType = null;

    DBFColumnHeader() {
    }

    public void setType(int type) throws TikaException {
        this.colType = COL_TYPE_MAP.get(type);
        if (this.colType == null) {
            throw new TikaException("Unrecognized column type for column: " + this.getName(StandardCharsets.US_ASCII) + ". I regret I don't recognize: " + (char)type);
        }
    }

    ColType getColType() {
        return this.colType;
    }

    String getName(Charset charset) {
        return new String(this.name, charset).trim();
    }

    public String toString() {
        return "DBFColumnHeader{name='" + this.name + "', colType=" + this.colType + ", fieldLength=" + this.fieldLength + ", decimalCount=" + this.decimalCount + "}";
    }

    static {
        for (ColType type : ColType.values()) {
            if (type.equals((Object)ColType.PLUS)) {
                COL_TYPE_MAP.put(43, ColType.PLUS);
                continue;
            }
            if (type.equals((Object)ColType.AT)) {
                COL_TYPE_MAP.put(64, ColType.AT);
                continue;
            }
            if (type.equals((Object)ColType.NULL)) {
                COL_TYPE_MAP.put(48, ColType.NULL);
                continue;
            }
            COL_TYPE_MAP.put(Integer.valueOf(type.toString().charAt(0)), type);
        }
    }

    static enum ColType {
        C,
        Y,
        D,
        T,
        B,
        I,
        G,
        P,
        F,
        L,
        M,
        N,
        PLUS,
        AT,
        O,
        NULL;

    }
}

