/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dbf;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.dbf.DBFCell;
import org.apache.tika.parser.dbf.DBFFileHeader;
import org.apache.tika.parser.dbf.DBFRow;

class DBFReader {
    public static final int MAX_FIELD_LENGTH = 66000;
    private static final Map<Integer, Version> VERSION_MAP = new ConcurrentHashMap<Integer, Version>();
    public static boolean STRICT = false;
    private final DBFFileHeader header;
    private final InputStream is;
    private DBFRow currRow = null;
    private Charset charset = StandardCharsets.US_ASCII;

    private DBFReader(InputStream is) throws IOException, TikaException {
        this.header = DBFFileHeader.parse(is);
        this.is = is;
        this.currRow = new DBFRow(this.header);
    }

    static DBFReader open(InputStream is) throws IOException, TikaException {
        return new DBFReader(is);
    }

    static Version getVersion(int b) {
        return VERSION_MAP.get(b);
    }

    public static byte[] trim(byte[] bytes) {
        int end;
        for (int i = end = bytes.length - 1; i > -1; --i) {
            if (bytes[i] == 0) continue;
            end = i;
            break;
        }
        if (end == bytes.length - 1) {
            return bytes;
        }
        byte[] ret = new byte[end + 1];
        System.arraycopy(bytes, 0, ret, 0, end + 1);
        return ret;
    }

    DBFRow next() throws IOException, TikaException {
        if (this.fillRow(this.currRow)) {
            return this.currRow;
        }
        return null;
    }

    private boolean fillRow(DBFRow row) throws IOException, TikaException {
        if (row == null) {
            return false;
        }
        DBFCell[] cells = row.cells;
        int isDeletedByte = this.is.read();
        boolean isDeleted = false;
        if (isDeletedByte != 32) {
            if (isDeletedByte == 42) {
                isDeleted = true;
            } else {
                if (isDeletedByte == 26) {
                    return false;
                }
                if (isDeletedByte == -1) {
                    if (STRICT) {
                        throw new IOException("EOF reached too early");
                    }
                    return false;
                }
                throw new TikaException("Expecting space or asterisk at beginning of record, not:" + isDeletedByte);
            }
        }
        row.setDeleted(isDeleted);
        boolean readSomeContent = false;
        for (DBFCell cell : cells) {
            if (!cell.read(this.is)) continue;
            readSomeContent = true;
        }
        return readSomeContent;
    }

    public DBFFileHeader getHeader() {
        return this.header;
    }

    public Charset getCharset() {
        return this.charset;
    }

    static {
        for (Version version : Version.values()) {
            VERSION_MAP.put(version.id, version);
        }
    }

    static enum Version {
        FOXBASE(2, "FoxBASE", ""),
        FOXBASE_PLUS(3, "FoxBASE_plus", ""),
        VISUAL_FOXPRO(48, "Visual_FoxPro", ""),
        VISUAL_FOXPRO_AUTOINCREMENT(49, "Visual_FoxPro", "autoincrement"),
        VISUAL_FOXPRO_VAR(50, "Visual_FoxPro", "Varchar_or_Varbinary"),
        DBASE_IV_SQL_TABLE(67, "dBASE_IV_SQL", "table"),
        DBASE_IV_SQL_SYSTEM(99, "dBASE_IV_SQL", "system"),
        FOX_BASE_PLUS_WITH_MEMO(131, "FoxBASE_plus", "memo"),
        DBASE_IV_WITH_MEMO(139, "dBASE_IV", "memo"),
        DBASE_IV_SQL_TABLE_WITH_MEMO(203, "dBASE_IV_SQL", "table_with_memo"),
        FOXPRO_2x_WITH_MEMO(245, "FoxPro_2.x", "memo"),
        HIPER_SIZ_WITH_SMT_MEMO(229, "HiPer-Siz", "SMT_memo"),
        FOXBASE2(251, "FoxBASE", "");

        private final int id;
        private final String format;
        private final String type;

        private Version(int id, String format, String type) {
            this.id = id;
            this.format = format;
            this.type = type;
        }

        int getId() {
            return this.id;
        }

        String getFormat() {
            return this.format;
        }

        String getType() {
            return this.type;
        }

        String getFullMimeString() {
            StringBuilder sb = new StringBuilder();
            sb.append("application/x-dbf; ").append("format=").append(this.getFormat());
            if (!"".equals(this.type)) {
                sb.append("; type=").append(this.getType());
            }
            return sb.toString();
        }
    }
}

